/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.kolun.cardtemplate.parser;

import androidx.annotation.NonNull;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.transsion.kolun.cardtemplate.bean.base.CardTemplateId;
import com.transsion.kolun.cardtemplate.bean.content.basictext.BasicTextContent;
import com.transsion.kolun.cardtemplate.bean.content.icongrid.CardContentTypeIconGrid;
import com.transsion.kolun.cardtemplate.bean.content.image.CardContentTypeImage;
import com.transsion.kolun.cardtemplate.bean.content.imagegrid.CardContentTypeImageGrid;
import com.transsion.kolun.cardtemplate.bean.content.mix.CardContentTypeMix;
import com.transsion.kolun.cardtemplate.bean.content.selectabletext.SelectableTextContent;
import com.transsion.kolun.cardtemplate.bean.content.textgrid.CardContentTypeTextGrid;
import com.transsion.kolun.cardtemplate.bean.pack.BasicTemplateData;
import com.transsion.kolun.cardtemplate.bean.pack.ImageIconGridTemplateData;
import com.transsion.kolun.cardtemplate.bean.pack.ListTemplateData;
import com.transsion.kolun.cardtemplate.bean.pack.TemplateData;
import com.transsion.kolun.cardtemplate.bean.pack.TextImageGridTemplateData;
import com.transsion.kolun.cardtemplate.layout.content.basictext.BasicTextContentLyt;
import com.transsion.kolun.cardtemplate.layout.content.icongrid.CardIconGridLyt;
import com.transsion.kolun.cardtemplate.layout.content.image.BasicImageContentLyt;
import com.transsion.kolun.cardtemplate.layout.content.imagegrid.CardImageGridLyt;
import com.transsion.kolun.cardtemplate.layout.content.mix.BasicMixContentLyt;
import com.transsion.kolun.cardtemplate.layout.content.selectabletext.SelectableTextLyt;
import com.transsion.kolun.cardtemplate.layout.content.textgrid.CardTextGridLyt;
import com.transsion.kolun.cardtemplate.layout.pack.BasicTemplateLyt;
import com.transsion.kolun.cardtemplate.layout.pack.ImageIconGridTemplateLyt;
import com.transsion.kolun.cardtemplate.layout.pack.ListTemplateLyt;
import com.transsion.kolun.cardtemplate.layout.pack.TemplateLyt;
import com.transsion.kolun.cardtemplate.layout.pack.TextImageGridTemplateLyt;
import com.transsion.kolun.cardtemplate.transport.pack.BasicTemplatePack;
import com.transsion.kolun.cardtemplate.transport.pack.ImageIconGridTemplatePack;
import com.transsion.kolun.cardtemplate.transport.pack.ListTemplatePack;
import com.transsion.kolun.cardtemplate.transport.pack.Pack;
import com.transsion.kolun.cardtemplate.transport.pack.TextImageGridTemplatePack;
import java.util.HashMap;
import java.util.Map;

public class TemplateParser
extends CardTemplateId {
    private static final Map<Integer, TypeReference<? extends Pack>> SUPPORT_PACK_MAP = new HashMap<Integer, TypeReference<? extends Pack>>();
    private static final Map<Integer, TypeReference<? extends TemplateData>> SUPPORT_TEMPLATE_DATA_MAP = new HashMap<Integer, TypeReference<? extends TemplateData>>();
    private static final Map<Integer, TypeReference<? extends TemplateLyt>> SUPPORT_TEMPLATE_LYT_MAP = new HashMap<Integer, TypeReference<? extends TemplateLyt>>();
    private static final Map<Integer, String> SUPPORT_TEMPLATE_LYT_RES_NAME_MAP = new HashMap<Integer, String>();

    public static Pack parseJson2PackWithPackId(int packId, @NonNull String jsonData) {
        TypeReference<? extends Pack> type;
        if (SUPPORT_PACK_MAP.containsKey(packId) && (type = SUPPORT_PACK_MAP.get(packId)) != null) {
            return (Pack)JSON.parseObject((String)jsonData, type, (Feature[])new Feature[0]);
        }
        return null;
    }

    public static TemplateData parseJson2CardData(int templateId, @NonNull String jsonCardData) {
        TypeReference<? extends TemplateData> type;
        if (SUPPORT_TEMPLATE_DATA_MAP.containsKey(templateId) && (type = SUPPORT_TEMPLATE_DATA_MAP.get(templateId)) != null) {
            return (TemplateData)JSON.parseObject((String)jsonCardData, type, (Feature[])new Feature[0]);
        }
        return null;
    }

    public static TemplateLyt parseJson2CardLyt(int templateId, @NonNull String jsonLayoutData) {
        TypeReference<? extends TemplateLyt> type;
        if (SUPPORT_TEMPLATE_LYT_MAP.containsKey(templateId) && (type = SUPPORT_TEMPLATE_LYT_MAP.get(templateId)) != null) {
            return (TemplateLyt)JSON.parseObject((String)jsonLayoutData, type, (Feature[])new Feature[0]);
        }
        return null;
    }

    public static String getTemplateLytResName(@NonNull int templateId) {
        if (templateId != -1) {
            return SUPPORT_TEMPLATE_LYT_RES_NAME_MAP.get(templateId);
        }
        return null;
    }

    static {
        SUPPORT_PACK_MAP.put(1000, (TypeReference<? extends Pack>)new TypeReference<BasicTemplatePack>(){});
        SUPPORT_PACK_MAP.put(1001, (TypeReference<? extends Pack>)new TypeReference<ImageIconGridTemplatePack>(){});
        SUPPORT_PACK_MAP.put(1002, (TypeReference<? extends Pack>)new TypeReference<TextImageGridTemplatePack>(){});
        SUPPORT_PACK_MAP.put(1003, (TypeReference<? extends Pack>)new TypeReference<ListTemplatePack>(){});
        SUPPORT_TEMPLATE_DATA_MAP.put(11000, (TypeReference<? extends TemplateData>)new TypeReference<BasicTemplateData<BasicTextContent>>(){});
        SUPPORT_TEMPLATE_DATA_MAP.put(41000, (TypeReference<? extends TemplateData>)new TypeReference<BasicTemplateData<CardContentTypeImageGrid>>(){});
        SUPPORT_TEMPLATE_DATA_MAP.put(51000, (TypeReference<? extends TemplateData>)new TypeReference<BasicTemplateData<CardContentTypeIconGrid>>(){});
        SUPPORT_TEMPLATE_DATA_MAP.put(61000, (TypeReference<? extends TemplateData>)new TypeReference<BasicTemplateData<CardContentTypeTextGrid>>(){});
        SUPPORT_TEMPLATE_DATA_MAP.put(21000, (TypeReference<? extends TemplateData>)new TypeReference<BasicTemplateData<CardContentTypeImage>>(){});
        SUPPORT_TEMPLATE_DATA_MAP.put(31000, (TypeReference<? extends TemplateData>)new TypeReference<BasicTemplateData<CardContentTypeMix>>(){});
        SUPPORT_TEMPLATE_DATA_MAP.put(11003, (TypeReference<? extends TemplateData>)new TypeReference<ListTemplateData<BasicTextContent>>(){});
        SUPPORT_TEMPLATE_DATA_MAP.put(21003, (TypeReference<? extends TemplateData>)new TypeReference<ListTemplateData<CardContentTypeImage>>(){});
        SUPPORT_TEMPLATE_DATA_MAP.put(31003, (TypeReference<? extends TemplateData>)new TypeReference<ListTemplateData<CardContentTypeMix>>(){});
        SUPPORT_TEMPLATE_DATA_MAP.put(71003, (TypeReference<? extends TemplateData>)new TypeReference<ListTemplateData<SelectableTextContent>>(){});
        SUPPORT_TEMPLATE_DATA_MAP.put(1001, (TypeReference<? extends TemplateData>)new TypeReference<ImageIconGridTemplateData>(){});
        SUPPORT_TEMPLATE_DATA_MAP.put(1002, (TypeReference<? extends TemplateData>)new TypeReference<TextImageGridTemplateData>(){});
        SUPPORT_TEMPLATE_LYT_MAP.put(11000, (TypeReference<? extends TemplateLyt>)new TypeReference<BasicTemplateLyt<BasicTextContentLyt>>(){});
        SUPPORT_TEMPLATE_LYT_MAP.put(41000, (TypeReference<? extends TemplateLyt>)new TypeReference<BasicTemplateLyt<CardImageGridLyt>>(){});
        SUPPORT_TEMPLATE_LYT_MAP.put(51000, (TypeReference<? extends TemplateLyt>)new TypeReference<BasicTemplateLyt<CardIconGridLyt>>(){});
        SUPPORT_TEMPLATE_LYT_MAP.put(61000, (TypeReference<? extends TemplateLyt>)new TypeReference<BasicTemplateLyt<CardTextGridLyt>>(){});
        SUPPORT_TEMPLATE_LYT_MAP.put(21000, (TypeReference<? extends TemplateLyt>)new TypeReference<BasicTemplateLyt<BasicImageContentLyt>>(){});
        SUPPORT_TEMPLATE_LYT_MAP.put(31000, (TypeReference<? extends TemplateLyt>)new TypeReference<BasicTemplateLyt<BasicMixContentLyt>>(){});
        SUPPORT_TEMPLATE_LYT_MAP.put(11003, (TypeReference<? extends TemplateLyt>)new TypeReference<ListTemplateLyt<BasicTextContentLyt>>(){});
        SUPPORT_TEMPLATE_LYT_MAP.put(21003, (TypeReference<? extends TemplateLyt>)new TypeReference<ListTemplateLyt<BasicImageContentLyt>>(){});
        SUPPORT_TEMPLATE_LYT_MAP.put(31003, (TypeReference<? extends TemplateLyt>)new TypeReference<ListTemplateLyt<BasicMixContentLyt>>(){});
        SUPPORT_TEMPLATE_LYT_MAP.put(71003, (TypeReference<? extends TemplateLyt>)new TypeReference<ListTemplateLyt<SelectableTextLyt>>(){});
        SUPPORT_TEMPLATE_LYT_MAP.put(1002, (TypeReference<? extends TemplateLyt>)new TypeReference<TextImageGridTemplateLyt>(){});
        SUPPORT_TEMPLATE_LYT_MAP.put(1001, (TypeReference<? extends TemplateLyt>)new TypeReference<ImageIconGridTemplateLyt>(){});
        SUPPORT_TEMPLATE_LYT_RES_NAME_MAP.put(11000, "sdk_koluncard_basic_text_template");
        SUPPORT_TEMPLATE_LYT_RES_NAME_MAP.put(41000, "sdk_koluncard_image_grid_template");
        SUPPORT_TEMPLATE_LYT_RES_NAME_MAP.put(51000, "sdk_koluncard_icon_grid_template");
        SUPPORT_TEMPLATE_LYT_RES_NAME_MAP.put(61000, "sdk_koluncard_text_grid_template");
        SUPPORT_TEMPLATE_LYT_RES_NAME_MAP.put(21000, "sdk_koluncard_image_text_template");
        SUPPORT_TEMPLATE_LYT_RES_NAME_MAP.put(31000, "sdk_koluncard_mix_type_template");
        SUPPORT_TEMPLATE_LYT_RES_NAME_MAP.put(11003, "sdk_koluncard_text_list_template");
        SUPPORT_TEMPLATE_LYT_RES_NAME_MAP.put(31003, "sdk_koluncard_mix_list_template");
        SUPPORT_TEMPLATE_LYT_RES_NAME_MAP.put(21003, "sdk_koluncard_image_text_list_template");
        SUPPORT_TEMPLATE_LYT_RES_NAME_MAP.put(71003, "sdk_koluncard_selectable_text_list_template");
        SUPPORT_TEMPLATE_LYT_RES_NAME_MAP.put(1002, "sdk_koluncard_group_text_image_template");
        SUPPORT_TEMPLATE_LYT_RES_NAME_MAP.put(1001, "sdk_koluncard_group_image_icon_template");
    }
}

