/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.kolun.cardtemplate;

import android.graphics.Bitmap;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IImageInterface
extends IInterface {
    public Bitmap getBitmap(String var1, String var2) throws RemoteException;

    public Bitmap getSubscriptionBitmap(long var1, String var3, int var4) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IImageInterface {
        private static final String DESCRIPTOR = "com.transsion.kolun.cardtemplate.IImageInterface";
        static final int TRANSACTION_getBitmap = 1;
        static final int TRANSACTION_getSubscriptionBitmap = 2;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IImageInterface asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IImageInterface) {
                return (IImageInterface)iin;
            }
            return new Proxy(obj);
        }

        public IBinder asBinder() {
            return this;
        }

        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
                case 1: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    Bitmap _result = this.getBitmap(_arg0, _arg1);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    long _arg0 = data.readLong();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    Bitmap _result = this.getSubscriptionBitmap(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(IImageInterface impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static IImageInterface getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements IImageInterface {
            private IBinder mRemote;
            public static IImageInterface sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Bitmap getBitmap(String key, String packageName) throws RemoteException {
                Bitmap _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(key);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Bitmap bitmap = Stub.getDefaultImpl().getBitmap(key, packageName);
                        return bitmap;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? (Bitmap)Bitmap.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Bitmap getSubscriptionBitmap(long cardId, String uri, int type) throws RemoteException {
                Bitmap _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeLong(cardId);
                    _data.writeString(uri);
                    _data.writeInt(type);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Bitmap bitmap = Stub.getDefaultImpl().getSubscriptionBitmap(cardId, uri, type);
                        return bitmap;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? (Bitmap)Bitmap.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements IImageInterface {
        @Override
        public Bitmap getBitmap(String key, String packageName) throws RemoteException {
            return null;
        }

        @Override
        public Bitmap getSubscriptionBitmap(long cardId, String uri, int type) throws RemoteException {
            return null;
        }

        public IBinder asBinder() {
            return null;
        }
    }
}

