/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.kolun.cardtemplate;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import com.transsion.kolun.cardtemplate.ISubscriptionListener;

public interface ISubscriptionInterface
extends IInterface {
    public void registerSubscriptionListener(String var1, String var2, ISubscriptionListener var3, boolean var4) throws RemoteException;

    public void requestAllSubscriptionInfo(String var1, String var2) throws RemoteException;

    public boolean subscribeCard(String var1, String var2, long var3, boolean var5) throws RemoteException;

    public long[] hasNewSubscription(String var1, String var2) throws RemoteException;

    public void onNewSubscriptionKnown(String var1, String var2) throws RemoteException;

    public boolean getSubscriptionMainSwitchStatus(String var1, String var2) throws RemoteException;

    public boolean toggleSubscriptionMainSwitch(String var1, String var2, boolean var3) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ISubscriptionInterface {
        private static final String DESCRIPTOR = "com.transsion.kolun.cardtemplate.ISubscriptionInterface";
        static final int TRANSACTION_registerSubscriptionListener = 1;
        static final int TRANSACTION_requestAllSubscriptionInfo = 2;
        static final int TRANSACTION_subscribeCard = 3;
        static final int TRANSACTION_hasNewSubscription = 4;
        static final int TRANSACTION_onNewSubscriptionKnown = 5;
        static final int TRANSACTION_getSubscriptionMainSwitchStatus = 6;
        static final int TRANSACTION_toggleSubscriptionMainSwitch = 7;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static ISubscriptionInterface asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof ISubscriptionInterface) {
                return (ISubscriptionInterface)iin;
            }
            return new Proxy(obj);
        }

        public IBinder asBinder() {
            return this;
        }

        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
                case 1: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    ISubscriptionListener _arg2 = ISubscriptionListener.Stub.asInterface(data.readStrongBinder());
                    boolean _arg3 = 0 != data.readInt();
                    this.registerSubscriptionListener(_arg0, _arg1, _arg2, _arg3);
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    this.requestAllSubscriptionInfo(_arg0, _arg1);
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    long _arg2 = data.readLong();
                    boolean _arg3 = 0 != data.readInt();
                    boolean _result = this.subscribeCard(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    long[] _result = this.hasNewSubscription(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeLongArray(_result);
                    return true;
                }
                case 5: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    this.onNewSubscriptionKnown(_arg0, _arg1);
                    return true;
                }
                case 6: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    boolean _result = this.getSubscriptionMainSwitchStatus(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 7: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    boolean _arg2 = 0 != data.readInt();
                    boolean _result = this.toggleSubscriptionMainSwitch(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(ISubscriptionInterface impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static ISubscriptionInterface getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements ISubscriptionInterface {
            private IBinder mRemote;
            public static ISubscriptionInterface sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerSubscriptionListener(String callingPackage, String appKey, ISubscriptionListener listener, boolean register) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    _data.writeString(appKey);
                    _data.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    _data.writeInt(register ? 1 : 0);
                    boolean _status = this.mRemote.transact(1, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().registerSubscriptionListener(callingPackage, appKey, listener, register);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void requestAllSubscriptionInfo(String callingPackage, String appKey) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    _data.writeString(appKey);
                    boolean _status = this.mRemote.transact(2, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().requestAllSubscriptionInfo(callingPackage, appKey);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean subscribeCard(String callingPackage, String appKey, long cardId, boolean subscribe) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    _data.writeString(appKey);
                    _data.writeLong(cardId);
                    _data.writeInt(subscribe ? 1 : 0);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().subscribeCard(callingPackage, appKey, cardId, subscribe);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long[] hasNewSubscription(String callingPackage, String appKey) throws RemoteException {
                long[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    _data.writeString(appKey);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        long[] lArray = Stub.getDefaultImpl().hasNewSubscription(callingPackage, appKey);
                        return lArray;
                    }
                    _reply.readException();
                    _result = _reply.createLongArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onNewSubscriptionKnown(String callingPackage, String appKey) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    _data.writeString(appKey);
                    boolean _status = this.mRemote.transact(5, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onNewSubscriptionKnown(callingPackage, appKey);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean getSubscriptionMainSwitchStatus(String callingPackage, String appKey) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    _data.writeString(appKey);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().getSubscriptionMainSwitchStatus(callingPackage, appKey);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean toggleSubscriptionMainSwitch(String callingPackage, String appKey, boolean active) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    _data.writeString(appKey);
                    _data.writeInt(active ? 1 : 0);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().toggleSubscriptionMainSwitch(callingPackage, appKey, active);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements ISubscriptionInterface {
        @Override
        public void registerSubscriptionListener(String callingPackage, String appKey, ISubscriptionListener listener, boolean register) throws RemoteException {
        }

        @Override
        public void requestAllSubscriptionInfo(String callingPackage, String appKey) throws RemoteException {
        }

        @Override
        public boolean subscribeCard(String callingPackage, String appKey, long cardId, boolean subscribe) throws RemoteException {
            return false;
        }

        @Override
        public long[] hasNewSubscription(String callingPackage, String appKey) throws RemoteException {
            return null;
        }

        @Override
        public void onNewSubscriptionKnown(String callingPackage, String appKey) throws RemoteException {
        }

        @Override
        public boolean getSubscriptionMainSwitchStatus(String callingPackage, String appKey) throws RemoteException {
            return false;
        }

        @Override
        public boolean toggleSubscriptionMainSwitch(String callingPackage, String appKey, boolean active) throws RemoteException {
            return false;
        }

        public IBinder asBinder() {
            return null;
        }
    }
}

