/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.kolun.cardtemplate;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import com.transsion.kolun.cardtemplate.IKolunBridge;
import com.transsion.kolun.cardtemplate.state.KolunServiceState;
import java.util.List;

public class KolunBridge {
    private static final String TAG = "KolunBridge";
    public static final String KEY_BINDER_CARD_ACTION_INTERFACE = "template_action_interface";
    public static final String KEY_BINDER_CARD_AGREEMENT_INTERFACE = "template_agreement_interface";
    public static final String KEY_BINDER_CARD_PRIORITY_INTERFACE = "template_card_priority_interface";
    public static final String KEY_BINDER_IMAGE_INTERFACE = "template_image_interface";
    public static final String KEY_BINDER_CARD_INTERFACE = "template_card_interface";
    public static final String KEY_BINDER_SUBSCRIPTION_INTERFACE = "template_subscription_interface";
    private static final ComponentName SERVICE_COM = new ComponentName("com.transsion.kolun.assistant", "com.transsion.kolun.assistant.cardtemplate.service.CardTemplateService");
    private static final Intent SERVICE_INTENT = new Intent().setComponent(SERVICE_COM);
    private static KolunBridge sInstance;
    private IKolunBridge mBridge;
    private ServiceConnectCallback mCallback;
    private volatile KolunServiceState.State mServiceState = KolunServiceState.State.UNKNOWN;
    private final ServiceConnection mServiceConnect = new ServiceConnection(){

        public void onServiceConnected(ComponentName name, IBinder service) {
            Log.d((String)KolunBridge.TAG, (String)("service connected : " + name));
            KolunBridge.this.mBridge = IKolunBridge.Stub.asInterface(service);
            KolunBridge.this.mServiceState = KolunServiceState.State.CONNECTED;
            if (KolunBridge.this.mCallback != null) {
                KolunBridge.this.mCallback.connectSuccessful();
            }
            try {
                service.linkToDeath(() -> {
                    Log.d((String)KolunBridge.TAG, (String)"service is died");
                    KolunBridge.this.mServiceState = KolunServiceState.State.DISCONNECTED;
                    KolunBridge.this.mBridge = null;
                    if (KolunBridge.this.mCallback != null) {
                        KolunBridge.this.mCallback.onDisconnected();
                    }
                    KolunBridge.this.mCallback = null;
                }, 1);
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }

        public void onServiceDisconnected(ComponentName name) {
            Log.d((String)KolunBridge.TAG, (String)("service disconnected : " + name));
            KolunBridge.this.mServiceState = KolunServiceState.State.DISCONNECTED;
            KolunBridge.this.mBridge = null;
            if (KolunBridge.this.mCallback != null) {
                KolunBridge.this.mCallback.onDisconnected();
            }
            KolunBridge.this.mCallback = null;
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static KolunBridge getInstance() {
        if (sInstance != null) return sInstance;
        Class<KolunBridge> clazz = KolunBridge.class;
        synchronized (KolunBridge.class) {
            if (sInstance != null) return sInstance;
            sInstance = new KolunBridge();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    void connect(Context context, ServiceConnectCallback callback, String reason) {
        this.connectService(context, callback, reason);
    }

    public Bundle getInterface(String callingPkg, String functionKey) {
        if (this.mBridge != null) {
            try {
                return this.mBridge.getInterface(callingPkg, "", functionKey);
            }
            catch (RemoteException e) {
                Log.d((String)TAG, (String)"getInterface failed");
            }
        }
        return new Bundle();
    }

    void disConnect(Context context) {
        if (this.mServiceState == KolunServiceState.State.BINDING || this.mServiceState == KolunServiceState.State.CONNECTED) {
            try {
                this.mServiceState = KolunServiceState.State.DISCONNECTED;
                context.unbindService(this.mServiceConnect);
            }
            catch (IllegalArgumentException e) {
                Log.d((String)TAG, (String)("unbind exception e: " + e));
                this.mServiceState = KolunServiceState.State.DISCONNECTED;
            }
        }
        this.mBridge = null;
        this.mCallback = null;
    }

    boolean isServiceConnect() {
        return this.mServiceState == KolunServiceState.State.CONNECTED;
    }

    KolunServiceState.State getServiceState() {
        return this.mServiceState;
    }

    boolean isServiceAvailable(Context context) {
        PackageManager pm = context.getPackageManager();
        List list = pm.queryIntentServices(SERVICE_INTENT, 131072);
        return list != null && list.size() > 0;
    }

    private void connectService(Context context, ServiceConnectCallback callback, String reason) {
        Log.d((String)TAG, (String)("connectService currentServiceState\uff1a " + (Object)((Object)this.mServiceState) + " reason: " + reason));
        if (this.mServiceState == KolunServiceState.State.CONNECTED || this.mServiceState == KolunServiceState.State.BINDING) {
            Log.d((String)TAG, (String)("service has connected or binding mServiceState\uff1a " + (Object)((Object)this.mServiceState)));
            return;
        }
        if (this.isServiceAvailable(context)) {
            if (context.bindService(SERVICE_INTENT, this.mServiceConnect, 1)) {
                Log.d((String)TAG, (String)("binderService reason: " + reason));
                this.mServiceState = KolunServiceState.State.BINDING;
                this.mCallback = callback;
            } else {
                this.mServiceState = KolunServiceState.State.REFUSE;
                Log.d((String)TAG, (String)"service refuse");
            }
        } else {
            Log.d((String)TAG, (String)"service is not available");
        }
    }

    protected static interface ServiceConnectCallback {
        public void connectSuccessful();

        public void onDisconnected();
    }
}

