/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.kolun.cardtemplate;

import android.content.Context;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStoreOwner;
import com.transsion.kolun.cardtemplate.KolunStub;
import com.transsion.kolun.cardtemplate.card.TemplateKolunCard;
import com.transsion.kolun.cardtemplate.state.KolunCardState;
import com.transsion.kolun.cardtemplate.state.KolunSubscriptionState;
import com.transsion.kolun.cardtemplate.vm.KolunCardStubVM;

public class KolunCardStub
extends KolunStub {
    private static final String TAG = "KolunCardStub";
    protected final Context context;
    protected final LifecycleOwner lifecycleOwner;
    protected final ViewModelStoreOwner modelStoreOwner;
    private final KolunCardStubVM mKolunCardStubVM;

    public KolunCardStub(Context context, LifecycleOwner owner, ViewModelStoreOwner storeOwner) {
        super(storeOwner);
        this.context = context;
        this.lifecycleOwner = owner;
        this.modelStoreOwner = storeOwner;
        this.mKolunCardStubVM = (KolunCardStubVM)new ViewModelProvider(storeOwner).get(KolunCardStubVM.class);
    }

    public KolunCardStubVM getStateVM() {
        return this.mKolunCardStubVM;
    }

    public View addView(TemplateKolunCard kolunCard, ViewGroup viewGroup, int type) {
        return this.addView(kolunCard, viewGroup, type, true);
    }

    public View addView(TemplateKolunCard kolunCard, ViewGroup viewGroup, int type, boolean isShowPopupMenu) {
        View view = null;
        if (!kolunCard.isTemplateCard()) {
            Log.d((String)TAG, (String)("updateView() called with: old kolunCard = [" + kolunCard + "], viewGroup = [" + viewGroup + "], type = [" + type + "]"));
            view = kolunCard.getKolunCard().apply(this.context, viewGroup, type, isShowPopupMenu);
        } else {
            Log.d((String)TAG, (String)("updateView() called with: kolunCard = [" + kolunCard + "], viewGroup = [" + viewGroup + "], type = [" + type + "]"));
            view = kolunCard.apply(this.context, isShowPopupMenu);
            if (view != null) {
                kolunCard.updatePack(view);
            }
        }
        return view;
    }

    public void updateView(TemplateKolunCard kolunCard, View view) {
        Log.d((String)TAG, (String)("updateView() called with: kolunCard = [" + kolunCard + "], view = [" + view + "]"));
        if (kolunCard == null || view == null) {
            Log.d((String)TAG, (String)"updateView: parm is null");
            return;
        }
        kolunCard.updatePack(view);
    }

    protected void setSubscriptionState(KolunSubscriptionState kolunSubscriptionState) {
        this.mKolunCardStubVM.setStateLiveData(kolunSubscriptionState);
    }

    protected void setCardState(KolunCardState cardState) {
        Log.i((String)TAG, (String)("setCardState: " + cardState.toString()));
        this.mKolunCardStubVM.setLiveData(cardState);
    }
}

