/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.kolun.cardtemplate;

import android.content.Context;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.WorkerThread;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.transsion.kolun.cardtemplate.ICardActionInterface;
import com.transsion.kolun.cardtemplate.KolunBridge;
import com.transsion.kolun.cardtemplate.TemplateKolunCardManager;
import com.transsion.kolun.cardtemplate.bean.base.CardAction;
import com.transsion.kolun.cardtemplate.bean.base.CardTrackingInfo;
import com.transsion.kolun.cardtemplate.utils.TrackingEventUtils;
import java.util.Arrays;

public class TemplateCardActionManager {
    private static final String TAG = "TemplateCardActionManager";
    private final String mCallingPackage;
    private final Context mContext;

    public TemplateCardActionManager(Context context, String callingPackage) {
        this.mContext = context;
        this.mCallingPackage = callingPackage;
    }

    private ICardActionInterface getCardActionInterface() {
        Bundle interfaceBundle = KolunBridge.getInstance().getInterface(this.mCallingPackage, "template_action_interface");
        if (interfaceBundle != null) {
            IBinder binder = interfaceBundle.getBinder("template_action_interface");
            ICardActionInterface iCardActionInterface = ICardActionInterface.Stub.asInterface(binder);
            if (iCardActionInterface == null) {
                Log.d((String)TAG, (String)"getCardActionInterface iCardActionInterface == null");
            }
            return iCardActionInterface;
        }
        return null;
    }

    @WorkerThread
    public void executeCardAction(CardAction cardAction) {
        if (cardAction == null) {
            Log.w((String)TAG, (String)"cardAction == null");
            return;
        }
        try {
            if (this.tryExecuteDefaultAction(cardAction)) {
                return;
            }
            String cardActionStr = JSON.toJSONString((Object)cardAction);
            ICardActionInterface iCardActionInterface = this.getCardActionInterface();
            if (iCardActionInterface != null) {
                iCardActionInterface.startActionActivity(cardActionStr);
            }
        }
        catch (RemoteException | JSONException | NumberFormatException e) {
            Log.w((String)TAG, (String)("executeCardAction Exception: " + e));
        }
    }

    private boolean tryExecuteDefaultAction(@NonNull CardAction cardAction) throws NumberFormatException {
        CardTrackingInfo trackingInfo = cardAction.getTrackingInfo();
        if (trackingInfo != null) {
            String actionType = trackingInfo.getCardTrackingEvent();
            boolean isDefaultAction = Arrays.asList(TrackingEventUtils.DEFAULT_ACTION_EVENT_LIST).contains(actionType);
            if (isDefaultAction) {
                long cardId = Long.parseLong(trackingInfo.getCardId());
                TemplateKolunCardManager.getInstance(this.mContext).tryRequestExecuteDefaultAction(cardId, actionType);
                Log.d((String)TAG, (String)("tryExecuteDefaultAction -> cardId : " + cardId + " actionType : " + actionType));
                return true;
            }
        }
        return false;
    }

    @WorkerThread
    public void sendTrackingInfo(String cardId, String trackingEvent) {
        try {
            ICardActionInterface iCardActionInterface = this.getCardActionInterface();
            if (iCardActionInterface != null) {
                iCardActionInterface.sendTrackingInfo(cardId, trackingEvent);
            }
        }
        catch (RemoteException | JSONException e) {
            Log.w((String)TAG, (String)("startActionActivity Exception: " + e));
        }
    }

    @WorkerThread
    public void sendLocalCardAction(long cardId, long contentId) {
        try {
            ICardActionInterface iCardActionInterface = this.getCardActionInterface();
            if (iCardActionInterface != null) {
                iCardActionInterface.sendLocalCardAction(cardId, String.valueOf(contentId));
            }
        }
        catch (RemoteException e) {
            Log.w((String)TAG, (String)("sendLocalCardAction Exception: " + (Object)((Object)e)));
        }
    }
}

