/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.kolun.cardtemplate;

import android.annotation.SuppressLint;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.RemoteException;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.transsion.kolun.cardtemplate.ICardInterface;
import com.transsion.kolun.cardtemplate.ICardListener;
import com.transsion.kolun.cardtemplate.ICardPriority;
import com.transsion.kolun.cardtemplate.ICardPriorityListener;
import com.transsion.kolun.cardtemplate.ISubscriptionInterface;
import com.transsion.kolun.cardtemplate.ISubscriptionListener;
import com.transsion.kolun.cardtemplate.KolunBridge;
import com.transsion.kolun.cardtemplate.KolunCardLauncherConfig;
import com.transsion.kolun.cardtemplate.KolunCardStub;
import com.transsion.kolun.cardtemplate.TemplateCardActionManager;
import com.transsion.kolun.cardtemplate.TemplateKolunProtocol;
import com.transsion.kolun.cardtemplate.bean.base.CardDeepLink;
import com.transsion.kolun.cardtemplate.card.KolunCardParser;
import com.transsion.kolun.cardtemplate.card.TemplateKolunCard;
import com.transsion.kolun.cardtemplate.engine.RenderThread;
import com.transsion.kolun.cardtemplate.engine.RenderThreadHelper;
import com.transsion.kolun.cardtemplate.parser.SubscriptionParser;
import com.transsion.kolun.cardtemplate.state.KolunCardState;
import com.transsion.kolun.cardtemplate.state.KolunErrorState;
import com.transsion.kolun.cardtemplate.state.KolunServiceState;
import com.transsion.kolun.cardtemplate.state.KolunSubscriptionState;
import com.transsion.kolun.cardtemplate.state.SpecialState;
import com.transsion.kolun.cardtemplate.subscription.SubscriptionCmsInfo;
import com.transsion.kolun.cardtemplate.subscription.SubscriptionLocalInfo;
import com.transsion.kolun.cardtemplate.transport.pack.Pack;
import com.transsion.kolun.cardtemplate.utils.CommonUtils;
import com.transsion.kolun.cardtemplate.utils.UIUtils;
import com.transsion.kolun.koluncard.IListener;
import com.transsion.kolun.koluncard.KolunCard;
import com.transsion.kolun.koluncard.KolunCardDescription;
import com.transsion.kolun.koluncard.KolunCardManager;
import com.transsion.kolun.koluncard.LauncherConfig;
import com.transsion.kolun.koluncard.PackageBroadcastReceiver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;

public class TemplateKolunCardManager {
    private static final String TAG = "KolunCardManager_template";
    public static final String ACTION_REQUIRE_PERMISSION = "com.transsion.kolun.assistant.permissionActivity";
    public static final long TEMPLATE_CARD_ID_START = 9000L;
    private static final Map<Long, TemplateKolunCard> mKolunCardMap = new ConcurrentHashMap<Long, TemplateKolunCard>();
    private static final Map<Long, TemplateKolunCard> mKolunCardMapOld = new ConcurrentHashMap<Long, TemplateKolunCard>();
    public static final int CODE_SUCCESS = 0;
    public static final int STATE_INVISIBLE = 0;
    public static final int KOLUN_CARD_ID_DEFAULT = -1;
    private static final int REFRESH_SHOW_TIME = 600;
    public static final String KOLUN_ACTION_OUT_CARD_SHOWN_SCREEN = "kolun_action_out_card_shown_screen";
    public static final String KOLUN_ACTION_IN_CARD_SHOWN_SCREEN = "kolun_action_in_card_shown_screen";
    private final ServiceListener mServiceListener = new ServiceListener();
    private final String mAppKey = "";
    private final Handler mHandler = new Handler(Looper.getMainLooper());
    private final Context mContext;
    @SuppressLint(value={"StaticFieldLeak"})
    private static TemplateKolunCardManager sInstance;
    private final TemplateCardActionManager mCardActionManager;
    private final TemplateKolunProtocol mKolunCardProtocol;
    private final KolunCardManager mRemoteManager;
    private KolunCardStub mClientStub = null;
    private final CardPriorityListener mPriorityListener = new CardPriorityListener();
    private final Map<Long, KolunCardLauncherConfig> mLauncherConfigMap = new ConcurrentHashMap<Long, KolunCardLauncherConfig>();
    private final AtomicBoolean mIsTemplateServiceReady = new AtomicBoolean(false);
    private final AtomicBoolean mIsOldServiceReady = new AtomicBoolean(false);
    private final PackageBroadcastReceiver.PackageChange mPackageChangeCallBack = new PackageBroadcastReceiver.PackageChange(){

        @Override
        public void removed() {
            TemplateKolunCardManager.this.disConnectService();
            if (TemplateKolunCardManager.this.mClientStub != null) {
                TemplateKolunCardManager.this.mClientStub.setServiceState(new KolunServiceState(KolunServiceState.State.PACKAGE_CHANGED, KolunServiceState.ServiceType.ALL));
            }
        }

        @Override
        public void replaced() {
            TemplateKolunCardManager.this.onResumeCard(true);
            TemplateKolunCardManager.this.onSubscribeResume();
        }
    };
    private final KolunBridge.ServiceConnectCallback mConnectCallback = new KolunBridge.ServiceConnectCallback(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void connectSuccessful() {
            ICardPriority iCardPriority;
            ICardInterface iCardInterface = TemplateKolunCardManager.this.getICardInterface();
            if (iCardInterface != null) {
                try {
                    iCardInterface.registerListener(TemplateKolunCardManager.this.getPackageName(), "", TemplateKolunCardManager.this.mServiceListener);
                    TemplateKolunCardManager templateKolunCardManager = TemplateKolunCardManager.this;
                    synchronized (templateKolunCardManager) {
                        if (TemplateKolunCardManager.this.pendingResume) {
                            TemplateKolunCardManager.this.sendCardShownAction(iCardInterface, TemplateKolunCardManager.KOLUN_ACTION_IN_CARD_SHOWN_SCREEN);
                        }
                    }
                }
                catch (RemoteException e1) {
                    Log.d((String)TemplateKolunCardManager.TAG, (String)("listenService failed e: " + (Object)((Object)e1)));
                }
            }
            if ((iCardPriority = TemplateKolunCardManager.this.getICardPriority()) != null) {
                try {
                    iCardPriority.setPriorityListener(TemplateKolunCardManager.this.mPriorityListener);
                }
                catch (RemoteException e) {
                    Log.d((String)TemplateKolunCardManager.TAG, (String)("listenPriority failed e: " + (Object)((Object)e)));
                }
            }
            TemplateKolunCardManager.this.onSubscriptionServicecConnectSuccessful(TemplateKolunCardManager.this.mSubscriptionServiceListener);
            TemplateKolunCardManager.this.mIsTemplateServiceReady.set(true);
            if (TemplateKolunCardManager.this.mIsOldServiceReady.get() && TemplateKolunCardManager.this.mClientStub != null) {
                TemplateKolunCardManager.this.mClientStub.setServiceState(new KolunServiceState(KolunServiceState.State.CONNECTED, KolunServiceState.ServiceType.ALL));
            }
        }

        @Override
        public void onDisconnected() {
            if (TemplateKolunCardManager.this.mClientStub != null) {
                TemplateKolunCardManager.this.mClientStub.setServiceState(new KolunServiceState(KolunServiceState.State.DISCONNECTED, KolunServiceState.ServiceType.TEMPLATE_BRIDGE));
            }
            TemplateKolunCardManager.this.unListenCardService();
            TemplateKolunCardManager.this.onSubscriptionServicecDisconnected(TemplateKolunCardManager.this.mSubscriptionServiceListener);
            TemplateKolunCardManager.this.mIsTemplateServiceReady.set(false);
        }
    };
    private boolean pendingResume = false;
    private final LocalListener mListener = new LocalListener();
    private final KolunCardManager.Callback mRemoteServiceCallback = new KolunCardManager.Callback(){

        @Override
        public void onServiceConnected() {
            Log.d((String)TemplateKolunCardManager.TAG, (String)"old callback");
            TemplateKolunCardManager.this.getRemoteManager().listen(TemplateKolunCardManager.this.mListener);
            TemplateKolunCardManager.this.mIsOldServiceReady.set(true);
            if (TemplateKolunCardManager.this.mIsTemplateServiceReady.get() && TemplateKolunCardManager.this.mClientStub != null) {
                TemplateKolunCardManager.this.mClientStub.setServiceState(new KolunServiceState(KolunServiceState.State.CONNECTED, KolunServiceState.ServiceType.ALL));
            }
        }

        @Override
        public void onServiceDisconnected() {
            TemplateKolunCardManager.this.getRemoteManager().unlisten(TemplateKolunCardManager.this.mListener);
            TemplateKolunCardManager.this.mIsOldServiceReady.set(false);
            if (TemplateKolunCardManager.this.mClientStub != null) {
                TemplateKolunCardManager.this.mClientStub.setServiceState(new KolunServiceState(KolunServiceState.State.DISCONNECTED, KolunServiceState.ServiceType.CARD_WIDGET));
            }
        }
    };
    private final SubscriptionServiceListener mSubscriptionServiceListener = new SubscriptionServiceListener();
    private final Map<Long, SubscriptionLocalInfo> mInfoMap = new ConcurrentHashMap<Long, SubscriptionLocalInfo>();
    private final Map<Long, SubscriptionLocalInfo> mInfoMapOld = new ConcurrentHashMap<Long, SubscriptionLocalInfo>();

    private TemplateKolunCardManager(Context context) {
        this.mContext = context.getApplicationContext();
        this.mRemoteManager = new KolunCardManager(context, this.mRemoteServiceCallback, 23);
        this.mKolunCardProtocol = new TemplateKolunProtocol(this.mContext, this.getRemoteManager(), this.getPackageName(), "");
        this.mCardActionManager = new TemplateCardActionManager(this.mContext, this.getPackageName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TemplateKolunCardManager getInstance(Context context) {
        if (sInstance != null) return sInstance;
        Class<TemplateKolunCardManager> clazz = TemplateKolunCardManager.class;
        synchronized (TemplateKolunCardManager.class) {
            if (sInstance != null) return sInstance;
            sInstance = new TemplateKolunCardManager(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return sInstance;
        }
    }

    public void connectService() {
        KolunBridge.getInstance().connect(this.mContext, this.mConnectCallback, "card client connect");
        this.getRemoteManager().connect();
        PackageBroadcastReceiver.connect(this.mContext).registerCallBack(this.mPackageChangeCallBack);
    }

    public void disConnectService() {
        KolunBridge bridge = KolunBridge.getInstance();
        if (bridge.isServiceConnect()) {
            KolunBridge.getInstance().disConnect(this.mContext);
        }
        this.getRemoteManager().disconnect();
        mKolunCardMapOld.clear();
        mKolunCardMap.clear();
        this.mInfoMapOld.clear();
        this.mInfoMap.clear();
        this.mIsTemplateServiceReady.set(false);
        this.mIsOldServiceReady.set(false);
    }

    public void addStub(KolunCardStub stub) {
        this.mClientStub = stub;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStub(KolunCardStub stub) {
        TemplateKolunCardManager templateKolunCardManager = this;
        synchronized (templateKolunCardManager) {
            this.pendingResume = false;
        }
        if (stub == this.mClientStub) {
            this.mClientStub = null;
            this.getRemoteManager().onPause();
            this.sendCardShownAction(null, KOLUN_ACTION_OUT_CARD_SHOWN_SCREEN);
        }
    }

    private void sendCardShownAction(ICardInterface iCardInterface, String action) {
        try {
            if (iCardInterface == null) {
                iCardInterface = this.getICardInterface();
            }
            if (iCardInterface != null) {
                iCardInterface.executeAction(this.getPackageName(), "", action, null);
            }
        }
        catch (Throwable e) {
            Log.d((String)TAG, (String)("sendCardShownAction failed " + e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onResumeCard(boolean forceRequest) {
        block12: {
            if (KolunBridge.getInstance().isServiceConnect()) {
                Log.d((String)TAG, (String)"onResumeCard  service is connected");
                try {
                    ICardInterface iCardInterface = this.getICardInterface();
                    if (iCardInterface != null) {
                        iCardInterface.requestUpdateAllCard(this.getPackageName(), "", forceRequest);
                        this.sendCardShownAction(iCardInterface, KOLUN_ACTION_IN_CARD_SHOWN_SCREEN);
                        break block12;
                    }
                    TemplateKolunCardManager templateKolunCardManager = this;
                    synchronized (templateKolunCardManager) {
                        this.pendingResume = true;
                    }
                    KolunBridge.getInstance().connect(this.mContext, this.mConnectCallback, "iCardInterface == null, card onResumeCard");
                }
                catch (Throwable e) {
                    Log.d((String)TAG, (String)("onResumeCard requestUpdateAllCard failed " + e));
                }
            } else {
                TemplateKolunCardManager templateKolunCardManager = this;
                synchronized (templateKolunCardManager) {
                    this.pendingResume = true;
                }
                Log.d((String)TAG, (String)"onResumeCard connect service now");
                KolunBridge.getInstance().connect(this.mContext, this.mConnectCallback, "card onResumeCard");
            }
        }
        this.getRemoteManager().onResume();
        if (forceRequest) {
            this.notifyCache();
        }
    }

    private void notifyCache() {
        mKolunCardMapOld.values().forEach(card -> {
            if (card.isNeedRefresh()) {
                card.setNeedRefresh(false);
                KolunCardState cardState = new KolunCardState(card.getCardId(), true, false, false, false, false);
                this.setCardState(cardState);
            }
        });
    }

    private void setCardState(KolunCardState cardState) {
        if (this.mClientStub != null) {
            this.mHandler.getLooper().getQueue().addIdleHandler(() -> {
                this.mClientStub.setCardState(cardState);
                return false;
            });
        }
    }

    public List<TemplateKolunCard> getAvailableCardList() {
        if (this.mClientStub == null) {
            return null;
        }
        List<KolunCard> kolunCardList = this.getRemoteManager().getAvailableCardList();
        if (kolunCardList != null) {
            Log.d((String)TAG, (String)("getAvailableCardList kolunCardList size: " + kolunCardList.size()));
            HashMap tempMap = new HashMap();
            kolunCardList.forEach(card -> {
                TemplateKolunCard transferCard = TemplateKolunCard.create(card);
                tempMap.put(transferCard.getCardId(), transferCard);
            });
            mKolunCardMapOld.clear();
            mKolunCardMapOld.putAll(tempMap);
        }
        return this.getTemplateCardList();
    }

    public boolean isPermissionRequestNeeded() {
        List<String> permissionList = this.querySupportedCardRequirePermissionList();
        boolean isTemplatePermissionNeed = false;
        ICardInterface iCardInterface = this.getICardInterface();
        if (iCardInterface != null) {
            try {
                isTemplatePermissionNeed = iCardInterface.needRequestPermission(this.getPackageName(), "");
            }
            catch (RemoteException e) {
                Log.d((String)TAG, (String)("get template permission failed e: " + (Object)((Object)e)));
            }
        }
        return !permissionList.isEmpty() || isTemplatePermissionNeed;
    }

    @Nullable
    @WorkerThread
    public TemplateKolunCard getCard(long cardId) {
        TemplateKolunCard templateKolunCard = mKolunCardMap.get(cardId);
        if (templateKolunCard == null) {
            templateKolunCard = mKolunCardMapOld.get(cardId);
        }
        return templateKolunCard;
    }

    public TemplateCardActionManager getCardActionManager() {
        return this.mCardActionManager;
    }

    public TemplateKolunProtocol getCardProtocol() {
        return this.mKolunCardProtocol;
    }

    @WorkerThread
    public KolunCardLauncherConfig getCardConfigById(long cardId) {
        if (this.mLauncherConfigMap.isEmpty()) {
            this.initLauncherConfig();
        }
        return this.mLauncherConfigMap.get(cardId);
    }

    @Nullable
    public long[] getNewSubscribeServiceIds() {
        ISubscriptionInterface subscriptionInterface = this.getSubscriptionInterface();
        if (subscriptionInterface != null) {
            try {
                return subscriptionInterface.hasNewSubscription(this.getPackageName(), "");
            }
            catch (RemoteException e) {
                Log.d((String)TAG, (String)"get new subscription failed");
            }
        }
        return null;
    }

    public void onNewSubscriptionKnown() {
        ISubscriptionInterface subscriptionInterface = this.getSubscriptionInterface();
        if (subscriptionInterface != null) {
            try {
                subscriptionInterface.onNewSubscriptionKnown(this.getPackageName(), "");
            }
            catch (RemoteException e) {
                Log.d((String)TAG, (String)"onNewSubscriptionKnown failed");
            }
        }
    }

    private void initLauncherConfig() {
        Set<Long> mOldCardIdSet = mKolunCardMapOld.keySet();
        for (long cardId : mOldCardIdSet) {
            TemplateKolunCard card = mKolunCardMapOld.get(cardId);
            KolunCardLauncherConfig config = this.getLauncherConfig(card);
            if (card == null || config == null) continue;
            this.mLauncherConfigMap.put(card.getCardId(), config);
        }
        ArrayList<Long> newCardIdList = new ArrayList<Long>(mKolunCardMap.keySet());
        int size = newCardIdList.size();
        long[] newCardIds = new long[size];
        for (int i = 0; i < size; ++i) {
            newCardIds[i] = (Long)newCardIdList.get(i);
        }
        try {
            String[] priority;
            ICardPriority iCardPriority = this.getICardPriority();
            if (iCardPriority != null && (priority = iCardPriority.getPriority(newCardIds)) != null) {
                for (String value : priority) {
                    String s = value;
                    if (s == null || "".equals(s)) continue;
                    KolunCardLauncherConfig launcherConfig = (KolunCardLauncherConfig)JSON.parseObject((String)s, KolunCardLauncherConfig.class);
                    this.mLauncherConfigMap.put(launcherConfig.cardId, launcherConfig);
                }
            }
        }
        catch (RemoteException | JSONException e) {
            Log.w((String)TAG, (String)e.getMessage());
        }
    }

    private KolunCardLauncherConfig getLauncherConfig(TemplateKolunCard card) {
        if (this.getRemoteManager() != null && card != null) {
            KolunCard configCard = card.getKolunCard();
            LauncherConfig config = this.getRemoteManager().getCardConfig(configCard);
            if (config == null) {
                return null;
            }
            return new KolunCardLauncherConfig(configCard.cardId, config.id, config.slot, config.defaultPriority, config.majorPriority);
        }
        return null;
    }

    private String getPackageName() {
        return this.mContext.getPackageName();
    }

    private Bundle getInterfaceBundle(String functionKey) {
        return KolunBridge.getInstance().getInterface(this.getPackageName(), functionKey);
    }

    @Nullable
    private ICardPriority getICardPriority() {
        Bundle interfaceBundle = this.getInterfaceBundle("template_card_priority_interface");
        if (null != interfaceBundle) {
            IBinder ibinder = interfaceBundle.getBinder("template_card_priority_interface");
            ICardPriority priorityInterface = ICardPriority.Stub.asInterface(ibinder);
            if (priorityInterface == null) {
                Log.d((String)TAG, (String)"getICardPriority iCardInterface == null");
            }
            return priorityInterface;
        }
        return null;
    }

    @Nullable
    private ICardInterface getICardInterface() {
        Bundle interfaceBundle = this.getInterfaceBundle("template_card_interface");
        if (null != interfaceBundle) {
            IBinder iBinder = interfaceBundle.getBinder("template_card_interface");
            ICardInterface iCardInterface = ICardInterface.Stub.asInterface(iBinder);
            if (iCardInterface == null) {
                Log.d((String)TAG, (String)"getICardInterface iCardInterface == null");
            }
            return iCardInterface;
        }
        return null;
    }

    private void addToMap(TemplateKolunCard card) {
        if (!mKolunCardMap.containsKey(card.getCardId())) {
            mKolunCardMap.put(card.getCardId(), card);
            KolunCardState cardState = new KolunCardState(card.getCardId(), true, false, false, false, false);
            this.setCardState(cardState);
        }
    }

    private void updateToMap(@NonNull TemplateKolunCard card, long notifyDelayTime) {
        mKolunCardMap.put(card.getCardId(), card);
        if (notifyDelayTime > 0L) {
            RenderThreadHelper.getWorkHandler().postDelayed(() -> this.notifyUpdateCardContent(card), notifyDelayTime);
        } else {
            this.notifyUpdateCardContent(card);
        }
    }

    private void notifyUpdateCardContent(@NonNull TemplateKolunCard card) {
        KolunCardState cardState = new KolunCardState(card.getCardId(), false, true, false, false, false);
        if (this.mClientStub != null) {
            this.mHandler.getLooper().getQueue().addIdleHandler(() -> {
                card.setSpecialState(SpecialState.SPECIAL_STATE_NONE);
                card.setRefreshing(false);
                this.mClientStub.setCardState(cardState);
                Log.d((String)TAG, (String)("notifyUpdateCardContent : " + card.getCardId() + " ; card state :" + card.getSpecialState()));
                return false;
            });
        }
    }

    private boolean removeFromMap(long cardId) {
        TemplateKolunCard temp = mKolunCardMap.remove(cardId);
        KolunCardState cardState = new KolunCardState(cardId, false, false, true, false, false);
        this.setCardState(cardState);
        return temp != null;
    }

    private void addToMapOld(TemplateKolunCard card) {
        mKolunCardMapOld.put(card.getCardId(), card);
        KolunCardLauncherConfig config = this.getLauncherConfig(card);
        if (config != null) {
            this.mLauncherConfigMap.put(card.getCardId(), config);
        }
        if (this.mClientStub != null) {
            KolunCardState cardState = new KolunCardState(card.getCardId(), true, false, false, false, false);
            this.setCardState(cardState);
        } else {
            card.setNeedRefresh(true);
        }
    }

    private boolean removeFromMapOld(long cardId) {
        TemplateKolunCard temp = mKolunCardMapOld.remove(cardId);
        KolunCardState cardState = new KolunCardState(cardId, false, false, true, false, false);
        this.setCardState(cardState);
        return temp != null;
    }

    private boolean updatePriorityMap(KolunCardLauncherConfig config) {
        long cardId = config.cardId;
        KolunCardLauncherConfig temp = this.mLauncherConfigMap.put(cardId, config);
        KolunCardState cardState = new KolunCardState(cardId, false, false, false, true, false);
        this.setCardState(cardState);
        return temp != null;
    }

    private boolean contains(long cardId) {
        return mKolunCardMap.containsKey(cardId);
    }

    private List<TemplateKolunCard> getTemplateCardList() {
        Collection<TemplateKolunCard> cardCollection = mKolunCardMap.values();
        ArrayList<TemplateKolunCard> templateKolunCards = new ArrayList<TemplateKolunCard>(cardCollection);
        templateKolunCards.forEach(card -> {
            card.setSpecialState(SpecialState.SPECIAL_STATE_NONE);
            card.setRefreshing(false);
        });
        Log.d((String)TAG, (String)("getAvailableCardList() -> TemplateKolunCards Size: " + mKolunCardMap.size()));
        templateKolunCards.addAll(mKolunCardMapOld.values());
        return templateKolunCards;
    }

    private String getPackData(Context context, String appKey, long cardId) {
        Log.d((String)TAG, (String)("getPackData() called with: cardId = [" + cardId + "]"));
        try {
            ICardInterface iCardInterface = this.getICardInterface();
            if (iCardInterface != null) {
                return iCardInterface.getPackRawData(context.getPackageName(), appKey, cardId);
            }
        }
        catch (RemoteException e) {
            Log.w((String)TAG, (String)("getPackData error e: " + (Object)((Object)e)));
        }
        return null;
    }

    private String getTemplateData(Context context, String appKey, long cardId) {
        Log.d((String)TAG, (String)("getTemplateData() called with: cardId = [" + cardId + "]"));
        try {
            ICardInterface iCardInterface = this.getICardInterface();
            if (iCardInterface != null) {
                return iCardInterface.getTemplateRawData(context.getPackageName(), appKey, cardId);
            }
        }
        catch (RemoteException e) {
            Log.w((String)TAG, (String)("getPackData error e: " + (Object)((Object)e)));
        }
        return null;
    }

    private void notifySpecialState(long cardId, int code, String reason) {
        if (this.contains(cardId)) {
            TemplateKolunCard card = this.getCard(cardId);
            if (card != null) {
                long currentRefreshShowTime = System.currentTimeMillis() - card.getTryRefreshTime();
                if (currentRefreshShowTime > 0L && currentRefreshShowTime < 600L) {
                    RenderThreadHelper.getWorkHandler().postDelayed(() -> this.configureAndNotifyCardSpecialState(card, SpecialState.SPECIAL_STATE_LOADING_FAIL), 600L - currentRefreshShowTime);
                } else {
                    this.configureAndNotifyCardSpecialState(card, SpecialState.SPECIAL_STATE_LOADING_FAIL);
                }
                Log.d((String)TAG, (String)("Update card: " + cardId + "; notifySpecialState -> code: " + code + "; reason: " + reason));
            }
        } else {
            if (this.mClientStub != null) {
                this.mClientStub.setErrorState(new KolunErrorState(code, reason));
            }
            Log.d((String)TAG, (String)("card: " + cardId + "; notifySpecialState fail -> code: " + code + "; reason: " + reason));
        }
    }

    private void unListenCardService() {
        ICardInterface cardInterface = this.getICardInterface();
        if (cardInterface != null) {
            try {
                cardInterface.unregisterListener(this.getPackageName(), "", this.mServiceListener);
            }
            catch (RemoteException e) {
                Log.d((String)TAG, (String)("unListenService e: " + (Object)((Object)e)));
            }
        }
    }

    private List<String> querySupportedCardRequirePermissionList() {
        ArrayList<String> permissionList = new ArrayList<String>();
        if (this.getRemoteManager() != null) {
            permissionList.addAll(this.getRemoteManager().querySupportedCardRequirePermissionList());
        }
        return permissionList;
    }

    protected void requestIgnoreCard(long cardId) {
        ICardInterface iCardInterface = this.getICardInterface();
        if (iCardInterface != null) {
            this.requestExecuteDefaultAction(cardId, "lgnored_this_time_cl");
        } else {
            KolunBridge.getInstance().connect(this.mContext, this.mConnectCallback, "iCardInterface == null, card onIgnoreCard");
            Log.w((String)TAG, (String)"iCardInterface == null, ignoreCard");
        }
    }

    protected boolean tryRefreshCard(long cardId) {
        TemplateKolunCard templateCard = mKolunCardMap.get(cardId);
        if (templateCard != null && templateCard.getSpecialState() != SpecialState.SPECIAL_STATE_DATA_LOADING) {
            this.configureAndNotifyCardSpecialState(templateCard, SpecialState.SPECIAL_STATE_DATA_LOADING);
            if (CommonUtils.isNetworkAvailable(this.mContext)) {
                Log.d((String)TAG, (String)("refreshCard : " + templateCard.getCardId()));
                return true;
            }
            RenderThreadHelper.getWorkHandler().postDelayed(() -> this.configureAndNotifyCardSpecialState(templateCard, SpecialState.SPECIAL_STATE_NO_NETWORK), 600L);
        }
        return false;
    }

    protected void tryRequestExecuteDefaultAction(long carId, String defaultAction) {
        if (mKolunCardMap.containsKey(carId)) {
            if ((defaultAction.equals("retry_refresh_cl") || defaultAction.equals("refresh_cl")) && !this.tryRefreshCard(carId)) {
                return;
            }
            this.requestExecuteDefaultAction(carId, defaultAction);
        }
    }

    protected void requestExecuteDefaultAction(long cardId, String action) {
        try {
            ICardInterface iCardInterface = this.getICardInterface();
            if (iCardInterface != null) {
                iCardInterface.executeDefaultCardAction(this.getPackageName(), "", cardId, action);
            } else {
                KolunBridge.getInstance().connect(this.mContext, this.mConnectCallback, "iCardInterface == null, requestExecuteDefaultAction");
                Log.w((String)TAG, (String)"iCardInterface == null, requestExecuteDefaultAction");
            }
        }
        catch (RemoteException e) {
            Log.w((String)TAG, (String)("requestExecuteDefaultAction failed: " + e.getMessage()));
        }
    }

    private void configureAndNotifyCardSpecialState(@NonNull TemplateKolunCard card, SpecialState specialState) {
        KolunCardState cardState = new KolunCardState(card.getCardId(), false, true, false, false, false);
        if (this.mClientStub != null) {
            this.mHandler.getLooper().getQueue().addIdleHandler(() -> {
                if (!card.isRefreshing() && specialState != SpecialState.SPECIAL_STATE_DATA_LOADING) {
                    return false;
                }
                if (specialState == SpecialState.SPECIAL_STATE_DATA_LOADING) {
                    card.setTryRefreshTime(System.currentTimeMillis());
                    card.setRefreshing(true);
                } else {
                    card.setTryRefreshTime(0L);
                    card.setRefreshing(false);
                }
                card.setSpecialState(specialState);
                this.mClientStub.setCardState(cardState);
                Log.d((String)TAG, (String)("NotifyCardSpecialState : " + card.getCardId() + " ; card state :" + card.getSpecialState()));
                return false;
            });
        }
    }

    private KolunCardManager getRemoteManager() {
        return this.mRemoteManager;
    }

    public boolean isCardFeatureEnabled() {
        return this.getRemoteManager().isCardFeatureEnabled();
    }

    public void toggleCardFeature(boolean enable) {
        this.getRemoteManager().toggleCardFeature(enable);
    }

    public void toggleCardFeature(boolean enable, long[] unControlIds) {
        this.getRemoteManager().toggleCardFeature(enable, this.longToInt(unControlIds));
    }

    private int[] longToInt(long[] longArray) {
        int length = longArray.length;
        if (length == 0) {
            return null;
        }
        int[] intArray = new int[length];
        for (int i = 0; i < length; ++i) {
            intArray[i] = (int)longArray[i];
        }
        return intArray;
    }

    public void onSubscribeResume() {
        block5: {
            if (KolunBridge.getInstance().isServiceConnect()) {
                Log.d((String)TAG, (String)"onSubscribeResume  service is connected");
                try {
                    ISubscriptionInterface subscriptionInterface = this.getSubscriptionInterface();
                    if (subscriptionInterface != null) {
                        subscriptionInterface.requestAllSubscriptionInfo(this.mContext.getPackageName(), "");
                        break block5;
                    }
                    KolunBridge.getInstance().connect(this.mContext, this.mConnectCallback, "client requestSubscriptionInfo");
                }
                catch (RemoteException e) {
                    Log.d((String)TAG, (String)"requestAllSubscriptionInfo failed");
                }
            } else {
                Log.d((String)TAG, (String)"onSubscribeResume connect service now");
                KolunBridge.getInstance().connect(this.mContext, this.mConnectCallback, "subscribe onSubscribeResume");
            }
        }
        this.getRemoteManager().onResume();
    }

    public List<SubscriptionLocalInfo> getSubscriptionInfoList(List<Long> cardIds) {
        if (cardIds == null || cardIds.isEmpty()) {
            return null;
        }
        ArrayList<SubscriptionLocalInfo> tempList = new ArrayList<SubscriptionLocalInfo>();
        for (long cardId : cardIds) {
            tempList.add(this.mInfoMap.get(cardId));
        }
        return tempList;
    }

    public List<SubscriptionLocalInfo> getSubscriptionInfoList() {
        if (this.getRemoteManager() != null) {
            List<SubscriptionLocalInfo> infoList = this.transformInfo(this.getRemoteManager().querySupportedCardDescription());
            Log.d((String)TAG, (String)("infoList size: " + infoList.size()));
            HashMap temp = new HashMap();
            infoList.forEach(oldInfo -> temp.put(oldInfo.getDetailInfo().getCardId(), oldInfo));
            this.mInfoMapOld.clear();
            this.mInfoMapOld.putAll(temp);
        }
        return this.getSubscriptionLocalInfoList();
    }

    public Intent getSettingIntent(long cardId) {
        SubscriptionLocalInfo subscriptionLocalInfo = this.mInfoMap.get(cardId);
        if (subscriptionLocalInfo == null) {
            subscriptionLocalInfo = this.mInfoMapOld.get(cardId);
        }
        if (subscriptionLocalInfo != null) {
            CardDeepLink cardDeepLink;
            Intent intent = new Intent();
            if (!(TextUtils.isEmpty((CharSequence)subscriptionLocalInfo.getAction()) || TextUtils.isEmpty((CharSequence)subscriptionLocalInfo.getPackageName()) || "android.intent.action.VIEW".equals(subscriptionLocalInfo.getAction()))) {
                intent.setPackage(subscriptionLocalInfo.getPackageName());
                intent.setAction(subscriptionLocalInfo.getAction());
                return intent;
            }
            SubscriptionCmsInfo detailInfo = subscriptionLocalInfo.getDetailInfo();
            if (detailInfo != null && (cardDeepLink = detailInfo.getDeeplink()) != null) {
                String url = cardDeepLink.getUrl();
                if (url != null) {
                    intent.setData(Uri.parse((String)url));
                }
                intent.setPackage(cardDeepLink.getAppPackage());
                intent.setAction("android.intent.action.VIEW");
                return intent;
            }
        }
        return null;
    }

    public boolean subscribeCard(long cardId, boolean subscribe) {
        if (this.mInfoMap.containsKey(cardId)) {
            ISubscriptionInterface subscriptionInterface = this.getSubscriptionInterface();
            if (subscriptionInterface == null) {
                Log.d((String)TAG, (String)"service is disconnected");
                return false;
            }
            try {
                boolean state = subscriptionInterface.subscribeCard(this.mContext.getPackageName(), "", cardId, subscribe);
                RenderThread.getInstance().getThreadHandler().post(() -> this.toggleCardSwitchByProtocol(cardId, state));
                return state;
            }
            catch (RemoteException e) {
                Log.d((String)TAG, (String)"subscribeCard failed");
            }
        } else {
            List<KolunCardDescription> cardDescriptionList = this.getRemoteManager().querySupportedCardDescription(new int[]{(int)cardId});
            if (cardDescriptionList != null && !cardDescriptionList.isEmpty()) {
                KolunCardDescription cardDescription = cardDescriptionList.get(0);
                return cardDescription.toggle(subscribe);
            }
        }
        return false;
    }

    void toggleCardSwitchByProtocol(long cardId, boolean enable) {
        SubscriptionLocalInfo info = this.mInfoMap.get(cardId);
        if (info != null) {
            info.setSubscribed(enable);
            this.mInfoMap.put(cardId, info);
        }
    }

    private List<SubscriptionLocalInfo> getSubscriptionLocalInfoList() {
        Collection<SubscriptionLocalInfo> cardCollection = this.mInfoMap.values();
        ArrayList<SubscriptionLocalInfo> templateKolunCards = new ArrayList<SubscriptionLocalInfo>(cardCollection);
        templateKolunCards.addAll(this.mInfoMapOld.values());
        return templateKolunCards;
    }

    private List<SubscriptionLocalInfo> transformInfo(List<KolunCardDescription> descriptionList) {
        ArrayList<SubscriptionLocalInfo> infoList = new ArrayList<SubscriptionLocalInfo>();
        if (this.getRemoteManager() != null) {
            descriptionList.forEach(cardDescription -> {
                String servicePreviewUrl;
                SubscriptionCmsInfo cmsInfo = new SubscriptionCmsInfo();
                cmsInfo.setCardId((long)cardDescription.cardId);
                cmsInfo.setServiceTitle(cardDescription.name);
                cmsInfo.setAppDetail(cardDescription.description);
                cmsInfo.setCategory(cardDescription.categoryId);
                cmsInfo.setInvisible(cardDescription.isInvisible());
                String titleIconUrl = cardDescription.getTitleIconAddress();
                if (!TextUtils.isEmpty((CharSequence)titleIconUrl)) {
                    cmsInfo.setTitleIcon(cardDescription.getTitleIconAddress());
                }
                if (!TextUtils.isEmpty((CharSequence)(servicePreviewUrl = cardDescription.getServicePreviewAddress()))) {
                    cmsInfo.setServicePreview(cardDescription.getServicePreviewAddress());
                }
                Intent activityIntent = cardDescription.activityIntent;
                SubscriptionLocalInfo info = new SubscriptionLocalInfo(cmsInfo);
                info.setSubscribed(cardDescription.isEnabled());
                info.setTemplateInfo(false);
                if (activityIntent != null) {
                    ComponentName component = activityIntent.getComponent();
                    if (component != null) {
                        String packageName = component.getPackageName();
                        if (packageName == null) {
                            packageName = activityIntent.getPackage();
                        }
                        cmsInfo.setDeeplink(new CardDeepLink(activityIntent.getDataString(), packageName, 1));
                    }
                    info.setPackageName(activityIntent.getPackage());
                    info.setAction(activityIntent.getAction());
                }
                infoList.add(info);
            });
        }
        return infoList;
    }

    private ISubscriptionInterface getSubscriptionInterface() {
        Bundle interfaceBundle = this.getInterfaceBundle("template_subscription_interface");
        if (null != interfaceBundle) {
            IBinder binder = interfaceBundle.getBinder("template_subscription_interface");
            ISubscriptionInterface iSubscriptionInterface = ISubscriptionInterface.Stub.asInterface(binder);
            if (iSubscriptionInterface == null) {
                Log.d((String)TAG, (String)"getSubscriptionInterface iSubscriptionInterface == null");
            }
            return iSubscriptionInterface;
        }
        return null;
    }

    private void onSubscriptionServicecConnectSuccessful(ISubscriptionListener mSubscriptionServiceListener) {
        ISubscriptionInterface subscriptionInterface = this.getSubscriptionInterface();
        Log.d((String)TAG, (String)("subscribe connect mInterface: " + subscriptionInterface));
        if (subscriptionInterface != null) {
            try {
                String pkgName = this.mContext.getPackageName();
                subscriptionInterface.registerSubscriptionListener(pkgName, "", mSubscriptionServiceListener, true);
            }
            catch (RemoteException e) {
                Log.d((String)TAG, (String)"subscribe failed");
            }
        }
    }

    private void onSubscriptionServicecDisconnected(ISubscriptionListener mSubscriptionServiceListener) {
        ISubscriptionInterface subscriptionInterface = this.getSubscriptionInterface();
        if (subscriptionInterface != null) {
            try {
                subscriptionInterface.registerSubscriptionListener(this.mContext.getPackageName(), "", mSubscriptionServiceListener, false);
            }
            catch (RemoteException e) {
                Log.d((String)TAG, (String)("unListenService e: " + (Object)((Object)e)));
            }
        }
    }

    @Nullable
    public Bitmap getSubscriptionBitmap(long cardId, String uri, int type) {
        return UIUtils.getSubscriptionBitmap(this.mContext, cardId, uri, type);
    }

    private class SubscriptionServiceListener
    extends ISubscriptionListener.Stub {
        private SubscriptionServiceListener() {
        }

        @Override
        public void onSubscriptionUpdate(boolean mainSwitchStatus, List<String> data, int errorCode, String reason) throws RemoteException {
            if (errorCode == 0) {
                List subscriptionLocalInfoList = SubscriptionParser.parseJson2SubscriptionInfo(data);
                Log.d((String)TemplateKolunCardManager.TAG, (String)("onSubscriptionUpdate size: " + subscriptionLocalInfoList.size()));
                ArrayList<Long> ids = new ArrayList<Long>();
                subscriptionLocalInfoList.forEach(info -> {
                    TemplateKolunCardManager.this.mInfoMap.put(info.getDetailInfo().getCardId(), info);
                    ids.add(info.getDetailInfo().getCardId());
                });
                HashMap temp = new HashMap(TemplateKolunCardManager.this.mInfoMap);
                temp.keySet().forEach(id2 -> {
                    if (!ids.contains(id2)) {
                        TemplateKolunCardManager.this.mInfoMap.remove(id2);
                    }
                });
                if (TemplateKolunCardManager.this.mClientStub != null) {
                    TemplateKolunCardManager.this.mClientStub.setSubscriptionState(new KolunSubscriptionState(ids));
                }
            } else {
                Log.d((String)TemplateKolunCardManager.TAG, (String)("onError errorCode: " + errorCode + " reason: " + reason));
                if (TemplateKolunCardManager.this.mClientStub != null) {
                    TemplateKolunCardManager.this.mClientStub.setErrorState(new KolunErrorState(errorCode, reason));
                }
            }
        }

        @Override
        public void onRegistered(boolean mainSwitchStatus, List<String> data) throws RemoteException {
            List subscriptionLocalInfoList = SubscriptionParser.parseJson2SubscriptionInfo(data);
            Log.d((String)TemplateKolunCardManager.TAG, (String)("onSubscriptionUpdate size: " + subscriptionLocalInfoList.size()));
            ArrayList<Long> ids = new ArrayList<Long>();
            HashMap temp = new HashMap();
            subscriptionLocalInfoList.forEach(info -> {
                temp.put(info.getDetailInfo().getCardId(), info);
                ids.add(info.getDetailInfo().getCardId());
            });
            TemplateKolunCardManager.this.mInfoMap.clear();
            TemplateKolunCardManager.this.mInfoMap.putAll(temp);
            if (TemplateKolunCardManager.this.mClientStub != null) {
                TemplateKolunCardManager.this.mClientStub.setSubscriptionState(new KolunSubscriptionState(ids));
            }
        }
    }

    class LocalListener
    extends IListener.Stub {
        LocalListener() {
        }

        @Override
        public void onCardUpdated(KolunCard card) throws RemoteException {
            Log.d((String)TemplateKolunCardManager.TAG, (String)(" old onCardUpdated card: " + card));
            if (card == null) {
                return;
            }
            TemplateKolunCard templateKolunCard = TemplateKolunCard.create(card);
            TemplateKolunCardManager.this.addToMapOld(templateKolunCard);
        }

        @Override
        public void onCardStatusChanged(KolunCard card, boolean available) throws RemoteException {
            Log.d((String)TemplateKolunCardManager.TAG, (String)(" old onCardStatusChanged card: " + available + " card: " + card));
            if (card == null) {
                return;
            }
            if (available) {
                TemplateKolunCard newCard = TemplateKolunCard.create(card);
                TemplateKolunCardManager.this.addToMapOld(newCard);
            } else {
                TemplateKolunCardManager.this.removeFromMapOld(card.cardId);
            }
        }
    }

    private class CardPriorityListener
    extends ICardPriorityListener.Stub {
        private CardPriorityListener() {
        }

        @Override
        public void onPriorityChange(String[] json) throws RemoteException {
            try {
                for (String priorityJson : json) {
                    KolunCardLauncherConfig config = (KolunCardLauncherConfig)JSONObject.parseObject((String)priorityJson, KolunCardLauncherConfig.class);
                    if (config == null) continue;
                    TemplateKolunCardManager.this.updatePriorityMap(config);
                }
            }
            catch (JSONException e) {
                Log.e((String)TemplateKolunCardManager.TAG, (String)("onPriorityChange Error : " + (Object)((Object)e)));
            }
        }
    }

    private class ServiceListener
    extends ICardListener.Stub {
        private ServiceListener() {
        }

        @Override
        public void onRegistered(long[] availableCardIds, int code, String reason) throws RemoteException {
            Log.d((String)TemplateKolunCardManager.TAG, (String)("onRegistered() called with: code = [" + code + "], reason = [" + reason + "]"));
            if (code == 0) {
                if (availableCardIds == null) {
                    Log.d((String)TemplateKolunCardManager.TAG, (String)"availableCardIds null");
                    return;
                }
                if (!mKolunCardMap.isEmpty() && availableCardIds.length == 0) {
                    Log.d((String)TemplateKolunCardManager.TAG, (String)"onRegistered() -> AI Assistant Cache Clear -> clear SDK card cache");
                    mKolunCardMap.keySet().forEach(cardId -> {
                        KolunCardState cardState = new KolunCardState((long)cardId, false, false, true, false, false);
                        TemplateKolunCardManager.this.setCardState(cardState);
                        Log.d((String)TemplateKolunCardManager.TAG, (String)("notify client remove card id: " + cardId));
                    });
                    mKolunCardMap.clear();
                    Log.d((String)TemplateKolunCardManager.TAG, (String)("onRegistered() -> TemplateKolunCards Size: " + mKolunCardMap.size()));
                }
                if (availableCardIds.length > 0) {
                    HashMap<Long, TemplateKolunCard> tempMap = new HashMap<Long, TemplateKolunCard>();
                    for (long availableCardId : availableCardIds) {
                        String packData = TemplateKolunCardManager.this.getPackData(TemplateKolunCardManager.this.mContext, "", availableCardId);
                        Log.d((String)TemplateKolunCardManager.TAG, (String)("manager onCardStatusChanged packData => " + packData));
                        if (TextUtils.isEmpty((CharSequence)packData)) continue;
                        TemplateKolunCard newCard = TemplateKolunCard.create(KolunCardParser.create(packData));
                        tempMap.put(newCard.getCardId(), newCard);
                    }
                    mKolunCardMap.clear();
                    mKolunCardMap.putAll(tempMap);
                }
                KolunCardState cardState = new KolunCardState(-1L, false, false, false, false, true);
                TemplateKolunCardManager.this.setCardState(cardState);
            } else if (TemplateKolunCardManager.this.mClientStub != null) {
                TemplateKolunCardManager.this.mClientStub.setErrorState(new KolunErrorState(code, reason));
            }
        }

        @Override
        public void onCardUpdated(long[] updateCardIds, int code, String reason) throws RemoteException {
            Log.d((String)TemplateKolunCardManager.TAG, (String)("onCardUpdated() called with: code = [" + code + "], reason = [" + reason + "]"));
            if (updateCardIds == null || updateCardIds.length == 0) {
                return;
            }
            for (long cardId : updateCardIds) {
                if (code == 0) {
                    String packData = TemplateKolunCardManager.this.getPackData(TemplateKolunCardManager.this.mContext, "", cardId);
                    Log.d((String)TemplateKolunCardManager.TAG, (String)("manager onCardUpdated packData => " + packData));
                    if (TextUtils.isEmpty((CharSequence)packData)) continue;
                    Pack pack = KolunCardParser.create(packData);
                    if (pack == null) {
                        TemplateKolunCardManager.this.notifySpecialState(cardId, 1, reason);
                        return;
                    }
                    this.updateCard(cardId, TemplateKolunCardManager.this.getCard(cardId), pack);
                    continue;
                }
                TemplateKolunCardManager.this.notifySpecialState(cardId, code, reason);
            }
        }

        private void updateCard(long cardId, TemplateKolunCard card, Pack pack) {
            long currentRefreshShowTime = 0L;
            if (TemplateKolunCardManager.this.contains(cardId) && card != null) {
                currentRefreshShowTime = System.currentTimeMillis() - card.getTryRefreshTime();
                Log.d((String)TemplateKolunCardManager.TAG, (String)("updateCard " + cardId + "; currentRefreshShowTime : " + currentRefreshShowTime));
                card.reCreate(pack);
            } else {
                card = TemplateKolunCard.create(pack);
            }
            long delayTime = 0L;
            if (currentRefreshShowTime > 0L && currentRefreshShowTime < 600L) {
                delayTime = 600L - currentRefreshShowTime;
            }
            TemplateKolunCardManager.this.updateToMap(card, delayTime);
        }

        @Override
        public void onCardStatusChanged(long cardId, int state) throws RemoteException {
            Log.d((String)TemplateKolunCardManager.TAG, (String)("onCardStatusChanged cardId: " + cardId + " state: " + state));
            if (state == 0) {
                TemplateKolunCardManager.this.removeFromMap(cardId);
            } else {
                String packData = TemplateKolunCardManager.this.getPackData(TemplateKolunCardManager.this.mContext, "", cardId);
                Log.d((String)TemplateKolunCardManager.TAG, (String)("manager onCardStatusChanged packData => " + packData));
                if (TextUtils.isEmpty((CharSequence)packData)) {
                    return;
                }
                TemplateKolunCard newCard = TemplateKolunCard.create(KolunCardParser.create(packData));
                TemplateKolunCardManager.this.addToMap(newCard);
            }
        }

        @Override
        public void onSubscribeCard(long cardId, String packData) throws RemoteException {
            Log.d((String)TemplateKolunCardManager.TAG, (String)("onSubscribeCard() called with: cardId = [" + cardId + "], packData = [" + packData + "]"));
            if (TextUtils.isEmpty((CharSequence)packData)) {
                return;
            }
            TemplateKolunCard newCard = TemplateKolunCard.create(KolunCardParser.create(packData));
            TemplateKolunCardManager.this.addToMap(newCard);
        }
    }
}

