/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.kolun.cardtemplate;

import android.content.Context;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.alibaba.fastjson.JSON;
import com.transsion.kolun.cardtemplate.IAgreement;
import com.transsion.kolun.cardtemplate.KolunBridge;
import com.transsion.kolun.cardtemplate.TemplateKolunCardManager;
import com.transsion.kolun.cardtemplate.engine.RenderThread;
import com.transsion.kolun.cardtemplate.privacy.Agreement;
import com.transsion.kolun.koluncard.KolunCardManager;
import com.transsion.kolun.koluncard.KolunCardProtocol;
import java.util.Locale;
import java.util.Map;

public class TemplateKolunProtocol {
    private static final String TAG = "TemplateKolunProtocol";
    private final KolunCardManager mManager;
    private Agreement mAgreement;
    private final String mCallingPackage;
    private final String mAppkey;
    private final Context mContext;
    private String mLanguage;

    public TemplateKolunProtocol(Context context, KolunCardManager manager, String callingPackage, String appkey) {
        this.mManager = manager;
        this.mCallingPackage = callingPackage;
        this.mAppkey = appkey;
        this.mContext = context;
        this.mLanguage = Locale.getDefault().getLanguage();
    }

    @Nullable
    private IAgreement getIAgreement() {
        Bundle interfaceBundle = KolunBridge.getInstance().getInterface(this.mCallingPackage, "template_agreement_interface");
        if (interfaceBundle != null) {
            IBinder binder = interfaceBundle.getBinder("template_agreement_interface");
            IAgreement iAgreement = IAgreement.Stub.asInterface(binder);
            if (iAgreement == null) {
                Log.d((String)TAG, (String)"getiAgreement == null");
            }
            return iAgreement;
        }
        return null;
    }

    public boolean isAcceptAll() {
        this.initAgreement();
        boolean isNewConnect = false;
        if (this.mAgreement != null) {
            isNewConnect = this.mAgreement.isAcceptAll();
        }
        boolean isOldConnect = false;
        KolunCardProtocol protocol = this.mManager.getCardProtocol();
        if (protocol != null) {
            isOldConnect = protocol.isProtocolAccept();
        }
        return isNewConnect && isOldConnect;
    }

    public boolean isAgreementUpdate() {
        int protocolType;
        KolunCardProtocol protocol = this.mManager.getCardProtocol();
        if (protocol != null && (protocolType = protocol.getProtocolType()) == 2) {
            return true;
        }
        this.initAgreement();
        if (this.mAgreement != null) {
            return this.mAgreement.isUpdate();
        }
        Log.w((String)TAG, (String)("mAgreement is: " + null));
        return false;
    }

    private void initAgreement() {
        if (this.mAgreement == null) {
            try {
                IAgreement iAgreement = this.getIAgreement();
                if (iAgreement != null) {
                    String json = iAgreement.getAgreement(this.mCallingPackage, this.mAppkey);
                    this.mAgreement = (Agreement)JSON.parseObject((String)json, Agreement.class);
                } else {
                    Log.w((String)TAG, (String)"initAgreement failed iAgreement null");
                }
            }
            catch (RemoteException e) {
                Log.w((String)TAG, (String)"initAgreement failed: ", (Throwable)e);
            }
        }
    }

    public void toggleAgreement(boolean enable) {
        KolunCardProtocol protocol = this.mManager.getCardProtocol();
        if (protocol != null) {
            protocol.toggleProtocol(enable);
        }
        try {
            IAgreement iAgreement = this.getIAgreement();
            if (iAgreement != null) {
                iAgreement.setAgreementAll(enable);
            } else {
                Log.w((String)TAG, (String)"toggleProtocol iAgreement null");
            }
        }
        catch (RemoteException e) {
            Log.w((String)TAG, (String)"toggleProtocol: changeAgreementAll error", (Throwable)e);
        }
    }

    @WorkerThread
    public boolean toggleSingleAgreement(long cardId, boolean enable) {
        if (cardId < 9000L) {
            KolunCardProtocol protocol = this.mManager.getCardProtocol();
            if (protocol != null) {
                return protocol.toggleCardProtocol((int)cardId, enable);
            }
        } else {
            try {
                IAgreement iAgreement = this.getIAgreement();
                if (iAgreement != null) {
                    boolean state = iAgreement.setAgreement(cardId, enable);
                    RenderThread.getInstance().getThreadHandler().post(() -> TemplateKolunCardManager.getInstance(this.mContext).toggleCardSwitchByProtocol(cardId, state));
                    return state;
                }
            }
            catch (RemoteException e) {
                Log.w((String)TAG, (String)"toggleCardProtocol failed: ", (Throwable)e);
            }
        }
        return false;
    }

    public boolean isAgreementEnable(long cardId) {
        if (cardId < 9000L) {
            KolunCardProtocol protocol = this.mManager.getCardProtocol();
            if (protocol != null) {
                return protocol.isProtocolEnable((int)cardId);
            }
        } else {
            try {
                IAgreement iAgreement = this.getIAgreement();
                if (iAgreement != null) {
                    return iAgreement.isCardAccept(cardId);
                }
            }
            catch (RemoteException e) {
                Log.w((String)TAG, (String)"isAgreementEnable failed:", (Throwable)e);
            }
        }
        return false;
    }

    public String getPrivacyAgreementUrl() {
        KolunCardProtocol protocol;
        boolean isLanguageChanged;
        this.initAgreement();
        String privacyAgreementUrl = null;
        String currentLanguage = Locale.getDefault().getLanguage();
        boolean bl = isLanguageChanged = !this.mLanguage.equals(currentLanguage);
        if (this.mAgreement != null && !isLanguageChanged) {
            privacyAgreementUrl = this.mAgreement.getPrivacyAgreementUrl();
        }
        if (TextUtils.isEmpty(privacyAgreementUrl) && (protocol = this.mManager.getCardProtocol()) != null) {
            privacyAgreementUrl = protocol.getPrivacyPolicyUrl();
            if (this.mAgreement != null) {
                this.mAgreement.setPrivacyAgreementUrl(privacyAgreementUrl);
            }
            if (isLanguageChanged) {
                Log.d((String)TAG, (String)("language changed : " + isLanguageChanged + " ; reset current : " + this.mLanguage));
                this.mLanguage = currentLanguage;
                if (this.mAgreement != null) {
                    this.mAgreement.setUserAgreementUrl(protocol.getUserProtocolUrl());
                }
            }
        }
        return privacyAgreementUrl;
    }

    public String getUserAgreementUrl() {
        KolunCardProtocol protocol;
        boolean isLanguageChanged;
        this.initAgreement();
        String userAgreementUrl = null;
        String currentLanguage = Locale.getDefault().getLanguage();
        boolean bl = isLanguageChanged = !this.mLanguage.equals(currentLanguage);
        if (this.mAgreement != null && !isLanguageChanged) {
            userAgreementUrl = this.mAgreement.getUserAgreementUrl();
        }
        if (TextUtils.isEmpty(userAgreementUrl) && (protocol = this.mManager.getCardProtocol()) != null) {
            userAgreementUrl = protocol.getUserProtocolUrl();
            if (this.mAgreement != null) {
                this.mAgreement.setUserAgreementUrl(userAgreementUrl);
            }
            if (isLanguageChanged) {
                Log.d((String)TAG, (String)("language changed : " + isLanguageChanged + " ; reset current : " + this.mLanguage));
                this.mLanguage = currentLanguage;
                if (this.mAgreement != null) {
                    this.mAgreement.setPrivacyAgreementUrl(protocol.getPrivacyPolicyUrl());
                }
            }
        }
        return userAgreementUrl;
    }

    public boolean isAgreementContains(long cardId) {
        if (cardId < 9000L) {
            KolunCardProtocol protocol = this.mManager.getCardProtocol();
            if (protocol != null) {
                return protocol.isProtocolConstraintCard((int)cardId);
            }
        } else {
            Agreement.State state;
            this.initAgreement();
            Map cardAgreementState = null;
            if (this.mAgreement != null) {
                cardAgreementState = this.mAgreement.getCardAgreementState();
            }
            if (cardAgreementState != null && (state = (Agreement.State)cardAgreementState.get(cardId)) != null) {
                return state.isAgreementContains();
            }
        }
        return false;
    }

    public int getAgreementVersion() {
        this.initAgreement();
        int version = 0;
        if (this.mAgreement != null) {
            version = this.mAgreement.getVersion();
        }
        if (version != 0) {
            return version;
        }
        KolunCardProtocol protocol = this.mManager.getCardProtocol();
        if (protocol != null) {
            version = protocol.getProtocolVersion();
        }
        return version;
    }
}

