/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.kolun.cardtemplate.card;

import android.text.TextUtils;
import android.util.Log;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.transsion.kolun.cardtemplate.bean.pack.TemplateData;
import com.transsion.kolun.cardtemplate.layout.pack.TemplateLyt;
import com.transsion.kolun.cardtemplate.parser.TemplateParser;
import com.transsion.kolun.cardtemplate.transport.pack.Pack;
import org.json.JSONObject;

public class KolunCardParser {
    private static final String TAG = "KolunCardParser";

    public static Pack create(String packRawData) {
        try {
            JSONObject rawData = new JSONObject(packRawData);
            return KolunCardParser.parseData(packRawData, rawData.optString("data"), rawData.optString("layout"));
        }
        catch (JSONException | org.json.JSONException e) {
            Log.d((String)TAG, (String)("KolunCardMateData e: " + e));
            return null;
        }
    }

    private static Pack parseData(String rawPackData, String templateData, String templateLyt) {
        Pack temp = (Pack)JSON.parseObject((String)rawPackData, Pack.class);
        int contentId = temp.getContentId();
        int packId = temp.getPackId();
        int templateId = contentId + packId;
        if (TextUtils.isEmpty((CharSequence)templateData) || TextUtils.isEmpty((CharSequence)templateLyt)) {
            return temp;
        }
        Pack actualPack = TemplateParser.parseJson2PackWithPackId((int)packId, (String)rawPackData);
        TemplateData actualTemplateData = TemplateParser.parseJson2CardData((int)templateId, (String)templateData);
        if (actualPack != null && actualTemplateData != null) {
            actualPack.setData(actualTemplateData);
        }
        TemplateLyt actualTemplateLyt = TemplateParser.parseJson2CardLyt((int)templateId, (String)templateLyt);
        if (actualPack != null && actualTemplateLyt != null) {
            actualPack.setLayout(actualTemplateLyt);
        }
        return actualPack;
    }
}

