/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.kolun.cardtemplate.card;

import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import androidx.annotation.Nullable;
import com.transsion.kolun.cardtemplate.R;
import com.transsion.kolun.cardtemplate.bean.base.CardBitmap;
import com.transsion.kolun.cardtemplate.bean.base.CardPopMenu;
import com.transsion.kolun.cardtemplate.bean.pack.TemplateData;
import com.transsion.kolun.cardtemplate.bg.BackgroundRes;
import com.transsion.kolun.cardtemplate.bg.CardBgRes;
import com.transsion.kolun.cardtemplate.bg.ClientModuleRes;
import com.transsion.kolun.cardtemplate.customwidget.RoundCornerLinearLayout;
import com.transsion.kolun.cardtemplate.customwidget.RoundCornerRelativeLayout;
import com.transsion.kolun.cardtemplate.engine.RenderEngine;
import com.transsion.kolun.cardtemplate.engine.RenderEngineManager;
import com.transsion.kolun.cardtemplate.engine.template.viewmodel.CommonViewModel;
import com.transsion.kolun.cardtemplate.layout.pack.TemplateLyt;
import com.transsion.kolun.cardtemplate.parser.TemplateParser;
import com.transsion.kolun.cardtemplate.state.SpecialState;
import com.transsion.kolun.cardtemplate.transport.pack.Pack;
import com.transsion.kolun.cardtemplate.utils.CommonUtils;
import com.transsion.kolun.cardtemplate.utils.UIUtils;
import com.transsion.kolun.koluncard.KolunCard;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

public class TemplateKolunCard {
    private static final String TAG = "TemplateKolunCard";
    private final KolunCard kolunCard;
    private boolean needRefresh = false;
    private long cardId;
    private final Pack actualPack;
    RenderEngine.EngineModel mEngineModel;
    private boolean isRefreshing = false;
    private long tryRefreshTime;

    private TemplateKolunCard(Pack pack) {
        this.actualPack = pack;
        this.cardId = this.actualPack.getCardId();
        this.kolunCard = null;
    }

    public TemplateKolunCard(KolunCard card) {
        this.kolunCard = card;
        this.cardId = card.cardId;
        this.actualPack = null;
    }

    public static TemplateKolunCard create(Pack cardMateData) {
        return new TemplateKolunCard(cardMateData);
    }

    @Nullable
    public List<KolunCard.CardPopupMenu> getCardPopMenuList() {
        if (this.kolunCard != null) {
            return this.kolunCard.getPopupMenuList();
        }
        return null;
    }

    @Nullable
    public List<CardPopMenu> getTemplateCardPopMenuList() {
        TemplateData data;
        if (this.actualPack != null && (data = this.actualPack.getData()) != null) {
            return data.getCardPopMenus();
        }
        return null;
    }

    public void updateData(TemplateData actualTemplateData, View engineView) {
        if (actualTemplateData != null) {
            ((CommonViewModel)this.mEngineModel.getEngineViewModel()).onDataUpdate(actualTemplateData, engineView, this.actualPack.getSpecialState(), this.actualPack.getViewHeight());
        }
    }

    public void updateLyt(TemplateLyt actualTemplateLyt, View engineView) {
        if (actualTemplateLyt != null) {
            ((CommonViewModel)this.mEngineModel.getEngineViewModel()).onLayoutUpdate(actualTemplateLyt, engineView, this.actualPack.getSpecialState(), this.actualPack.getViewHeight());
        }
    }

    public void updatePack(View engineView) {
        if (this.actualPack != null) {
            ((CommonViewModel)this.mEngineModel.getEngineViewModel()).onPackUpdate(this.actualPack, engineView, this.actualPack.getSpecialState());
        }
    }

    public void reCreate(Pack pack) {
        TemplateLyt layout;
        TemplateData data = pack.getData();
        if (data != null) {
            this.actualPack.setData(data);
        }
        if ((layout = pack.getLayout()) != null) {
            this.actualPack.setLayout(layout);
        }
        this.cardId = this.actualPack.getCardId();
    }

    public View apply(Context context) {
        return this.apply(context, true);
    }

    public View apply(Context context, boolean isPopupMenuShow) {
        return this.renderInner(context, this.actualPack, isPopupMenuShow);
    }

    private View renderInner(Context context, Pack actualPack, boolean isPopupMenuShow) {
        String lytName = TemplateParser.getTemplateLytResName((int)(actualPack.getContentId() + actualPack.getPackId()));
        if (lytName == null) {
            return null;
        }
        CardBgRes cardBgRes = this.getClientBgResource(context, actualPack);
        if (cardBgRes != null) {
            UIUtils.setClientTextColorResList(cardBgRes.getTextStringColors());
            UIUtils.setClientButtonTextColorResList(cardBgRes.getButtonTextColors());
        }
        RenderEngine engine = RenderEngineManager.createRenderEngine(actualPack.getPackId());
        if (!isPopupMenuShow) {
            actualPack.getLayout().getCardTitleLyt().setFunctionIconInvisible(true);
        }
        if (engine == null) {
            Log.w((String)TAG, (String)"renderInner: engine is null");
            return null;
        }
        this.mEngineModel = engine.render(context, lytName, actualPack);
        if (this.mEngineModel == null) {
            return null;
        }
        Object view = this.mEngineModel.getEngineView();
        if (view != null) {
            if (view instanceof RoundCornerLinearLayout) {
                RoundCornerLinearLayout roundView = (RoundCornerLinearLayout)((Object)view);
                roundView.registerVisibilityEvent(this.actualPack, this.mEngineModel);
                view = roundView;
            } else if (view instanceof RoundCornerRelativeLayout) {
                RoundCornerRelativeLayout roundView = (RoundCornerRelativeLayout)((Object)view);
                roundView.registerVisibilityEvent(this.actualPack, this.mEngineModel);
                view = roundView;
            }
            this.setCardBackground(context, actualPack, cardBgRes, (View)view);
        }
        return view;
    }

    private void setCardBackground(Context context, Pack actualPack, CardBgRes cardBgRes, View view) {
        block13: {
            block12: {
                if (cardBgRes == null) break block12;
                int bgType = cardBgRes.getBgType();
                String rootBg = cardBgRes.getCardBgColor();
                CardBitmap rootBitmap = cardBgRes.getBgBitmap();
                switch (bgType) {
                    case 1: {
                        if (!TextUtils.isEmpty((CharSequence)rootBg)) {
                            view.setBackgroundColor(Color.parseColor((String)rootBg));
                            break;
                        }
                        if (rootBitmap != null) {
                            view.setBackground(this.getRootBgDrawable(context, rootBitmap));
                            break;
                        }
                        this.setDefaultRootBg(view);
                        break;
                    }
                    case 2: {
                        View gradientContainer;
                        if (!TextUtils.isEmpty((CharSequence)rootBg)) {
                            view.setBackgroundColor(Color.parseColor((String)rootBg));
                        } else if (rootBitmap != null) {
                            view.setBackground(this.getRootBgDrawable(context, rootBitmap));
                        } else {
                            this.setDefaultRootBg(view);
                        }
                        String[] gradientBgColor = cardBgRes.getGradientBgColor();
                        if (gradientBgColor != null && gradientBgColor.length > 0 && actualPack.getContentId() == 40000 && (gradientContainer = view.findViewById(R.id.sdk_koluncard_gradient_bg_layout)) instanceof RoundCornerLinearLayout) {
                            int[] colors = new int[gradientBgColor.length];
                            for (int i = 0; i < gradientBgColor.length; ++i) {
                                String temColor = gradientBgColor[i];
                                if (TextUtils.isEmpty((CharSequence)temColor)) continue;
                                colors[i] = Color.parseColor((String)temColor);
                            }
                            ((RoundCornerLinearLayout)gradientContainer).setGradientBackgroundColors(colors);
                            break;
                        }
                        break block13;
                    }
                    default: {
                        this.setDefaultRootBg(view);
                    }
                }
                break block13;
            }
            this.setDefaultRootBg(view);
        }
    }

    private void setDefaultRootBg(View view) {
        if (CommonUtils.isBrandXos()) {
            if (CommonUtils.isLaterThanVersion12_0()) {
                view.setBackgroundColor(view.getContext().getColor(R.color.sdk_koluncard_xos_card_background_color_12_0));
            } else {
                view.setBackgroundColor(view.getContext().getColor(R.color.sdk_koluncard_xos_card_background_color));
            }
        } else {
            view.setBackgroundColor(view.getContext().getColor(R.color.sdk_koluncard_hios_card_background_color));
        }
    }

    public long getCardId() {
        return this.cardId;
    }

    private CardBgRes getClientBgResource(Context context, Pack actualPack) {
        CardBgRes cardBgRes = null;
        BackgroundRes bgRes = actualPack.getBackgroundRes();
        if (bgRes != null) {
            AtomicReference currentClientRes = new AtomicReference();
            List clientModuleResList = bgRes.getClientModuleResList();
            clientModuleResList.forEach(clientModuleRes -> {
                if (clientModuleRes.getModuleName().equalsIgnoreCase(context.getPackageName())) {
                    currentClientRes.set(clientModuleRes);
                }
            });
            ClientModuleRes currentClientBg = (ClientModuleRes)currentClientRes.get();
            if (currentClientBg != null) {
                boolean nightMode = (context.getResources().getConfiguration().uiMode & 0x30) == 32;
                Log.d((String)TAG, (String)("getClientBgResource nightMode: " + nightMode));
                cardBgRes = currentClientBg.getLightRes();
                if (nightMode && currentClientBg.getDarkRes() != null) {
                    cardBgRes = currentClientBg.getDarkRes();
                }
            }
        }
        return cardBgRes;
    }

    private Drawable getRootBgDrawable(Context context, CardBitmap rootContainerBg) {
        if (rootContainerBg != null) {
            return new BitmapDrawable(context.getResources(), UIUtils.getBitmap(rootContainerBg, context, context.getPackageName()));
        }
        return null;
    }

    public static TemplateKolunCard create(KolunCard kolunCard) {
        return new TemplateKolunCard(kolunCard);
    }

    public boolean isTemplateCard() {
        return this.kolunCard == null;
    }

    public KolunCard getKolunCard() {
        return this.kolunCard;
    }

    public boolean isNeedRefresh() {
        return this.needRefresh;
    }

    public void setNeedRefresh(boolean needRefresh) {
        this.needRefresh = needRefresh;
    }

    public void setSpecialState(SpecialState specialState) {
        this.actualPack.setSpecialState(specialState);
    }

    public SpecialState getSpecialState() {
        return this.actualPack.getSpecialState();
    }

    public boolean isRefreshing() {
        return this.isRefreshing;
    }

    public void setRefreshing(boolean refreshing) {
        this.isRefreshing = refreshing;
    }

    public long getTryRefreshTime() {
        return this.tryRefreshTime;
    }

    public void setTryRefreshTime(long tryRefreshTime) {
        this.tryRefreshTime = tryRefreshTime;
    }
}

