/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.kolun.cardtemplate.customwidget;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.util.AttributeSet;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatImageView;
import androidx.core.content.res.ResourcesCompat;
import com.transsion.kolun.cardtemplate.R;
import com.transsion.kolun.cardtemplate.customwidget.CustomViewUtils;

public class CustomCardImageView
extends AppCompatImageView {
    private int mWidth;
    private int mHeight;
    private int mRadius = 0;
    private int mLeftTopRadius;
    private int mLeftBottomRadius;
    private int mRightTopRadius;
    private int mRightBottomRadius;
    private boolean mIsCircle;

    public CustomCardImageView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public CustomCardImageView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Context context, AttributeSet attrs) {
        TypedArray typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.SdkKolunCardRoundCornerView, 0, 0);
        try {
            this.mRadius = typedArray.getDimensionPixelOffset(R.styleable.SdkKolunCardRoundCornerView_sdk_koluncard_corner_radius, 0);
            this.mLeftTopRadius = typedArray.getDimensionPixelOffset(R.styleable.SdkKolunCardRoundCornerView_sdk_koluncard_left_top_corner_radius, this.mRadius);
            this.mRightTopRadius = typedArray.getDimensionPixelOffset(R.styleable.SdkKolunCardRoundCornerView_sdk_koluncard_right_top_corner_radius, this.mRadius);
            this.mLeftBottomRadius = typedArray.getDimensionPixelOffset(R.styleable.SdkKolunCardRoundCornerView_sdk_koluncard_left_bottom_corner_radius, this.mRadius);
            this.mRightBottomRadius = typedArray.getDimensionPixelOffset(R.styleable.SdkKolunCardRoundCornerView_sdk_koluncard_right_bottom_corner_radius, this.mRadius);
            this.mIsCircle = typedArray.getBoolean(R.styleable.SdkKolunCardRoundCornerView_sdk_koluncard_is_circle, false);
        }
        finally {
            typedArray.recycle();
            this.setImageDrawable(ResourcesCompat.getDrawable((Resources)this.getResources(), (int)R.color.sdk_koluncard_default_image_bg_color, null));
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.mWidth = this.getWidth();
        this.mHeight = this.getHeight();
    }

    protected void onDraw(Canvas canvas) {
        if (this.mIsCircle && this.mWidth == this.mHeight) {
            CustomViewUtils.clipCircleCanvas(canvas, this.mWidth);
        } else {
            CustomViewUtils.clipRoundCornerCanvas(canvas, this.mWidth, this.mHeight, this.mLeftTopRadius, this.mRightTopRadius, this.mRightBottomRadius, this.mLeftBottomRadius);
        }
        super.onDraw(canvas);
    }
}

