/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.kolun.cardtemplate.customwidget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.util.AttributeSet;
import androidx.annotation.IdRes;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatTextView;
import com.transsion.kolun.cardtemplate.R;
import com.transsion.kolun.cardtemplate.customwidget.CustomViewUtils;

public class CustomLabelView
extends AppCompatTextView {
    private int mRadius = 0;
    private int mLeftTopRadius;
    private int mLeftBottomRadius;
    private int mRightTopRadius;
    private int mRightBottomRadius;
    private int mStrokeWidth;
    private int mStrokeColor;
    private int mDashWidth;
    private int mDashGap;
    private int mSizeHeight;
    private int mBackgroundColor;

    public CustomLabelView(Context context) {
        super(context);
    }

    public CustomLabelView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public CustomLabelView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Context context, AttributeSet attrs) {
        TypedArray typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.SdkKolunCardRoundCornerView, 0, 0);
        try {
            this.mRadius = typedArray.getDimensionPixelOffset(R.styleable.SdkKolunCardRoundCornerView_sdk_koluncard_corner_radius, 0);
            this.mLeftTopRadius = typedArray.getDimensionPixelOffset(R.styleable.SdkKolunCardRoundCornerView_sdk_koluncard_left_top_corner_radius, this.mRadius);
            this.mRightTopRadius = typedArray.getDimensionPixelOffset(R.styleable.SdkKolunCardRoundCornerView_sdk_koluncard_right_top_corner_radius, this.mRadius);
            this.mLeftBottomRadius = typedArray.getDimensionPixelOffset(R.styleable.SdkKolunCardRoundCornerView_sdk_koluncard_left_bottom_corner_radius, this.mRadius);
            this.mRightBottomRadius = typedArray.getDimensionPixelOffset(R.styleable.SdkKolunCardRoundCornerView_sdk_koluncard_right_bottom_corner_radius, this.mRadius);
            this.mStrokeWidth = typedArray.getDimensionPixelOffset(R.styleable.SdkKolunCardRoundCornerView_sdk_koluncard_layout_stroke_width, 0);
            this.mStrokeColor = typedArray.getColor(R.styleable.SdkKolunCardRoundCornerView_sdk_koluncard_layout_stroke_color, 0);
            this.mDashWidth = typedArray.getDimensionPixelOffset(R.styleable.SdkKolunCardRoundCornerView_sdk_koluncard_layout_stroke_dash_width, 0);
            this.mDashGap = typedArray.getDimensionPixelOffset(R.styleable.SdkKolunCardRoundCornerView_sdk_koluncard_layout_stroke_dash_gap, 0);
            this.mSizeHeight = typedArray.getDimensionPixelOffset(R.styleable.SdkKolunCardRoundCornerView_sdk_koluncard_layout_size_height, 0);
            this.mBackgroundColor = typedArray.getColor(R.styleable.SdkKolunCardRoundCornerView_sdk_koluncard_background_color, 0);
            this.initBackground();
        }
        finally {
            typedArray.recycle();
        }
    }

    public void setBackgroundColor(@IdRes int colorId) {
        this.mBackgroundColor = colorId;
        if (this.getBackground() instanceof GradientDrawable) {
            GradientDrawable gradientDrawable = (GradientDrawable)this.getBackground();
            gradientDrawable.setColor(this.mBackgroundColor);
        }
    }

    private void initBackground() {
        int shape = 0;
        float[] cornerRadii = new float[]{this.mLeftTopRadius, this.mLeftTopRadius, this.mRightTopRadius, this.mRightTopRadius, this.mRightBottomRadius, this.mRightBottomRadius, this.mLeftBottomRadius, this.mLeftBottomRadius};
        this.setBackground((Drawable)CustomViewUtils.drawBackgroundDrawable(this.getWidth(), this.mSizeHeight, shape, this.mBackgroundColor, cornerRadii, this.mStrokeWidth, this.mStrokeColor, this.mDashWidth, this.mDashGap));
    }
}

