/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.kolun.cardtemplate.customwidget;

import android.graphics.Canvas;
import android.graphics.DrawFilter;
import android.graphics.PaintFlagsDrawFilter;
import android.graphics.Path;
import android.graphics.drawable.GradientDrawable;
import androidx.annotation.ColorInt;

public class CustomViewUtils {
    public static Canvas clipRoundCornerCanvas(Canvas canvas, float width, float height, int leftTopRadius, int rightTopRadius, int rightBottomRadius, int leftBottomRadius) {
        int maxLeft = Math.max(leftTopRadius, leftBottomRadius);
        int maxRight = Math.max(rightTopRadius, rightBottomRadius);
        int maxTop = Math.max(leftTopRadius, rightTopRadius);
        int maxBottom = Math.max(leftBottomRadius, rightBottomRadius);
        int minWidth = maxLeft + maxRight;
        int minHeight = maxTop + maxBottom;
        canvas.setDrawFilter((DrawFilter)new PaintFlagsDrawFilter(0, 3));
        if (width >= (float)minWidth && height >= (float)minHeight) {
            Path path = new Path();
            path.moveTo((float)leftTopRadius, 0.0f);
            path.lineTo(width - (float)rightTopRadius, 0.0f);
            path.quadTo(width, 0.0f, width, (float)rightTopRadius);
            path.lineTo(width, height - (float)rightBottomRadius);
            path.quadTo(width, height, width - (float)rightBottomRadius, height);
            path.lineTo((float)leftBottomRadius, height);
            path.quadTo(0.0f, height, 0.0f, height - (float)leftTopRadius);
            path.lineTo(0.0f, (float)leftTopRadius);
            path.quadTo(0.0f, 0.0f, (float)leftTopRadius, 0.0f);
            canvas.clipPath(path);
            path.close();
        }
        return canvas;
    }

    public static void clipCircleCanvas(Canvas canvas, float diameter) {
        Path path = new Path();
        float radius = diameter / 2.0f;
        path.addCircle(radius, radius, radius, Path.Direction.CW);
        canvas.clipPath(path);
        canvas.setDrawFilter((DrawFilter)new PaintFlagsDrawFilter(0, 3));
        path.close();
    }

    public static GradientDrawable drawBackgroundDrawable(int width, int height, int shape, int color2, float[] cornerRadii, int strokeWidth, @ColorInt int strokeColor, float dashWidth, float dashGap) {
        GradientDrawable gradientDrawable = new GradientDrawable();
        gradientDrawable.setShape(shape);
        gradientDrawable.setColor(color2);
        gradientDrawable.setCornerRadii(cornerRadii);
        gradientDrawable.setStroke(strokeWidth, strokeColor, dashWidth, dashGap);
        gradientDrawable.setSize(width, height);
        return gradientDrawable;
    }
}

