/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.kolun.cardtemplate.customwidget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.util.AttributeSet;
import android.view.View;
import android.widget.LinearLayout;
import androidx.annotation.ColorInt;
import androidx.annotation.IdRes;
import androidx.annotation.Keep;
import com.transsion.kolun.cardtemplate.R;
import com.transsion.kolun.cardtemplate.bean.base.CardResSource;
import com.transsion.kolun.cardtemplate.bean.pack.TemplateData;
import com.transsion.kolun.cardtemplate.customwidget.CustomViewUtils;
import com.transsion.kolun.cardtemplate.customwidget.IOnWindowVisibility;
import com.transsion.kolun.cardtemplate.engine.RenderEngine;
import com.transsion.kolun.cardtemplate.engine.template.viewmodel.CommonViewModel;
import com.transsion.kolun.cardtemplate.layout.pack.TemplateLyt;
import com.transsion.kolun.cardtemplate.transport.pack.Pack;

public class RoundCornerLinearLayout
extends LinearLayout {
    private int mBackgroundColor;
    private final int mLeftTopRadius;
    private final int mRightTopRadius;
    private final int mRightBottomRadius;
    private final int mLeftBottomRadius;
    private final int mRadius;
    private final int mStrokeWidth;
    private final int mStrokeColor;
    private final int mDashWidth;
    private final int mDashGap;
    private final int mSizeHeight;
    private IOnWindowVisibility mIVisibility;
    private Pack mMetaData;
    private RenderEngine.EngineModel<CommonViewModel> mEngineModel;
    private final IOnWindowVisibility mIOnWindowVisibility = new IOnWindowVisibility(){
        private boolean mIsCardVisible = false;

        @Override
        public void onViewVisible() {
            TemplateData data;
            this.mIsCardVisible = true;
            TemplateLyt layout2 = RoundCornerLinearLayout.this.mMetaData.getLayout();
            if (layout2 != null) {
                ((CommonViewModel)RoundCornerLinearLayout.this.mEngineModel.getEngineViewModel()).onLayoutUpdate(layout2, (View)RoundCornerLinearLayout.this, RoundCornerLinearLayout.this.mMetaData.getSpecialState(), RoundCornerLinearLayout.this.mMetaData.getViewHeight());
            }
            if ((data = RoundCornerLinearLayout.this.mMetaData.getData()) != null) {
                ((CommonViewModel)RoundCornerLinearLayout.this.mEngineModel.getEngineViewModel()).onDataUpdate(data, (View)RoundCornerLinearLayout.this, RoundCornerLinearLayout.this.mMetaData.getSpecialState(), RoundCornerLinearLayout.this.mMetaData.getViewHeight());
            }
        }

        @Override
        public void onViewInVisible() {
            this.mIsCardVisible = false;
        }
    };

    public RoundCornerLinearLayout(Context context) {
        this(context, null);
    }

    public RoundCornerLinearLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public RoundCornerLinearLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    public RoundCornerLinearLayout(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        TypedArray array = context.obtainStyledAttributes(attrs, R.styleable.SdkKolunCardRoundCornerView);
        this.mRadius = array.getDimensionPixelOffset(R.styleable.SdkKolunCardRoundCornerView_sdk_koluncard_corner_radius, 0);
        this.mBackgroundColor = array.getColor(R.styleable.SdkKolunCardRoundCornerView_sdk_koluncard_background_color, 0);
        this.mLeftTopRadius = array.getDimensionPixelOffset(R.styleable.SdkKolunCardRoundCornerView_sdk_koluncard_left_top_corner_radius, this.mRadius);
        this.mRightTopRadius = array.getDimensionPixelOffset(R.styleable.SdkKolunCardRoundCornerView_sdk_koluncard_right_top_corner_radius, this.mRadius);
        this.mRightBottomRadius = array.getDimensionPixelOffset(R.styleable.SdkKolunCardRoundCornerView_sdk_koluncard_right_bottom_corner_radius, this.mRadius);
        this.mLeftBottomRadius = array.getDimensionPixelOffset(R.styleable.SdkKolunCardRoundCornerView_sdk_koluncard_left_bottom_corner_radius, this.mRadius);
        this.mStrokeWidth = array.getDimensionPixelOffset(R.styleable.SdkKolunCardRoundCornerView_sdk_koluncard_layout_stroke_width, 0);
        this.mStrokeColor = array.getColor(R.styleable.SdkKolunCardRoundCornerView_sdk_koluncard_layout_stroke_color, 0);
        this.mDashWidth = array.getDimensionPixelOffset(R.styleable.SdkKolunCardRoundCornerView_sdk_koluncard_layout_stroke_dash_width, 0);
        this.mDashGap = array.getDimensionPixelOffset(R.styleable.SdkKolunCardRoundCornerView_sdk_koluncard_layout_stroke_dash_gap, 0);
        this.mSizeHeight = array.getDimensionPixelOffset(R.styleable.SdkKolunCardRoundCornerView_sdk_koluncard_layout_size_height, 0);
        array.recycle();
        this.initBackground();
    }

    public void setBackgroundColor(@IdRes int colorId) {
        this.mBackgroundColor = colorId;
        if (this.getBackground() instanceof GradientDrawable) {
            GradientDrawable gradientDrawable = (GradientDrawable)this.getBackground();
            gradientDrawable.setColor(this.mBackgroundColor);
        }
    }

    private void initBackground() {
        int shape = 0;
        float[] cornerRadii = new float[]{this.mLeftTopRadius, this.mLeftTopRadius, this.mRightTopRadius, this.mRightTopRadius, this.mRightBottomRadius, this.mRightBottomRadius, this.mLeftBottomRadius, this.mLeftBottomRadius};
        this.setBackground((Drawable)CustomViewUtils.drawBackgroundDrawable(this.getWidth(), this.mSizeHeight, shape, this.mBackgroundColor, cornerRadii, this.mStrokeWidth, this.mStrokeColor, this.mDashWidth, this.mDashGap));
    }

    public void setGradientBackgroundColors(@ColorInt int[] colors) {
        if (this.getBackground() instanceof GradientDrawable && colors.length == 3) {
            GradientDrawable gradientDrawable = (GradientDrawable)this.getBackground();
            gradientDrawable.setColors(colors);
        }
    }

    protected void onWindowVisibilityChanged(int visibility) {
        super.onWindowVisibilityChanged(visibility);
        if (visibility == 0) {
            if (this.mIVisibility != null) {
                this.mIVisibility.onViewVisible();
            }
        } else if ((visibility == 8 || visibility == 4) && this.mIVisibility != null) {
            this.mIVisibility.onViewInVisible();
        }
    }

    public void registerVisibilityEvent(Pack metaData, RenderEngine.EngineModel<CommonViewModel> engineModel) {
        this.mMetaData = metaData;
        this.mEngineModel = engineModel;
        this.mIVisibility = this.mIOnWindowVisibility;
    }

    @Keep
    public String getAppPackage() {
        CardResSource cardResSource;
        TemplateData data;
        if (this.mMetaData != null && (data = this.mMetaData.getData()) != null && (cardResSource = data.getCardResSource()) != null) {
            return cardResSource.getPackageName();
        }
        return "";
    }

    @Keep
    public String getCardId() {
        if (this.mMetaData != null) {
            return String.valueOf(this.mMetaData.getCardId());
        }
        return null;
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        if (this.mMetaData != null) {
            this.mMetaData.setViewHeight(this.getHeight());
        }
    }
}

