/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.kolun.cardtemplate.customwidget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.util.AttributeSet;
import android.view.View;
import android.widget.RelativeLayout;
import androidx.annotation.Keep;
import com.transsion.kolun.cardtemplate.R;
import com.transsion.kolun.cardtemplate.bean.base.CardResSource;
import com.transsion.kolun.cardtemplate.bean.pack.TemplateData;
import com.transsion.kolun.cardtemplate.customwidget.CustomViewUtils;
import com.transsion.kolun.cardtemplate.customwidget.IOnWindowVisibility;
import com.transsion.kolun.cardtemplate.engine.RenderEngine;
import com.transsion.kolun.cardtemplate.engine.template.viewmodel.CommonViewModel;
import com.transsion.kolun.cardtemplate.layout.pack.TemplateLyt;
import com.transsion.kolun.cardtemplate.transport.pack.Pack;

public class RoundCornerRelativeLayout
extends RelativeLayout {
    private int mRadius;
    private float mWidth;
    private float mHeight;
    private int mLeftTopRadius;
    private int mLeftBottomRadius;
    private int mRightTopRadius;
    private int mRightBottomRadius;
    private IOnWindowVisibility mIVisibility;
    private float mHeightScale;
    private Pack mMetaData;
    private RenderEngine.EngineModel<CommonViewModel> mEngineModel;
    private final IOnWindowVisibility mIOnWindowVisibility = new IOnWindowVisibility(){
        private boolean mIsCardVisible = false;

        @Override
        public void onViewVisible() {
            TemplateData data;
            this.mIsCardVisible = true;
            TemplateLyt layout2 = RoundCornerRelativeLayout.this.mMetaData.getLayout();
            if (layout2 != null) {
                ((CommonViewModel)RoundCornerRelativeLayout.this.mEngineModel.getEngineViewModel()).onLayoutUpdate(layout2, (View)RoundCornerRelativeLayout.this, RoundCornerRelativeLayout.this.mMetaData.getSpecialState(), RoundCornerRelativeLayout.this.mMetaData.getViewHeight());
            }
            if ((data = RoundCornerRelativeLayout.this.mMetaData.getData()) != null) {
                ((CommonViewModel)RoundCornerRelativeLayout.this.mEngineModel.getEngineViewModel()).onDataUpdate(data, (View)RoundCornerRelativeLayout.this, RoundCornerRelativeLayout.this.mMetaData.getSpecialState(), RoundCornerRelativeLayout.this.mMetaData.getViewHeight());
            }
        }

        @Override
        public void onViewInVisible() {
            this.mIsCardVisible = false;
        }
    };

    public RoundCornerRelativeLayout(Context context) {
        this(context, null);
    }

    public RoundCornerRelativeLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public RoundCornerRelativeLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    public RoundCornerRelativeLayout(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context, attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Context context, AttributeSet attrs) {
        TypedArray typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.SdkKolunCardRoundCornerView, 0, 0);
        try {
            this.mRadius = typedArray.getDimensionPixelOffset(R.styleable.SdkKolunCardRoundCornerView_sdk_koluncard_corner_radius, 0);
            this.mLeftTopRadius = typedArray.getDimensionPixelOffset(R.styleable.SdkKolunCardRoundCornerView_sdk_koluncard_left_top_corner_radius, this.mRadius);
            this.mRightTopRadius = typedArray.getDimensionPixelOffset(R.styleable.SdkKolunCardRoundCornerView_sdk_koluncard_right_top_corner_radius, this.mRadius);
            this.mLeftBottomRadius = typedArray.getDimensionPixelOffset(R.styleable.SdkKolunCardRoundCornerView_sdk_koluncard_left_bottom_corner_radius, this.mRadius);
            this.mRightBottomRadius = typedArray.getDimensionPixelOffset(R.styleable.SdkKolunCardRoundCornerView_sdk_koluncard_right_bottom_corner_radius, this.mRadius);
        }
        finally {
            typedArray.recycle();
        }
    }

    public void setImageViewLayoutHeight(int itemNumber) {
        switch (itemNumber) {
            case 1: {
                this.mHeightScale = 0.6666667f;
                break;
            }
            case 2: {
                this.mHeightScale = 0.5625f;
                break;
            }
            case 3: {
                this.mHeightScale = 1.0f;
                break;
            }
            case 4: {
                this.mHeightScale = 1.3333334f;
                break;
            }
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.mWidth = this.getWidth();
        this.mHeight = this.getHeight();
        if (this.mMetaData != null) {
            this.mMetaData.setViewHeight(this.getHeight());
        }
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(CustomViewUtils.clipRoundCornerCanvas(canvas, this.mWidth, this.mHeight, this.mLeftTopRadius, this.mRightTopRadius, this.mRightBottomRadius, this.mLeftBottomRadius));
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        if (this.mHeightScale > 0.0f) {
            heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)((int)((float)width * this.mHeightScale)), (int)0x40000000);
        }
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    protected void onWindowVisibilityChanged(int visibility) {
        super.onWindowVisibilityChanged(visibility);
        if (visibility == 0) {
            if (this.mIVisibility != null) {
                this.mIVisibility.onViewVisible();
            }
        } else if ((visibility == 8 || visibility == 4) && this.mIVisibility != null) {
            this.mIVisibility.onViewInVisible();
        }
    }

    public void registerVisibilityEvent(Pack metaData, RenderEngine.EngineModel<CommonViewModel> engineModel) {
        this.mMetaData = metaData;
        this.mEngineModel = engineModel;
        this.mIVisibility = this.mIOnWindowVisibility;
    }

    @Keep
    public String getAppPackage() {
        CardResSource cardResSource;
        TemplateData data;
        if (this.mMetaData != null && (data = this.mMetaData.getData()) != null && (cardResSource = data.getCardResSource()) != null) {
            return cardResSource.getPackageName();
        }
        return "";
    }

    @Keep
    public String getCardId() {
        if (this.mMetaData != null) {
            return String.valueOf(this.mMetaData.getCardId());
        }
        return null;
    }
}

