/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.kolun.cardtemplate.engine;

import android.content.Context;
import android.content.pm.PackageManager;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import com.transsion.kolun.cardtemplate.R;
import com.transsion.kolun.cardtemplate.bean.content.basictext.BasicTextContent;
import com.transsion.kolun.cardtemplate.bean.content.icongrid.CardContentTypeIconGrid;
import com.transsion.kolun.cardtemplate.bean.content.image.CardContentTypeImage;
import com.transsion.kolun.cardtemplate.bean.content.imagegrid.CardContentTypeImageGrid;
import com.transsion.kolun.cardtemplate.bean.content.mix.CardContentTypeMix;
import com.transsion.kolun.cardtemplate.bean.content.textgrid.CardContentTypeTextGrid;
import com.transsion.kolun.cardtemplate.bean.pack.BasicTemplateData;
import com.transsion.kolun.cardtemplate.bean.pack.TemplateData;
import com.transsion.kolun.cardtemplate.engine.RenderEngine;
import com.transsion.kolun.cardtemplate.engine.template.viewmodel.BasicTemplateViewModel;
import com.transsion.kolun.cardtemplate.engine.view.basictext.BasicTextViewGroup;
import com.transsion.kolun.cardtemplate.engine.view.icongrid.IconGridViewGroup;
import com.transsion.kolun.cardtemplate.engine.view.imagegrid.ImageGridViewGroup;
import com.transsion.kolun.cardtemplate.engine.view.imagetext.ImageTextViewGroup;
import com.transsion.kolun.cardtemplate.engine.view.mixtype.MixTypeViewGroup;
import com.transsion.kolun.cardtemplate.engine.view.textgrid.TextGridViewGroup;
import com.transsion.kolun.cardtemplate.layout.content.basictext.BasicTextContentLyt;
import com.transsion.kolun.cardtemplate.layout.content.icongrid.CardIconGridLyt;
import com.transsion.kolun.cardtemplate.layout.content.image.BasicImageContentLyt;
import com.transsion.kolun.cardtemplate.layout.content.imagegrid.CardImageGridLyt;
import com.transsion.kolun.cardtemplate.layout.content.mix.BasicMixContentLyt;
import com.transsion.kolun.cardtemplate.layout.content.textgrid.CardTextGridLyt;
import com.transsion.kolun.cardtemplate.layout.pack.BasicTemplateLyt;
import com.transsion.kolun.cardtemplate.layout.pack.TemplateLyt;
import com.transsion.kolun.cardtemplate.state.SpecialState;
import com.transsion.kolun.cardtemplate.transport.pack.BasicTemplatePack;
import com.transsion.kolun.cardtemplate.transport.pack.Pack;

public class BasicTemplateEngine
extends RenderEngine {
    private static final String TAG = "BasicTemplateEngine";

    @Override
    public RenderEngine.EngineModel render(Context context, String templateLytName, Pack data) {
        BasicTemplatePack basicPack = (BasicTemplatePack)data;
        String layoutPackageName = basicPack.getTemplateSourceInApk().getPackageName();
        try {
            int contentId = basicPack.getContentId();
            if (!TextUtils.isEmpty((CharSequence)layoutPackageName)) {
                context = context.createPackageContext(layoutPackageName, 3);
            }
            Context finContext = context;
            View finView = LayoutInflater.from((Context)context).inflate(this.getCardLayoutId(finContext, templateLytName), null, false);
            return new RenderEngine.EngineModel<BasicTemplateViewModel>(new BasicTemplateViewModel(this, contentId), finView);
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.d((String)TAG, (String)(layoutPackageName + " not find " + (Object)((Object)e)));
            return null;
        }
    }

    public void onBindBasicTemplate(View view, int contentId, BasicTemplateData data, SpecialState specialState, int viewHeight) {
        this.onBindCommon(view, (TemplateData)data, specialState, viewHeight);
        View contentView = view.findViewById(R.id.sdk_koluncard_content_area);
        switch (contentId) {
            case 10000: {
                new BasicTextViewGroup(contentView).onBindViews((BasicTextContent)data.getCardContent(), true);
                break;
            }
            case 50000: {
                new IconGridViewGroup(contentView).onBindViews((CardContentTypeIconGrid)data.getCardContent());
                break;
            }
            case 40000: {
                new ImageGridViewGroup(contentView).onBindViews((CardContentTypeImageGrid)data.getCardContent());
                break;
            }
            case 20000: {
                new ImageTextViewGroup(view).onBindViews((CardContentTypeImage)data.getCardContent());
                break;
            }
            case 30000: {
                new MixTypeViewGroup(contentView).onBindViews((CardContentTypeMix)data.getCardContent());
                break;
            }
            case 60000: {
                new TextGridViewGroup(contentView).onBindViews((CardContentTypeTextGrid)data.getCardContent());
                break;
            }
            default: {
                Log.d((String)TAG, (String)"no templateId matched");
            }
        }
    }

    public void onBindBasicTemplate(View view, int contentId, BasicTemplateLyt layout2, SpecialState specialState, int viewHeight) {
        this.onBindCommon(view, (TemplateLyt)layout2, specialState, viewHeight);
        switch (contentId) {
            case 10000: {
                new BasicTextViewGroup(view).onBindViews((BasicTextContentLyt)layout2.getCardContentLyt());
                break;
            }
            case 50000: {
                new IconGridViewGroup(view).onBindViewsLayouts((CardIconGridLyt)layout2.getCardContentLyt());
                break;
            }
            case 40000: {
                new ImageGridViewGroup(view).onBindViews((CardImageGridLyt)layout2.getCardContentLyt());
                break;
            }
            case 20000: {
                new ImageTextViewGroup(view).onBindViews((BasicImageContentLyt)layout2.getCardContentLyt());
                break;
            }
            case 30000: {
                new MixTypeViewGroup(view).onBindViews((BasicMixContentLyt)layout2.getCardContentLyt());
                break;
            }
            case 60000: {
                new TextGridViewGroup(view.findViewById(R.id.sdk_koluncard_content_area)).onBindViews((CardTextGridLyt)layout2.getCardContentLyt());
                break;
            }
            default: {
                Log.d((String)TAG, (String)"no templateId matched");
            }
        }
    }

    public void onBindBasicTemplate(View view, int contentId, BasicTemplatePack pack) {
        BasicTemplateData data = (BasicTemplateData)pack.getData();
        BasicTemplateLyt layout2 = (BasicTemplateLyt)pack.getLayout();
        this.onBindCommon(view, (TemplateData)data, (TemplateLyt)layout2, pack.getSpecialState(), pack.getViewHeight());
        View contentView = view.findViewById(R.id.sdk_koluncard_content_area);
        switch (contentId) {
            case 10000: {
                new BasicTextViewGroup(contentView).onBindViews((BasicTextContent)data.getCardContent(), (BasicTextContentLyt)layout2.getCardContentLyt(), true);
                break;
            }
            case 50000: {
                new IconGridViewGroup(contentView).onBindViews((CardContentTypeIconGrid)data.getCardContent(), (CardIconGridLyt)layout2.getCardContentLyt());
                break;
            }
            case 40000: {
                new ImageGridViewGroup(contentView).onBindViews((CardContentTypeImageGrid)data.getCardContent(), (CardImageGridLyt)layout2.getCardContentLyt());
                break;
            }
            case 20000: {
                new ImageTextViewGroup(view).onBindViews((CardContentTypeImage)data.getCardContent(), (BasicImageContentLyt)layout2.getCardContentLyt());
                break;
            }
            case 30000: {
                new MixTypeViewGroup(contentView).onBindViews((CardContentTypeMix)data.getCardContent(), (BasicMixContentLyt)layout2.getCardContentLyt());
                break;
            }
            case 60000: {
                new TextGridViewGroup(contentView).onBindViews((CardContentTypeTextGrid)data.getCardContent(), (CardTextGridLyt)layout2.getCardContentLyt());
                break;
            }
            default: {
                Log.d((String)TAG, (String)"no templateId matched");
            }
        }
    }
}

