/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.kolun.cardtemplate.engine;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.pm.PackageManager;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import androidx.recyclerview.widget.DefaultItemAnimator;
import androidx.recyclerview.widget.RecyclerView;
import com.transsion.kolun.cardtemplate.R;
import com.transsion.kolun.cardtemplate.bean.content.selectabletext.SelectableTextContent;
import com.transsion.kolun.cardtemplate.bean.pack.ListTemplateData;
import com.transsion.kolun.cardtemplate.bean.pack.TemplateData;
import com.transsion.kolun.cardtemplate.engine.RenderEngine;
import com.transsion.kolun.cardtemplate.engine.template.SpacingItemDecoration;
import com.transsion.kolun.cardtemplate.engine.template.viewmodel.ListTemplateViewModel;
import com.transsion.kolun.cardtemplate.engine.view.list.ImageTextListAdapter;
import com.transsion.kolun.cardtemplate.engine.view.list.MixListAdapter;
import com.transsion.kolun.cardtemplate.engine.view.list.SelectableTextListAdapter;
import com.transsion.kolun.cardtemplate.engine.view.list.TextListAdapter;
import com.transsion.kolun.cardtemplate.engine.view.selectabletext.SelectableTextListViewGroup;
import com.transsion.kolun.cardtemplate.layout.content.basictext.BasicTextContentLyt;
import com.transsion.kolun.cardtemplate.layout.content.image.BasicImageContentLyt;
import com.transsion.kolun.cardtemplate.layout.content.mix.BasicMixContentLyt;
import com.transsion.kolun.cardtemplate.layout.content.selectabletext.SelectableTextLyt;
import com.transsion.kolun.cardtemplate.layout.pack.ListTemplateLyt;
import com.transsion.kolun.cardtemplate.layout.pack.TemplateLyt;
import com.transsion.kolun.cardtemplate.state.SpecialState;
import com.transsion.kolun.cardtemplate.transport.pack.ListTemplatePack;
import com.transsion.kolun.cardtemplate.transport.pack.Pack;

public class ListTemplateEngine
extends RenderEngine {
    private static final String TAG = "ListTemplateEngine";
    private RecyclerView.Adapter mAdapter;

    @Override
    public RenderEngine.EngineModel render(Context context, String templateLytName, Pack data) {
        ListTemplatePack listTemplatePack = (ListTemplatePack)data;
        String layoutPackageName = listTemplatePack.getTemplateSourceInApk().getPackageName();
        try {
            if (!TextUtils.isEmpty((CharSequence)layoutPackageName)) {
                context = context.createPackageContext(layoutPackageName, 1);
            }
            Context finContext = context;
            View finView = LayoutInflater.from((Context)context).inflate(this.getCardLayoutId(finContext, templateLytName), null, false);
            int contentId = listTemplatePack.getContentId();
            this.initRecyclerView(finView, contentId);
            return new RenderEngine.EngineModel<ListTemplateViewModel>(new ListTemplateViewModel(this, contentId), finView);
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.d((String)TAG, (String)(layoutPackageName + " not find " + (Object)((Object)e)));
            return null;
        }
    }

    @SuppressLint(value={"WrongConstant"})
    public void onBindListTemplateViews(View view, ListTemplatePack template) {
        ListTemplateData data = (ListTemplateData)template.getData();
        ListTemplateLyt layout2 = (ListTemplateLyt)template.getLayout();
        this.onBindCommon(view, (TemplateData)data, (TemplateLyt)layout2, template.getSpecialState(), template.getViewHeight());
        int contentId = template.getContentId();
        int packId = template.getPackId();
        int templateId = contentId + packId;
        switch (templateId) {
            case 21003: {
                ((ImageTextListAdapter)this.mAdapter).setCardContents(data.getCardContent(), (BasicImageContentLyt)layout2.getCardContentLyt());
                break;
            }
            case 31003: {
                ((MixListAdapter)this.mAdapter).setCardContents(data.getCardContent(), (BasicMixContentLyt)layout2.getCardContentLyt());
                break;
            }
            case 11003: {
                ((TextListAdapter)this.mAdapter).setCardContents(data.getCardContent(), (BasicTextContentLyt)layout2.getCardContentLyt());
                break;
            }
            case 71003: {
                SelectableTextLyt lyt = (SelectableTextLyt)layout2.getCardContentLyt();
                if (!lyt.isEmptyStateViewInvisible()) {
                    this.onBindListTemplateViews(view, contentId, layout2, template.getSpecialState(), template.getViewHeight());
                    break;
                }
                ((SelectableTextListAdapter)this.mAdapter).setCardContents(data.getCardContent(), lyt);
                break;
            }
            default: {
                Log.d((String)TAG, (String)("onBindListTemplateViews, no templateId matched -> " + template.getContentId()));
            }
        }
    }

    public void onBindListTemplateViews(View view, int contentId, ListTemplateData data, SpecialState specialState, int viewHeight) {
        this.onBindCommon(view, (TemplateData)data, specialState, viewHeight);
        switch (contentId) {
            case 20000: {
                ((ImageTextListAdapter)this.mAdapter).setCardContents(data.getCardContent());
                break;
            }
            case 30000: {
                ((MixListAdapter)this.mAdapter).setCardContents(data.getCardContent());
                break;
            }
            case 10000: {
                ((TextListAdapter)this.mAdapter).setCardContents(data.getCardContent());
                break;
            }
            case 70000: {
                new SelectableTextListViewGroup(view, (SelectableTextListAdapter)this.mAdapter).onBindViews((ListTemplateData<SelectableTextContent>)data);
                break;
            }
            default: {
                Log.d((String)TAG, (String)("onBindListTemplateViews data, no contentId matched -> " + contentId));
            }
        }
    }

    public void onBindListTemplateViews(View view, int contentId, ListTemplateLyt layout2, SpecialState specialState, int viewHeight) {
        this.onBindCommon(view, (TemplateLyt)layout2, specialState, viewHeight);
        switch (contentId) {
            case 20000: {
                ((ImageTextListAdapter)this.mAdapter).setCardContents((BasicImageContentLyt)layout2.getCardContentLyt());
                break;
            }
            case 30000: {
                ((MixListAdapter)this.mAdapter).setCardContents((BasicMixContentLyt)layout2.getCardContentLyt());
                break;
            }
            case 10000: {
                ((TextListAdapter)this.mAdapter).setCardContents((BasicTextContentLyt)layout2.getCardContentLyt());
                break;
            }
            case 70000: {
                new SelectableTextListViewGroup(view, (SelectableTextListAdapter)this.mAdapter).onBindViews((SelectableTextLyt)layout2.getCardContentLyt());
                break;
            }
            default: {
                Log.d((String)TAG, (String)("onBindListTemplateViews layout, no contentId matched -> " + contentId));
            }
        }
    }

    private void initRecyclerView(View view, int contentId) {
        boolean hasDivider = true;
        Context context = view.getContext();
        int space = (int)context.getResources().getDimension(R.dimen.dp_20);
        RecyclerView recyclerView = (RecyclerView)view.findViewById(R.id.sdk_koluncard_content_area);
        if (recyclerView != null) {
            switch (contentId) {
                case 20000: {
                    this.mAdapter = new ImageTextListAdapter();
                    break;
                }
                case 30000: {
                    this.mAdapter = new MixListAdapter();
                    break;
                }
                case 10000: {
                    this.mAdapter = new TextListAdapter();
                    break;
                }
                case 70000: {
                    this.mAdapter = new SelectableTextListAdapter();
                    recyclerView.setItemAnimator((RecyclerView.ItemAnimator)new DefaultItemAnimator());
                    hasDivider = false;
                    space = (int)context.getResources().getDimension(R.dimen.dp_10);
                    break;
                }
                default: {
                    Log.d((String)TAG, (String)("initRecyclerView no contentId matched -> " + contentId));
                    return;
                }
            }
            recyclerView.setAdapter(this.mAdapter);
            recyclerView.addItemDecoration((RecyclerView.ItemDecoration)new SpacingItemDecoration(context, space, hasDivider));
            recyclerView.setItemAnimator((RecyclerView.ItemAnimator)this.getConfiguredAnimator());
        }
    }

    private DefaultItemAnimator getConfiguredAnimator() {
        DefaultItemAnimator animator = new DefaultItemAnimator();
        animator.setRemoveDuration(0L);
        animator.setChangeDuration(300L);
        return animator;
    }
}

