/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.kolun.cardtemplate.engine;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.res.Resources;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.content.res.AppCompatResources;
import androidx.appcompat.widget.ListPopupWindow;
import com.transsion.kolun.cardtemplate.R;
import com.transsion.kolun.cardtemplate.bean.base.CardAction;
import com.transsion.kolun.cardtemplate.bean.base.CardBrand;
import com.transsion.kolun.cardtemplate.bean.base.CardOperation;
import com.transsion.kolun.cardtemplate.bean.base.CardPopMenu;
import com.transsion.kolun.cardtemplate.bean.base.CardReminder;
import com.transsion.kolun.cardtemplate.bean.base.CardTitle;
import com.transsion.kolun.cardtemplate.bean.base.CardTrackingInfo;
import com.transsion.kolun.cardtemplate.bean.pack.TemplateData;
import com.transsion.kolun.cardtemplate.customwidget.BasicTextView;
import com.transsion.kolun.cardtemplate.engine.RenderThreadHelper;
import com.transsion.kolun.cardtemplate.engine.resource.ResourceManager;
import com.transsion.kolun.cardtemplate.engine.template.viewmodel.CommonViewModel;
import com.transsion.kolun.cardtemplate.layout.base.CardBrandLyt;
import com.transsion.kolun.cardtemplate.layout.base.CardOperationLyt;
import com.transsion.kolun.cardtemplate.layout.base.CardReminderLyt;
import com.transsion.kolun.cardtemplate.layout.base.CardTitleLyt;
import com.transsion.kolun.cardtemplate.layout.pack.TemplateLyt;
import com.transsion.kolun.cardtemplate.state.SpecialState;
import com.transsion.kolun.cardtemplate.transport.pack.Pack;
import com.transsion.kolun.cardtemplate.utils.CommonUtils;
import com.transsion.kolun.cardtemplate.utils.TrackingEventUtils;
import com.transsion.kolun.cardtemplate.utils.UIUtils;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Queue;

public abstract class RenderEngine {
    public static final int NEGATIVE_BUTTON_INDEX = 0;
    public static final int NEUTRAL_BUTTON_INDEX = 1;
    public static final int POSITIVE_BUTTON_INDEX = 2;
    private static final String PACKAGE_NAME_ASSISTANT = "com.transsion.kolun.assistant";
    private static final String TEXT_LOADING_STATE = "@string/sdk_koluncard_loading_data_state";
    private static final String TEXT_NO_NETWORK = "@string/sdk_koluncard_no_network_state";
    private static final String TEXT_LOADING_FAIL = "@string/sdk_koluncard_loading_fail_state";
    public static final String TEXT_RETRY = "@string/sdk_koluncard_retry_button";

    protected RenderEngine() {
    }

    public abstract EngineModel render(Context var1, String var2, Pack var3);

    protected int getCardLayoutId(Context resourceContext, String layoutName) {
        return ResourceManager.getLayoutIdByName(resourceContext, layoutName);
    }

    protected void onBindTitleViews(View view, CardTitle content, CardTitleLyt layout2) {
        this.onBindTitleViews(view, layout2);
        this.onBindTitleViews(view, content);
    }

    protected void onBindTitleViews(View view, CardTitle content) {
        ImageView iconImageView = (ImageView)view.findViewById(R.id.sdk_koluncard_title_icon);
        BasicTextView titleTextView = (BasicTextView)view.findViewById(R.id.sdk_koluncard_title_text);
        ImageView menuMoreImageView = (ImageView)view.findViewById(R.id.sdk_koluncard_title_menu_more);
        this.setTitleMenuButton(menuMoreImageView);
        if (content != null) {
            if (iconImageView.getVisibility() == 0) {
                RenderThreadHelper.setRemoteImage(content.getTitleIcon(), iconImageView);
            }
            titleTextView.setText(content.getTitleText());
            titleTextView.setBasicTextColor(0);
        }
    }

    protected void onBindTitleViews(View view, CardTitleLyt layout2) {
        ImageView iconImageView = (ImageView)view.findViewById(R.id.sdk_koluncard_title_icon);
        BasicTextView titleTextView = (BasicTextView)view.findViewById(R.id.sdk_koluncard_title_text);
        ImageView menuMoreImageView = (ImageView)view.findViewById(R.id.sdk_koluncard_title_menu_more);
        this.setTitleMenuButton(menuMoreImageView);
        if (layout2 != null) {
            titleTextView.setVisibility(layout2.isTitleInvisible() ? 8 : 0);
            iconImageView.setVisibility(layout2.isTitleIconInvisible() ? 8 : 0);
            menuMoreImageView.setVisibility(layout2.isFunctionIconInvisible() ? 8 : 0);
        }
    }

    @SuppressLint(value={"UseCompatLoadingForDrawables"})
    private void setTitleMenuButton(ImageView menuButton) {
        if (CommonUtils.isBrandXos()) {
            menuButton.setImageResource(R.drawable.sdk_koluncard_selector_xos_title_menu);
        } else {
            menuButton.setImageResource(R.drawable.sdk_koluncard_selector_hios_title_menu);
        }
    }

    protected void addPopupMenus(View view, TemplateData data) {
        List cardPopMenus = data.getCardPopMenus();
        if (data == null || cardPopMenus == null) {
            return;
        }
        Context context = view.getContext();
        ImageView menuView = (ImageView)view.findViewById(R.id.sdk_koluncard_title_menu_more);
        ListPopupWindow popupWindow = new ListPopupWindow(context, null, R.style.SdkKolunCardPopupWindowStyle, R.style.SdkKolunCardPopupWindowStyle);
        popupWindow.setAnchorView((View)menuView);
        if (CommonUtils.isBrandXos()) {
            popupWindow.setBackgroundDrawable(AppCompatResources.getDrawable((Context)context, (int)R.drawable.sdk_koluncard_xos_popup_menu_background));
        } else {
            popupWindow.setBackgroundDrawable(AppCompatResources.getDrawable((Context)context, (int)R.drawable.sdk_koluncard_hios_popup_menu_background));
        }
        popupWindow.setHeight(-2);
        popupWindow.setModal(true);
        ArrayList<String> menuTitles = new ArrayList<String>();
        int itemMaxWidth = 0;
        int maxWidhth = (int)context.getResources().getDimension(R.dimen.dp_296);
        int minWidth = (int)context.getResources().getDimension(R.dimen.dp_80);
        for (CardPopMenu menuItem : cardPopMenus) {
            if (menuItem == null) {
                return;
            }
            menuTitles.add(menuItem.getPopMenu());
            TextView textView = (TextView)View.inflate((Context)context, (int)R.layout.sdk_koluncard_menu_item_layout, null);
            textView.setText((CharSequence)menuItem.getPopMenu());
            textView.measure(0, 0);
            itemMaxWidth = Math.max(itemMaxWidth, textView.getMeasuredWidth());
            Log.d((String)"Menu", (String)("itemMaxWidth: " + itemMaxWidth));
        }
        MenuAdapter adapter = new MenuAdapter(context, R.layout.sdk_koluncard_menu_item_layout, menuTitles);
        popupWindow.setAdapter((ListAdapter)adapter);
        if (itemMaxWidth < minWidth) {
            itemMaxWidth = minWidth;
        } else if (itemMaxWidth > maxWidhth) {
            itemMaxWidth = maxWidhth;
        }
        popupWindow.setContentWidth(itemMaxWidth);
        popupWindow.setVerticalOffset((int)context.getResources().getDimension(R.dimen.dp_8));
        popupWindow.setHorizontalOffset(-itemMaxWidth);
        popupWindow.setOnItemClickListener((parent, view1, position, id2) -> {
            popupWindow.dismiss();
            Log.d((String)"Menu", (String)("Item " + position + " clicked"));
            if (cardPopMenus.size() == 0 || cardPopMenus.get(position) == null) {
                return;
            }
            CardPopMenu menu = (CardPopMenu)cardPopMenus.get(position);
            if (menu != null) {
                CardAction action = menu.getAction();
                RenderThreadHelper.sendActionAndTracking((View)menuView, action, position);
                RenderThreadHelper.sendActionAndTracking((View)menuView, new CardAction(), "more_button_cl", position);
            }
        });
        menuView.setOnClickListener(v -> {
            popupWindow.show();
            RenderThreadHelper.sendTracking((View)menuView, "more_ribbon_cl");
        });
    }

    protected void onBindReminderViews(View view, CardReminder content, CardReminderLyt layout2) {
        this.onBindReminderViews(view, layout2);
        this.onBindReminderViews(view, content);
    }

    protected void onBindReminderViews(View view, CardReminder content) {
        BasicTextView reminderTextView = (BasicTextView)view.findViewById(R.id.sdk_koluncard_reminder_text);
        if (content != null) {
            reminderTextView.setBasicTextColor(0);
            if (content.getHighlightText() != null) {
                reminderTextView.setText((CharSequence)UIUtils.getColoredString(content.getHighlightText(), content.getReminderText(), UIUtils.getTextColorByIndex(view.getContext(), 0), content.getHighlightColor()));
            } else {
                reminderTextView.setText(content.getReminderText());
            }
        }
    }

    protected void onBindReminderViews(View view, CardReminderLyt layout2) {
        BasicTextView reminderTextView = (BasicTextView)view.findViewById(R.id.sdk_koluncard_reminder_text);
        if (layout2 != null) {
            reminderTextView.setVisibility(layout2.isInvisible() ? 8 : 0);
        }
    }

    protected void onBindBrandViews(View view, CardBrand content, CardBrandLyt layout2) {
        this.onBindBrandViews(view, layout2);
        this.onBindBrandViews(view, content);
    }

    protected void onBindBrandViews(View view, CardBrand content) {
        BasicTextView brandTextView = (BasicTextView)view.findViewById(R.id.sdk_koluncard_brand_text);
        if (content != null) {
            brandTextView.setText(content.getBrandText());
            brandTextView.setBasicTextColor(3);
        }
    }

    protected void onBindBrandViews(View view, CardBrandLyt layout2) {
        TextView brandTextView = (TextView)view.findViewById(R.id.sdk_koluncard_brand_text);
        if (layout2 != null) {
            brandTextView.setVisibility(layout2.isInvisible() ? 8 : 0);
        }
    }

    protected void onBindOperationViews(View view, CardOperation content, CardOperationLyt layout2) {
        this.onBindOperationViews(view, content);
        this.onBindOperationViews(view, layout2);
    }

    protected void onBindOperationViews(View view, CardOperation content) {
        List actions;
        List buttonTitiles;
        TextView negativeBtn = (TextView)view.findViewById(R.id.sdk_koluncard_negative_button);
        TextView neutralBtn = (TextView)view.findViewById(R.id.sdk_koluncard_neutral_button);
        TextView positiveBtn = (TextView)view.findViewById(R.id.sdk_koluncard_positive_button);
        if (content != null && (buttonTitiles = content.getButtonTitles()) != null && (actions = content.getActions()) != null) {
            int buttonSize = buttonTitiles.size();
            int actionSize = actions.size();
            if (buttonSize >= 1 && actionSize >= 1) {
                this.configureButton(negativeBtn, content, 0);
            }
            if (buttonSize >= 2 && actionSize >= 2) {
                this.configureButton(neutralBtn, content, 1);
            }
            if (buttonSize == 3 && actionSize == 3) {
                this.configureButton(positiveBtn, content, 2);
            }
        }
    }

    private void configureButton(TextView buttonView, CardOperation content, int position) {
        CardAction action = (CardAction)content.getActions().get(position);
        buttonView.setText((CharSequence)content.getButtonTitles().get(position));
        buttonView.setOnClickListener(v -> {
            CardAction actionWithTracking;
            boolean isDefaultAction;
            if (action == null) {
                return;
            }
            CardTrackingInfo trackingInfo = action.getTrackingInfo();
            boolean bl = isDefaultAction = trackingInfo != null && Arrays.asList(TrackingEventUtils.DEFAULT_ACTION_EVENT_LIST).contains(trackingInfo.getCardTrackingEvent());
            if (isDefaultAction) {
                RenderThreadHelper.sendActionAndTracking((View)buttonView, action);
                actionWithTracking = new CardAction();
            } else {
                actionWithTracking = new CardAction(action.getWebUrl(), action.getDeeplink());
            }
            RenderThreadHelper.sendActionAndTracking((View)buttonView, actionWithTracking, "bottom_button_cl", position);
        });
    }

    protected void onBindOperationViews(View view, CardOperationLyt layout2) {
        View separator = view.findViewById(R.id.sdk_koluncard_button_area_separator);
        LinearLayout buttonContainer = (LinearLayout)view.findViewById(R.id.sdk_koluncard_button_container);
        TextView negativeBtn = (TextView)view.findViewById(R.id.sdk_koluncard_negative_button);
        TextView neutralBtn = (TextView)view.findViewById(R.id.sdk_koluncard_neutral_button);
        TextView positiveBtn = (TextView)view.findViewById(R.id.sdk_koluncard_positive_button);
        View spacingView = view.findViewById(R.id.sdk_koluncard_spacing_view);
        this.setButtonTextColor(negativeBtn);
        this.setButtonTextColor(neutralBtn);
        this.setButtonTextColor(positiveBtn);
        if (layout2 != null) {
            separator.setVisibility(layout2.isInvisible() ? 8 : 0);
            buttonContainer.setVisibility(layout2.isInvisible() ? 8 : 0);
            negativeBtn.setVisibility(layout2.isNegativeInvisible() ? 8 : 0);
            neutralBtn.setVisibility(layout2.isNeutralInvisible() ? 8 : 0);
            positiveBtn.setVisibility(layout2.isPositiveInvisible() ? 8 : 0);
            spacingView.setVisibility(layout2.isInvisible() ? 0 : 8);
        }
    }

    protected void hideOperationViews(View view) {
        View separator = view.findViewById(R.id.sdk_koluncard_button_area_separator);
        LinearLayout buttonContainer = (LinearLayout)view.findViewById(R.id.sdk_koluncard_button_container);
        View spacingView = view.findViewById(R.id.sdk_koluncard_spacing_view);
        separator.setVisibility(8);
        buttonContainer.setVisibility(8);
        spacingView.setVisibility(8);
    }

    protected void onBindRefreshOperationViews(View view) {
        Context assistantContext = ResourceManager.getContextForResources(view.getContext(), PACKAGE_NAME_ASSISTANT);
        int resId = ResourceManager.getStringIdByName(assistantContext, TEXT_RETRY);
        String retryButtonText = "";
        retryButtonText = resId != 0 ? assistantContext.getResources().getString(ResourceManager.getStringIdByName(assistantContext, TEXT_RETRY)) : view.getContext().getString(R.string.sdk_koluncard_retry_button);
        ArrayList<String> buttonTitles = new ArrayList<String>(Arrays.asList("", retryButtonText, ""));
        CardAction refreshAction = new CardAction();
        refreshAction.setTrackingInfo(new CardTrackingInfo("retry_refresh_cl"));
        List<CardAction> buttonActions = Arrays.asList(null, refreshAction, null);
        this.onBindOperationViews(view, new CardOperation(buttonTitles, buttonActions), new CardOperationLyt(false, true, false, true));
    }

    protected void onBindSpecialStateViews(View view, SpecialState state, int cardViewHeight) {
        boolean specialState = false;
        int specialStateViewHeight = 0;
        if (state != SpecialState.SPECIAL_STATE_NONE) {
            specialState = true;
            BasicTextView textView = (BasicTextView)view.findViewById(R.id.sdk_koluncard_special_state_text_view);
            textView.setBasicTextColor(0);
            int contentResId = 0;
            String defaultText = "";
            Context resourceContext = ResourceManager.getContextForResources(view.getContext(), PACKAGE_NAME_ASSISTANT);
            switch (state) {
                case SPECIAL_STATE_DATA_LOADING: {
                    specialStateViewHeight = cardViewHeight - view.getContext().getResources().getDimensionPixelSize(R.dimen.dp_36);
                    view.findViewById(R.id.sdk_koluncard_loading_progress_bar).setVisibility(0);
                    contentResId = ResourceManager.getStringIdByName(resourceContext, TEXT_LOADING_STATE);
                    defaultText = view.getContext().getString(R.string.sdk_koluncard_loading_data_state);
                    this.hideOperationViews(view);
                    break;
                }
                case SPECIAL_STATE_NO_NETWORK: {
                    specialStateViewHeight = cardViewHeight - view.getContext().getResources().getDimensionPixelSize(R.dimen.dp_87);
                    view.findViewById(R.id.sdk_koluncard_loading_progress_bar).setVisibility(8);
                    contentResId = ResourceManager.getStringIdByName(resourceContext, TEXT_NO_NETWORK);
                    defaultText = view.getContext().getString(R.string.sdk_koluncard_no_network_state);
                    this.onBindRefreshOperationViews(view);
                    break;
                }
                case SPECIAL_STATE_LOADING_FAIL: {
                    specialStateViewHeight = cardViewHeight - view.getContext().getResources().getDimensionPixelSize(R.dimen.dp_87);
                    view.findViewById(R.id.sdk_koluncard_loading_progress_bar).setVisibility(8);
                    contentResId = ResourceManager.getStringIdByName(resourceContext, TEXT_LOADING_FAIL);
                    defaultText = view.getContext().getString(R.string.sdk_koluncard_loading_fail_state);
                    this.onBindRefreshOperationViews(view);
                    break;
                }
            }
            if (contentResId != 0) {
                textView.setText(resourceContext.getResources().getString(contentResId));
            } else {
                textView.setText(defaultText);
            }
        }
        this.setSpecialStateViewsVisibility(view, specialState, specialStateViewHeight);
    }

    protected void setSpecialStateViewsVisibility(View view, boolean specialState, int specialStateViewHeight) {
        View layoutView = view.findViewById(R.id.sdk_koluncard_special_state_layout);
        View reminder = view.findViewById(R.id.sdk_koluncard_reminder_text);
        View content = view.findViewById(R.id.sdk_koluncard_content_area);
        View brand = view.findViewById(R.id.sdk_koluncard_brand_text);
        if (reminder != null && specialState) {
            reminder.setVisibility(8);
        }
        if (content != null) {
            content.setVisibility(specialState ? 8 : 0);
        }
        if (brand != null && specialState) {
            brand.setVisibility(8);
        }
        if (layoutView != null) {
            layoutView.setMinimumHeight(specialStateViewHeight);
            layoutView.setVisibility(specialState ? 0 : 8);
        }
    }

    protected void onBindCommon(View view, TemplateData data, TemplateLyt layout2, SpecialState specialState, int viewHeight) {
        if (view == null || data == null || layout2 == null) {
            return;
        }
        this.addPopupMenus(view, data);
        this.onBindTitleViews(view, data.getCardTitle(), layout2.getCardTitleLyt());
        this.onBindSpecialStateViews(view, specialState, viewHeight);
        if (specialState == SpecialState.SPECIAL_STATE_NONE) {
            this.onBindReminderViews(view, data.getCardReminder(), layout2.getCardReminderLyt());
            this.onBindBrandViews(view, data.getCardBrand(), layout2.getCardBrandLyt());
            this.onBindOperationViews(view, data.getCardOperation(), layout2.getCardOperationLyt());
        }
    }

    protected void onBindCommon(View view, TemplateData data, SpecialState specialState, int viewHeight) {
        if (view == null || data == null) {
            return;
        }
        this.addPopupMenus(view, data);
        this.onBindTitleViews(view, data.getCardTitle());
        this.onBindSpecialStateViews(view, specialState, viewHeight);
        if (specialState == SpecialState.SPECIAL_STATE_NONE) {
            this.onBindReminderViews(view, data.getCardReminder());
            this.onBindBrandViews(view, data.getCardBrand());
            this.onBindOperationViews(view, data.getCardOperation());
        }
    }

    protected void onBindCommon(View view, TemplateLyt layout2, SpecialState specialState, int viewHeight) {
        if (view == null || layout2 == null) {
            return;
        }
        this.onBindTitleViews(view, layout2.getCardTitleLyt());
        this.onBindSpecialStateViews(view, specialState, viewHeight);
        if (specialState == SpecialState.SPECIAL_STATE_NONE) {
            this.onBindReminderViews(view, layout2.getCardReminderLyt());
            this.onBindBrandViews(view, layout2.getCardBrandLyt());
            this.onBindOperationViews(view, layout2.getCardOperationLyt());
        }
    }

    private void setButtonTextColor(TextView button) {
        if (button == null) {
            return;
        }
        button.setTextColor(UIUtils.getButtonTextColorStateList(button.getContext()));
    }

    private static class MenuAdapter
    extends ArrayAdapter {
        private final Context mContext;

        public MenuAdapter(@NonNull Context context, int resource, @NonNull List<String> objects) {
            super(context, resource, objects);
            this.mContext = context;
        }

        @NonNull
        public View getView(int position, @Nullable View convertView, @NonNull ViewGroup parent) {
            if (convertView == null) {
                convertView = LayoutInflater.from((Context)this.mContext).inflate(R.layout.sdk_koluncard_menu_item_layout, parent, false);
            }
            BasicTextView textView = (BasicTextView)convertView.findViewById(R.id.menu_item);
            if (CommonUtils.isBrandXos()) {
                textView.setTextColor(this.getContext().getColor(R.color.sdk_koluncard_xos_menu_text_color));
            } else {
                textView.setTextColor(this.getContext().getColor(R.color.sdk_koluncard_hios_menu_text_color));
            }
            return super.getView(position, convertView, parent);
        }
    }

    protected static class RenderContextWrapper
    extends ContextWrapper {
        private final Context mContextForResources;

        public RenderContextWrapper(Context context, Context contextForResources) {
            super(context);
            this.mContextForResources = contextForResources;
        }

        public Resources getResources() {
            return this.mContextForResources.getResources();
        }

        public Resources.Theme getTheme() {
            return this.mContextForResources.getTheme();
        }

        public String getPackageName() {
            return this.mContextForResources.getPackageName();
        }
    }

    public static class EngineModel<T extends CommonViewModel> {
        Queue<View> engineView = new ArrayDeque<View>(1);
        T engineViewModel;

        EngineModel() {
        }

        EngineModel(T engineViewModel, View view) {
            this.engineViewModel = engineViewModel;
            this.engineView.add(view);
        }

        public View getEngineView() {
            return this.engineView.poll();
        }

        public T getEngineViewModel() {
            return this.engineViewModel;
        }

        public void setEngineViewModel(T engineViewModel) {
            this.engineViewModel = engineViewModel;
        }
    }
}

