/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.kolun.cardtemplate.engine;

import android.util.ArrayMap;
import androidx.annotation.NonNull;
import com.transsion.kolun.cardtemplate.engine.BasicTemplateEngine;
import com.transsion.kolun.cardtemplate.engine.GroupImageIconEngine;
import com.transsion.kolun.cardtemplate.engine.GroupTextImageEngine;
import com.transsion.kolun.cardtemplate.engine.ListTemplateEngine;
import com.transsion.kolun.cardtemplate.engine.RenderEngine;
import java.util.Map;

public class RenderEngineManager {
    private static final Map<Integer, Class<? extends RenderEngine>> sSupportedEngineMap = new ArrayMap();

    public static RenderEngine createRenderEngine(@NonNull int engine) {
        Class<? extends RenderEngine> engineClass;
        if (engine != -1 && (engineClass = sSupportedEngineMap.get(engine)) != null) {
            try {
                return engineClass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
                // empty catch block
            }
        }
        return null;
    }

    static {
        sSupportedEngineMap.put(1000, BasicTemplateEngine.class);
        sSupportedEngineMap.put(1003, ListTemplateEngine.class);
        sSupportedEngineMap.put(1002, GroupTextImageEngine.class);
        sSupportedEngineMap.put(1001, GroupImageIconEngine.class);
    }
}

