/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.kolun.cardtemplate.engine;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import java.util.function.Function;

public class RenderThread
extends HandlerThread {
    private static final String TAG = RenderThread.class.getSimpleName();
    private static RenderThread sInstance = new RenderThread();
    private Handler mHandler;

    private RenderThread() {
        super(TAG, 5);
    }

    public static void execute(Function function, Object ... object) {
        if (!sInstance.isAlive()) {
            throw new IllegalStateException("RenderThread is not started");
        }
        sInstance.getThreadHandler().post(() -> function.apply(object));
    }

    public static RenderThread getInstance() {
        return sInstance;
    }

    public Looper getLooper() {
        if (!this.isAlive()) {
            this.start();
        }
        return super.getLooper();
    }

    public Handler getThreadHandler() {
        if (this.mHandler == null) {
            this.mHandler = new Handler(this.getLooper());
        }
        return this.mHandler;
    }
}

