/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.kolun.cardtemplate.engine;

import android.graphics.Bitmap;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.util.Log;
import android.view.View;
import android.view.ViewParent;
import android.widget.ImageView;
import com.transsion.kolun.cardtemplate.TemplateKolunCardManager;
import com.transsion.kolun.cardtemplate.bean.base.CardAction;
import com.transsion.kolun.cardtemplate.bean.base.CardBitmap;
import com.transsion.kolun.cardtemplate.customwidget.RoundCornerLinearLayout;
import com.transsion.kolun.cardtemplate.customwidget.RoundCornerRelativeLayout;
import com.transsion.kolun.cardtemplate.utils.TrackingHelper;
import com.transsion.kolun.cardtemplate.utils.UIUtils;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class RenderThreadHelper {
    private static final String TAG = "RenderThreadHelper";
    public static final String TAG_PACKAGE_NAME = "packageName";
    public static final String TAG_CARD_ID = "card_id";
    private static volatile RenderThreadHelper sInstance;
    private volatile Handler mCardWorkHandler;
    private volatile Handler mMainHandler;
    private volatile ThreadPoolExecutor mWorkThreadPool;

    private RenderThreadHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void init() {
        if (sInstance != null) return;
        Class<RenderThreadHelper> clazz = RenderThreadHelper.class;
        synchronized (RenderThreadHelper.class) {
            if (sInstance != null) return;
            sInstance = new RenderThreadHelper();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static void setRemoteImage(CardBitmap cardBitmap, ImageView imageView) {
        if (cardBitmap == null || imageView == null) {
            return;
        }
        RenderThreadHelper.getWorkThreadPool().execute(() -> {
            Bitmap bitmap = UIUtils.getBitmap(cardBitmap, imageView.getContext(), RenderThreadHelper.getAppPackageFromView((View)imageView));
            if (bitmap == null) {
                Log.d((String)"Bitmap", (String)"null");
            } else {
                Log.d((String)"Bitmap", (String)"not null");
                RenderThreadHelper.getMainHandler().post(() -> imageView.setImageBitmap(bitmap));
            }
        });
    }

    public static void sendActionAndTracking(View view, CardAction cardAction, String trackingEvent, int position) {
        if (cardAction == null) {
            return;
        }
        RenderThreadHelper.getWorkHandler().post(() -> {
            TrackingHelper.setTrackingInfo(cardAction, RenderThreadHelper.getCardIdFromView(view), trackingEvent, position);
            TemplateKolunCardManager.getInstance(view.getContext()).getCardActionManager().executeCardAction(cardAction);
        });
    }

    public static void sendActionAndTracking(View view, CardAction cardAction, int position) {
        if (cardAction == null) {
            return;
        }
        RenderThreadHelper.getWorkHandler().post(() -> {
            TrackingHelper.setTrackingInfo(cardAction, RenderThreadHelper.getCardIdFromView(view), position);
            TemplateKolunCardManager.getInstance(view.getContext()).getCardActionManager().executeCardAction(cardAction);
        });
    }

    public static void sendActionAndTracking(View view, CardAction cardAction, String trackingEvent) {
        if (cardAction == null) {
            return;
        }
        RenderThreadHelper.getWorkHandler().post(() -> {
            TrackingHelper.setTrackingInfo(cardAction, RenderThreadHelper.getCardIdFromView(view), trackingEvent);
            TemplateKolunCardManager.getInstance(view.getContext()).getCardActionManager().executeCardAction(cardAction);
        });
    }

    public static void sendActionAndTracking(View view, CardAction cardAction) {
        if (cardAction == null) {
            return;
        }
        RenderThreadHelper.getWorkHandler().post(() -> {
            TrackingHelper.setTrackingInfo(cardAction, RenderThreadHelper.getCardIdFromView(view));
            TemplateKolunCardManager.getInstance(view.getContext()).getCardActionManager().executeCardAction(cardAction);
        });
    }

    public static void sendActionAndTracking(View view, CardAction cardAction, String trackingEvent, String switchState) {
        if (cardAction == null) {
            return;
        }
        RenderThreadHelper.getWorkHandler().post(() -> {
            TrackingHelper.setTrackingInfo(cardAction, RenderThreadHelper.getCardIdFromView(view), trackingEvent, switchState);
            TemplateKolunCardManager.getInstance(view.getContext()).getCardActionManager().executeCardAction(cardAction);
        });
    }

    public static void sendTracking(View view, String trackingEvent) {
        if (trackingEvent == null) {
            return;
        }
        RenderThreadHelper.getWorkHandler().post(() -> {
            String cardId = RenderThreadHelper.getCardIdFromView(view);
            TemplateKolunCardManager.getInstance(view.getContext()).getCardActionManager().sendTrackingInfo(cardId, trackingEvent);
        });
    }

    public static String getCardIdFromView(View view) {
        Object tag = view.getTag(TAG_CARD_ID.hashCode());
        if (tag == null) {
            for (ViewParent parent = view.getParent(); !(parent == null || (parent instanceof RoundCornerRelativeLayout || parent instanceof RoundCornerLinearLayout) && RenderThreadHelper.setViewCardIdTag(view, parent, TAG_CARD_ID.hashCode())); parent = parent.getParent()) {
            }
        }
        String id2 = String.valueOf(view.getTag(TAG_CARD_ID.hashCode()));
        Log.d((String)TAG, (String)("getCardIdFromView\uff1a " + id2));
        return id2;
    }

    public static String getAppPackageFromView(View imageView) {
        Object tag = imageView.getTag(TAG_PACKAGE_NAME.hashCode());
        if (tag == null) {
            for (ViewParent parent = imageView.getParent(); !(parent == null || (parent instanceof RoundCornerRelativeLayout || parent instanceof RoundCornerLinearLayout) && RenderThreadHelper.setViewPackageTag(imageView, parent, TAG_PACKAGE_NAME.hashCode())); parent = parent.getParent()) {
            }
        }
        String packageName = String.valueOf(imageView.getTag(TAG_PACKAGE_NAME.hashCode()));
        Log.d((String)TAG, (String)("getAppPackageFromView: " + packageName));
        return packageName;
    }

    private static boolean setViewPackageTag(View view, ViewParent parent, int tag) {
        boolean result = false;
        if (parent instanceof RoundCornerRelativeLayout && ((RoundCornerRelativeLayout)parent).getAppPackage() != null) {
            view.setTag(tag, (Object)((RoundCornerRelativeLayout)parent).getAppPackage());
            result = true;
        }
        if (parent instanceof RoundCornerLinearLayout && ((RoundCornerLinearLayout)parent).getAppPackage() != null) {
            view.setTag(tag, (Object)((RoundCornerLinearLayout)parent).getAppPackage());
            result = true;
        }
        return result;
    }

    private static boolean setViewCardIdTag(View view, ViewParent parent, int tag) {
        boolean result = false;
        if (parent instanceof RoundCornerRelativeLayout && ((RoundCornerRelativeLayout)parent).getCardId() != null) {
            view.setTag(tag, (Object)((RoundCornerRelativeLayout)parent).getCardId());
            result = true;
        }
        if (parent instanceof RoundCornerLinearLayout && ((RoundCornerLinearLayout)parent).getCardId() != null) {
            view.setTag(tag, (Object)((RoundCornerLinearLayout)parent).getCardId());
            result = true;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Handler getCardWorkHandler() {
        if (this.mCardWorkHandler != null) return this.mCardWorkHandler;
        Class<RenderThreadHelper> clazz = RenderThreadHelper.class;
        synchronized (RenderThreadHelper.class) {
            if (this.mCardWorkHandler != null) return this.mCardWorkHandler;
            HandlerThread handlerThread = new HandlerThread("card_background_work", 10);
            handlerThread.start();
            this.mCardWorkHandler = new Handler(handlerThread.getLooper());
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.mCardWorkHandler;
        }
    }

    public static Handler getWorkHandler() {
        RenderThreadHelper.init();
        return sInstance.getCardWorkHandler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Handler getMainHandler() {
        RenderThreadHelper.init();
        if (RenderThreadHelper.sInstance.mMainHandler != null) return RenderThreadHelper.sInstance.mMainHandler;
        Class<RenderThreadHelper> clazz = RenderThreadHelper.class;
        synchronized (RenderThreadHelper.class) {
            if (RenderThreadHelper.sInstance.mMainHandler != null) return RenderThreadHelper.sInstance.mMainHandler;
            RenderThreadHelper.sInstance.mMainHandler = new Handler(Looper.getMainLooper());
            // ** MonitorExit[var0] (shouldn't be in output)
            return RenderThreadHelper.sInstance.mMainHandler;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ThreadPoolExecutor getWorkThreadPool() {
        RenderThreadHelper.init();
        if (RenderThreadHelper.sInstance.mWorkThreadPool != null) return RenderThreadHelper.sInstance.mWorkThreadPool;
        Class<RenderThreadHelper> clazz = RenderThreadHelper.class;
        synchronized (RenderThreadHelper.class) {
            if (RenderThreadHelper.sInstance.mWorkThreadPool != null) return RenderThreadHelper.sInstance.mWorkThreadPool;
            RenderThreadHelper.sInstance.mWorkThreadPool = new ThreadPoolExecutor(3, 5, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
            // ** MonitorExit[var0] (shouldn't be in output)
            return RenderThreadHelper.sInstance.mWorkThreadPool;
        }
    }
}

