/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.kolun.cardtemplate.engine.resource;

import android.content.Context;
import android.content.pm.PackageManager;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;

public class ResourceManager {
    private static final String TAG = "ResourceManager";
    private static final String PACKAGE_RESOURCE_PREFIX = "@";
    private static final String WEB_RESOURCE_PREFIX = "http";

    public static Context getContextForResources(@NonNull Context context, @NonNull String resourcePackageName) {
        if (TextUtils.isEmpty((CharSequence)resourcePackageName)) {
            Log.d((String)TAG, (String)"getContextForResources, resource package name is empty");
            return context;
        }
        if (context.getPackageName().equals(resourcePackageName)) {
            Log.d((String)TAG, (String)("getContextForResources, resource package is client " + resourcePackageName));
            return context;
        }
        try {
            return context.createPackageContext(resourcePackageName, 4);
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.e((String)TAG, (String)("getContextForResources " + resourcePackageName + " not found"));
            return context;
        }
    }

    public static int getLayoutIdByName(@NonNull Context context, @NonNull String name) {
        return ResourceManager.getIdByName(context, "layout", name);
    }

    public static int getDrawableIdByName(@NonNull Context context, @NonNull String name) {
        return ResourceManager.getIdByName(context, "drawable", name);
    }

    public static int getMipmapIdByName(@NonNull Context context, @NonNull String name) {
        return ResourceManager.getIdByName(context, "mipmap", name);
    }

    public static int getStringIdByName(@NonNull Context context, @NonNull String name) {
        return ResourceManager.getIdByName(context, "string", name);
    }

    public static int getResourceByName(@NonNull Context context, @NonNull String name, String prefixes) {
        return ResourceManager.getIdByName(context, prefixes, name);
    }

    private static int getIdByName(@NonNull Context context, @NonNull String className, @NonNull String name) {
        return context.getResources().getIdentifier(name, className, context.getPackageName());
    }

    public static interface Callback {
        public void onImageLoaded(String var1, Drawable var2);
    }
}

