/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.kolun.cardtemplate.engine.template;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.Shape;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.transsion.kolun.cardtemplate.R;

public class SpacingItemDecoration
extends RecyclerView.ItemDecoration {
    private float dividerHeight;
    private final int mSpacing;
    private final Context mContext;
    private int mOrientation = 1;
    private final boolean mHasDivider;

    public SpacingItemDecoration(Context context, int spacing, boolean hasDivider) {
        this.mSpacing = spacing;
        this.mContext = context;
        this.mHasDivider = hasDivider;
        this.dividerHeight = context.getResources().getDimension(R.dimen.dp_1);
    }

    private Drawable drawDivider(Context context, final float width) {
        ShapeDrawable drawable2 = new ShapeDrawable(new Shape(){

            @SuppressLint(value={"ResourceAsColor"})
            public void draw(Canvas canvas, Paint paint) {
                paint.setColor(SpacingItemDecoration.this.mContext.getColor(R.color.sdk_koluncard_separator_color));
                canvas.drawLine(0.0f, 0.0f, width, SpacingItemDecoration.this.dividerHeight, paint);
            }
        });
        return drawable2;
    }

    public void onDraw(Canvas c, RecyclerView parent, RecyclerView.State state) {
        if (this.mHasDivider) {
            this.drawWithDivider(c, parent);
        }
    }

    public void getItemOffsets(@NonNull Rect outRect, @NonNull View view, @NonNull RecyclerView parent, @NonNull RecyclerView.State state) {
        int position = parent.getChildAdapterPosition(view);
        int itemCount = parent.getAdapter().getItemCount();
        if (position == 0) {
            outRect.top = 0;
            outRect.bottom = (int)((float)(this.mSpacing / 2) + this.dividerHeight);
        } else if (position == itemCount - 1) {
            outRect.bottom = 0;
            outRect.top = this.mSpacing / 2;
        } else {
            outRect.bottom = (int)((float)(this.mSpacing / 2) + this.dividerHeight);
            outRect.top = this.mSpacing / 2;
        }
    }

    private void drawWithDivider(Canvas c, RecyclerView parent) {
        int left = parent.getPaddingLeft();
        int right = parent.getWidth() - parent.getPaddingRight();
        int childCount = parent.getChildCount();
        for (int i = 0; i < childCount - 1; ++i) {
            View child = parent.getChildAt(i);
            RecyclerView.LayoutParams params = (RecyclerView.LayoutParams)child.getLayoutParams();
            Drawable divider = this.drawDivider(this.mContext, child.getWidth());
            int top = child.getBottom() + params.bottomMargin + this.mSpacing / 2;
            int bottom = top + divider.getIntrinsicHeight() + this.mSpacing;
            divider.setBounds(left, top, right, bottom);
            divider.draw(c);
        }
    }
}

