/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.kolun.cardtemplate.engine.template;

import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.transsion.kolun.cardtemplate.R;

public class TemplateUtils {
    private static final String TAG = "TemplateUtils";

    public static void setMainInfoPosition(View view, boolean isDefaultOrder, boolean isDigitalType, boolean isSecondaryInfoVisible) {
        TemplateUtils.changeMainInfoToFirstPlace(view, isDefaultOrder, isDigitalType);
        TemplateUtils.changeMainInfoToSecondPlace(view, isDefaultOrder, isSecondaryInfoVisible);
    }

    public static void changeMainInfoToSecondPlace(View view, boolean isDefaultOrder, boolean isSecondaryInfoVisible) {
        if (!isDefaultOrder) {
            RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)view.getLayoutParams();
            layoutParams.removeRule(10);
            layoutParams.addRule(3, R.id.sdk_koluncard_primary_info_text_layout);
            layoutParams.bottomMargin = isSecondaryInfoVisible ? view.getContext().getResources().getDimensionPixelSize(R.dimen.dp_6) : 0;
            view.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        }
    }

    public static void changeMainInfoToFirstPlace(View view, boolean isDefaultOrder, boolean isDigitalType) {
        if (isDefaultOrder) {
            RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)view.getLayoutParams();
            layoutParams.removeRule(3);
            layoutParams.addRule(10);
            layoutParams.bottomMargin = isDigitalType ? view.getContext().getResources().getDimensionPixelSize(R.dimen.dp_4) : view.getContext().getResources().getDimensionPixelSize(R.dimen.dp_6);
            view.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        }
    }

    public static void setPrimaryInfoPosition(View view, boolean isDefaultOrder, boolean isShowingDigitalMainInfo, boolean isSecondaryInfoVisible) {
        TemplateUtils.changePrimaryInfoToFirstPlace(view, isDefaultOrder);
        TemplateUtils.changePrimaryInfoToSecondPlace(view, isDefaultOrder, isShowingDigitalMainInfo, isSecondaryInfoVisible);
    }

    public static void changePrimaryInfoToFirstPlace(View view, boolean isDefaultOrder) {
        if (!isDefaultOrder) {
            RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)view.getLayoutParams();
            layoutParams.removeRule(3);
            Log.d((String)"Position", (String)"change primary");
            layoutParams.addRule(10);
            layoutParams.setMargins(0, 0, 0, 0);
            view.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        }
    }

    public static void changePrimaryInfoToSecondPlace(View view, boolean isDefaultOrder, boolean isShowingDigitalMainInfo, boolean isSecondaryInfoVisible) {
        if (isDefaultOrder) {
            RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)view.getLayoutParams();
            layoutParams.removeRule(10);
            if (isShowingDigitalMainInfo) {
                layoutParams.addRule(3, R.id.sdk_koluncard_main_info_layout);
            } else {
                layoutParams.addRule(3, R.id.sdk_koluncard_text_main_info_view);
            }
            layoutParams.bottomMargin = isSecondaryInfoVisible ? view.getContext().getResources().getDimensionPixelSize(R.dimen.dp_2) : 0;
            view.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        }
    }

    public static void changeSecondaryInfoPlace(View view, boolean isDefaultOrder, boolean isShowingDigitalMainInfo) {
        if (!isDefaultOrder) {
            RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)view.getLayoutParams();
            layoutParams.removeRule(3);
            if (isShowingDigitalMainInfo) {
                layoutParams.addRule(3, R.id.sdk_koluncard_main_info_layout);
            } else {
                layoutParams.addRule(3, R.id.sdk_koluncard_text_main_info_view);
            }
            view.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        }
    }

    public static void scaleImage(View view, int scale) {
        ViewGroup.LayoutParams layoutParams = view.getLayoutParams();
        switch (scale) {
            case 17: {
                layoutParams.width = (int)view.getResources().getDimension(R.dimen.dp_56);
                layoutParams.height = (int)view.getResources().getDimension(R.dimen.dp_56);
                break;
            }
            case 249: {
                layoutParams.width = (int)view.getResources().getDimension(R.dimen.dp_80);
                layoutParams.height = (int)view.getResources().getDimension(R.dimen.dp_45);
                break;
            }
            case 50: {
                layoutParams.width = (int)view.getResources().getDimension(R.dimen.dp_70);
                layoutParams.height = (int)view.getResources().getDimension(R.dimen.dp_47);
                break;
            }
            case 104: {
                layoutParams.width = (int)view.getResources().getDimension(R.dimen.dp_48);
                layoutParams.height = (int)view.getResources().getDimension(R.dimen.dp_64);
                break;
            }
            default: {
                layoutParams.width = (int)view.getResources().getDimension(R.dimen.dp_56);
                layoutParams.height = (int)view.getResources().getDimension(R.dimen.dp_56);
            }
        }
        view.setLayoutParams(layoutParams);
        view.requestLayout();
    }

    public static void setIconSize(View view, boolean isGeneralIcon) {
        ViewGroup.LayoutParams layoutParams = view.getLayoutParams();
        if (isGeneralIcon) {
            layoutParams.width = (int)view.getResources().getDimension(R.dimen.dp_24);
            layoutParams.height = (int)view.getResources().getDimension(R.dimen.dp_24);
        } else {
            layoutParams.width = (int)view.getResources().getDimension(R.dimen.dp_40);
            layoutParams.height = (int)view.getResources().getDimension(R.dimen.dp_40);
        }
        view.setLayoutParams(layoutParams);
    }
}

