/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.kolun.cardtemplate.engine.view.basictext;

import android.annotation.SuppressLint;
import android.view.View;
import com.transsion.kolun.cardtemplate.R;
import com.transsion.kolun.cardtemplate.bean.content.basictext.BasicTextContent;
import com.transsion.kolun.cardtemplate.bean.content.basictext.MainInfo;
import com.transsion.kolun.cardtemplate.bean.content.basictext.PrimaryInfo;
import com.transsion.kolun.cardtemplate.bean.content.basictext.SecondaryInfo;
import com.transsion.kolun.cardtemplate.customwidget.BasicTextView;
import com.transsion.kolun.cardtemplate.engine.RenderThreadHelper;
import com.transsion.kolun.cardtemplate.engine.template.TemplateUtils;
import com.transsion.kolun.cardtemplate.engine.view.basictext.MainInfoViewGroup;
import com.transsion.kolun.cardtemplate.engine.view.basictext.PrimaryInfoViewGroup;
import com.transsion.kolun.cardtemplate.layout.content.basictext.BasicTextContentLyt;
import com.transsion.kolun.cardtemplate.layout.content.basictext.MainInfoLyt;
import com.transsion.kolun.cardtemplate.layout.content.basictext.PrimaryInfoLyt;
import com.transsion.kolun.cardtemplate.layout.content.basictext.SecondaryInfoLyt;

public class BasicTextViewGroup {
    protected View mContentView;
    MainInfoViewGroup mMainInfoViewGroup;
    PrimaryInfoViewGroup mPrimaryInfoViewGroup;
    BasicTextView mSecondaryInfoTextView;

    public BasicTextViewGroup(View view) {
        this.mContentView = view;
        this.mMainInfoViewGroup = new MainInfoViewGroup(view);
        this.mPrimaryInfoViewGroup = new PrimaryInfoViewGroup(view);
        this.mSecondaryInfoTextView = (BasicTextView)view.findViewById(R.id.sdk_koluncard_secondary_info_text_view);
    }

    public void onBindViews(BasicTextContent content, BasicTextContentLyt layout2, Boolean hasContentClickAction) {
        this.onBindViews(layout2);
        this.onBindViews(content, hasContentClickAction);
    }

    public void onBindViews(BasicTextContent content, BasicTextContentLyt layout2, int position) {
        this.onBindViews(layout2);
        this.onBindViews(content, false);
        this.setListContentClickAction(content, position);
    }

    public void onBindViews(BasicTextContent content, boolean hasContentClickAction) {
        this.onBindContentViews(content);
        if (hasContentClickAction) {
            this.setContentClickAction(content);
        }
    }

    @SuppressLint(value={"WrongConstant"})
    private void onBindContentViews(BasicTextContent content) {
        if (content != null) {
            MainInfo mainInfo = content.getMainInfo();
            PrimaryInfo primaryInfo = content.getPrimaryInfo();
            SecondaryInfo secondaryInfo = content.getSecondaryInfo();
            if (mainInfo != null) {
                this.mMainInfoViewGroup.onBindViews(content.getMainInfo());
            }
            if (primaryInfo != null) {
                this.mPrimaryInfoViewGroup.onBindViews(content.getPrimaryInfo());
            }
            if (secondaryInfo != null) {
                this.mSecondaryInfoTextView.setText(secondaryInfo.getContent());
                this.mSecondaryInfoTextView.setBasicTextColor(secondaryInfo.getTextColor(), 2);
            }
        }
    }

    private void setListContentClickAction(BasicTextContent content, int position) {
        if (this.mContentView != null && content != null) {
            this.mContentView.setOnClickListener(v -> RenderThreadHelper.sendActionAndTracking(this.mContentView, content.getContentAction(), "list_card_hot_zone", position));
        }
    }

    private void setContentClickAction(BasicTextContent content) {
        if (this.mContentView != null && content != null) {
            this.mContentView.setOnClickListener(v -> RenderThreadHelper.sendActionAndTracking(this.mContentView, content.getContentAction(), "content_area_hot_area_cl"));
        }
    }

    @SuppressLint(value={"WrongConstant"})
    public void onBindViews(BasicTextContentLyt layout2) {
        if (layout2 != null) {
            MainInfoLyt mainInfoLyt = layout2.getMainInfoLyt();
            PrimaryInfoLyt primaryInfoLyt = layout2.getPrimaryInfoLyt();
            SecondaryInfoLyt secondaryInfoLyt = layout2.getSecondaryInfoLyt();
            if (mainInfoLyt != null) {
                this.mMainInfoViewGroup.onBindViews(mainInfoLyt);
            }
            if (primaryInfoLyt != null) {
                this.mPrimaryInfoViewGroup.onBindViews(primaryInfoLyt);
            }
            boolean isSecondaryInfoVisible = false;
            if (secondaryInfoLyt != null) {
                this.mSecondaryInfoTextView.setVisibility(secondaryInfoLyt.isInvisible() ? 8 : 0);
                this.mSecondaryInfoTextView.setMaxLines(secondaryInfoLyt.getLines());
                isSecondaryInfoVisible = !secondaryInfoLyt.isInvisible();
            }
            this.configureViewPosition(mainInfoLyt, primaryInfoLyt, isSecondaryInfoVisible);
        }
    }

    private void configureViewPosition(MainInfoLyt mainInfoLyt, PrimaryInfoLyt primaryInfoLyt, boolean isSecondaryInfoVisible) {
        if (mainInfoLyt == null || primaryInfoLyt == null) {
            return;
        }
        if (mainInfoLyt.isDigitalType()) {
            TemplateUtils.setMainInfoPosition((View)this.mMainInfoViewGroup.getDigitalMainInfoLayout(), primaryInfoLyt.isDefaultOrder(), mainInfoLyt.isDigitalType(), isSecondaryInfoVisible);
        } else {
            TemplateUtils.setMainInfoPosition((View)this.mMainInfoViewGroup.getTextMainInfoTextView(), primaryInfoLyt.isDefaultOrder(), mainInfoLyt.isDigitalType(), isSecondaryInfoVisible);
        }
        TemplateUtils.setPrimaryInfoPosition((View)this.mPrimaryInfoViewGroup.getPrimaryInfoLayout(), primaryInfoLyt.isDefaultOrder(), mainInfoLyt.isDigitalType(), isSecondaryInfoVisible);
        TemplateUtils.changeSecondaryInfoPlace((View)this.mSecondaryInfoTextView, primaryInfoLyt.isDefaultOrder(), mainInfoLyt.isDigitalType());
    }
}

