/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.kolun.cardtemplate.engine.view.basictext;

import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import com.transsion.kolun.cardtemplate.R;
import com.transsion.kolun.cardtemplate.bean.content.basictext.PrimaryInfo;
import com.transsion.kolun.cardtemplate.customwidget.BasicTextView;
import com.transsion.kolun.cardtemplate.customwidget.CustomLabelView;
import com.transsion.kolun.cardtemplate.engine.RenderThreadHelper;
import com.transsion.kolun.cardtemplate.layout.content.basictext.PrimaryInfoLyt;

public class PrimaryInfoViewGroup {
    LinearLayout mPrimaryInfoLayout;
    BasicTextView mPrimaryInfoTextView;
    CustomLabelView mPrimaryInfoTextLabel;
    ImageView mPrimaryInfoImageLabel;

    public PrimaryInfoViewGroup(View view) {
        this.mPrimaryInfoLayout = (LinearLayout)view.findViewById(R.id.sdk_koluncard_primary_info_text_layout);
        this.mPrimaryInfoTextView = (BasicTextView)view.findViewById(R.id.sdk_koluncard_primary_info_text_view);
        this.mPrimaryInfoTextLabel = (CustomLabelView)view.findViewById(R.id.sdk_koluncard_primary_info_text_label);
        this.mPrimaryInfoImageLabel = (ImageView)view.findViewById(R.id.sdk_koluncard_primary_info_image_label);
    }

    public void onBindViews(PrimaryInfo content, PrimaryInfoLyt layout2) {
        this.onBindViews(layout2);
        this.onBindViews(content);
    }

    public void onBindViews(PrimaryInfo content) {
        if (content == null) {
            return;
        }
        this.mPrimaryInfoTextView.setText(content.getContent());
        this.mPrimaryInfoTextView.setBasicTextColor(content.getTextColor(), 0);
        if (content.getTextLabel() != null) {
            this.mPrimaryInfoTextLabel.setText(content.getTextLabel().getLabelText());
            this.mPrimaryInfoTextLabel.setTextColor(content.getTextLabel().getLabelColor());
            this.mPrimaryInfoTextLabel.setBackgroundColor(content.getTextLabel().getBackgroundColor());
        }
        if (content.getBitmapLabel() != null && this.mPrimaryInfoImageLabel.getVisibility() == 0) {
            RenderThreadHelper.setRemoteImage(content.getBitmapLabel(), this.mPrimaryInfoImageLabel);
        }
    }

    public void onBindViews(PrimaryInfoLyt layout2) {
        if (layout2 == null) {
            return;
        }
        this.mPrimaryInfoLayout.setVisibility(layout2.isInvisible() ? 8 : 0);
        this.mPrimaryInfoTextLabel.setVisibility(layout2.isTextLabelInvisible() ? 8 : 0);
        this.mPrimaryInfoImageLabel.setVisibility(layout2.isImageLabelInvisible() ? 8 : 0);
        this.mPrimaryInfoTextView.setMaxLines(layout2.getLines());
    }

    public LinearLayout getPrimaryInfoLayout() {
        return this.mPrimaryInfoLayout;
    }
}

