/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.kolun.cardtemplate.engine.view.icongrid;

import android.view.View;
import android.widget.ImageView;
import com.transsion.kolun.cardtemplate.R;
import com.transsion.kolun.cardtemplate.bean.content.basictext.SecondaryInfo;
import com.transsion.kolun.cardtemplate.bean.content.icongrid.IconGrid;
import com.transsion.kolun.cardtemplate.customwidget.BasicTextView;
import com.transsion.kolun.cardtemplate.engine.RenderThreadHelper;
import com.transsion.kolun.cardtemplate.engine.template.TemplateUtils;
import com.transsion.kolun.cardtemplate.layout.content.basictext.SecondaryInfoLyt;
import com.transsion.kolun.cardtemplate.layout.content.icongrid.IconGridLyt;

public class IconGridItemViews {
    BasicTextView secondaryInfoU;
    BasicTextView secondaryInfoD;
    ImageView mIconView;
    View mParentView;

    public IconGridItemViews(View view) {
        this.mParentView = view;
        this.secondaryInfoU = (BasicTextView)view.findViewById(R.id.sdk_koluncard_icon_grid_secondary_info_u);
        this.secondaryInfoD = (BasicTextView)view.findViewById(R.id.sdk_koluncard_icon_grid_secondary_info_d);
        this.mIconView = (ImageView)view.findViewById(R.id.sdk_koluncard_icon_grid_image_view);
    }

    public void onBindViews(IconGrid content, IconGridLyt layout2, int position) {
        this.onBindViews(layout2);
        this.onBindViews(content, position);
    }

    public void onBindViews(IconGrid content, int position) {
        if (content != null) {
            SecondaryInfo downContent;
            SecondaryInfo upContent;
            if (this.mParentView != null) {
                this.mParentView.setOnClickListener(v -> RenderThreadHelper.sendActionAndTracking(this.mParentView, content.getAction(), "Icon_hot_zone", position));
            }
            if ((upContent = content.getSecondaryInfoU()) != null) {
                this.secondaryInfoU.setText(upContent.getContent());
                this.secondaryInfoU.setBasicTextColor(upContent.getTextColor(), 2);
            }
            if ((downContent = content.getSecondaryInfoD()) != null) {
                this.secondaryInfoD.setText(downContent.getContent());
                this.secondaryInfoD.setBasicTextColor(downContent.getTextColor(), 2);
            }
            if (content.getIcon() != null && this.mIconView.getVisibility() == 0) {
                RenderThreadHelper.setRemoteImage(content.getIcon(), this.mIconView);
            }
        }
    }

    public void onBindViews(IconGridLyt layout2) {
        if (layout2 != null) {
            SecondaryInfoLyt upLayout = layout2.getSecondaryInfoLytU();
            SecondaryInfoLyt downLayout = layout2.getSecondaryInfoLytD();
            if (upLayout != null) {
                this.secondaryInfoU.setVisibility(layout2.getSecondaryInfoLytU().isInvisible() ? 8 : 0);
            }
            if (downLayout != null) {
                this.secondaryInfoD.setVisibility(layout2.getSecondaryInfoLytD().isInvisible() ? 8 : 0);
            }
            this.mIconView.setVisibility(layout2.isIconInvisible() ? 8 : 0);
            TemplateUtils.setIconSize((View)this.mIconView, layout2.isGeneralIcon());
        } else {
            this.secondaryInfoD.setVisibility(8);
            this.secondaryInfoU.setVisibility(8);
            this.mIconView.setVisibility(8);
        }
    }
}

