/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.kolun.cardtemplate.engine.view.icongrid;

import android.annotation.SuppressLint;
import android.view.View;
import com.transsion.kolun.cardtemplate.R;
import com.transsion.kolun.cardtemplate.bean.content.icongrid.CardContentTypeIconGrid;
import com.transsion.kolun.cardtemplate.bean.content.icongrid.IconGrid;
import com.transsion.kolun.cardtemplate.engine.view.basictext.PrimaryInfoViewGroup;
import com.transsion.kolun.cardtemplate.engine.view.icongrid.IconGridItemViews;
import com.transsion.kolun.cardtemplate.layout.content.icongrid.CardIconGridLyt;
import com.transsion.kolun.cardtemplate.layout.content.icongrid.IconGridLyt;
import java.util.Arrays;
import java.util.List;

public class IconGridViewGroup {
    PrimaryInfoViewGroup primaryInfoViewGroup;
    List<IconGridItemViews> mItemList;
    List<View> mSpacingViews;
    private static final int MAX_SIZE = 5;

    public IconGridViewGroup(View view) {
        this.primaryInfoViewGroup = new PrimaryInfoViewGroup(view);
        IconGridItemViews itemViewOne = new IconGridItemViews(view.findViewById(R.id.sdk_koluncard_icon_grid_one));
        IconGridItemViews itemViewTwo = new IconGridItemViews(view.findViewById(R.id.sdk_koluncard_icon_grid_two));
        IconGridItemViews itemViewThree = new IconGridItemViews(view.findViewById(R.id.sdk_koluncard_icon_grid_three));
        IconGridItemViews itemViewFour = new IconGridItemViews(view.findViewById(R.id.sdk_koluncard_icon_grid_four));
        IconGridItemViews itemViewFive = new IconGridItemViews(view.findViewById(R.id.sdk_koluncard_icon_grid_five));
        this.mItemList = Arrays.asList(itemViewOne, itemViewTwo, itemViewThree, itemViewFour, itemViewFive);
        View spacingViewOne = view.findViewById(R.id.sdk_koluncard_icon_grid_space_one);
        View spacingViewTwo = view.findViewById(R.id.sdk_koluncard_icon_grid_space_two);
        View spacingViewThree = view.findViewById(R.id.sdk_koluncard_icon_grid_space_three);
        View spacingViewFour = view.findViewById(R.id.sdk_koluncard_icon_grid_space_four);
        this.mSpacingViews = Arrays.asList(spacingViewOne, spacingViewTwo, spacingViewThree, spacingViewFour);
    }

    @SuppressLint(value={"WrongConstant"})
    public void onBindViews(CardContentTypeIconGrid content, CardIconGridLyt layout2) {
        this.onBindViewsLayouts(layout2);
        this.onBindViews(content);
    }

    @SuppressLint(value={"WrongConstant"})
    public void onBindViews(CardContentTypeIconGrid content) {
        if (content != null) {
            if (content.getPrimaryInfo() != null) {
                this.primaryInfoViewGroup.onBindViews(content.getPrimaryInfo());
            }
            List contentList = content.getIconGrids();
            this.onBindViewsContents(contentList);
        }
    }

    @SuppressLint(value={"WrongConstant"})
    public void onBindViewsLayouts(CardIconGridLyt layout2) {
        if (layout2 != null) {
            List layoutList = layout2.getIconGridLyts();
            this.onBindViewsLayouts(layoutList);
        }
    }

    public void onBindViews(List<IconGrid> contentList, List<IconGridLyt> layoutList) {
        for (int i = 0; i < 5; ++i) {
            IconGridItemViews itemView = this.mItemList.get(i);
            if (contentList != null && layoutList != null && i < contentList.size() && i < layoutList.size()) {
                itemView.onBindViews(contentList.get(i), layoutList.get(i), i);
                if (i < 1) continue;
                this.mSpacingViews.get(i - 1).setVisibility(0);
                continue;
            }
            itemView.mParentView.setVisibility(8);
        }
    }

    public void onBindViewsContents(List<IconGrid> contentList) {
        for (int i = 0; i < 5; ++i) {
            IconGridItemViews itemView = this.mItemList.get(i);
            if (contentList == null || i >= contentList.size()) continue;
            itemView.onBindViews(contentList.get(i), i);
        }
    }

    public void onBindViewsLayouts(List<IconGridLyt> layoutList) {
        int maxSize = 5;
        for (int i = 0; i < maxSize; ++i) {
            IconGridItemViews itemView = this.mItemList.get(i);
            if (layoutList != null && i < layoutList.size()) {
                itemView.onBindViews(layoutList.get(i));
                if (i < 1) continue;
                this.mSpacingViews.get(i - 1).setVisibility(0);
                continue;
            }
            itemView.mParentView.setVisibility(8);
        }
    }
}

