/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.kolun.cardtemplate.engine.view.imagegrid;

import android.content.Context;
import android.view.View;
import com.transsion.kolun.cardtemplate.R;
import com.transsion.kolun.cardtemplate.bean.content.basictext.SecondaryInfo;
import com.transsion.kolun.cardtemplate.bean.content.imagegrid.ImageGrid;
import com.transsion.kolun.cardtemplate.customwidget.BasicTextView;
import com.transsion.kolun.cardtemplate.customwidget.CustomLinearLayout;
import com.transsion.kolun.cardtemplate.engine.RenderThreadHelper;
import com.transsion.kolun.cardtemplate.engine.view.imagetext.LabelImageViewGroup;
import com.transsion.kolun.cardtemplate.layout.content.basictext.SecondaryInfoLyt;
import com.transsion.kolun.cardtemplate.layout.content.imagegrid.ImageGridLyt;

public class ImageGridItemViews {
    Context mContext;
    LabelImageViewGroup mLabelImageViewGroup;
    BasicTextView mTextView;
    CustomLinearLayout mView;

    public ImageGridItemViews(View view) {
        this.mContext = view.getContext();
        this.mLabelImageViewGroup = new LabelImageViewGroup(view);
        this.mTextView = (BasicTextView)view.findViewById(R.id.sdk_koluncard_image_grid_text_view);
        this.mView = (CustomLinearLayout)view;
    }

    public void onBindViews(ImageGrid content, ImageGridLyt layout2) {
        this.onBindViews(layout2);
        this.onBindViews(content);
    }

    public void onBindViews(ImageGrid content, int position) {
        this.onBindViews(content);
        if (content != null) {
            this.mView.setOnClickListener(v -> RenderThreadHelper.sendActionAndTracking((View)this.mView, content.getAction(), "picture_hot_zone", position));
        }
    }

    public void onBindViews(ImageGrid content) {
        if (content == null) {
            this.mLabelImageViewGroup.setViewInvisible();
            this.mTextView.setVisibility(8);
        } else {
            this.mLabelImageViewGroup.onBindViews(content.getLabelImage());
            SecondaryInfo secondaryInfo = content.getSecondaryInfo();
            if (secondaryInfo != null) {
                this.mTextView.setText(secondaryInfo.getContent());
                this.mTextView.setBasicTextColor(secondaryInfo.getTextColor(), 2);
            }
        }
    }

    public void onBindViews(ImageGridLyt layout2) {
        if (layout2 == null) {
            this.mLabelImageViewGroup.setViewInvisible();
            this.mTextView.setVisibility(8);
        } else {
            this.mLabelImageViewGroup.onBindViews(layout2.getLabelImageLyt(), true);
            SecondaryInfoLyt secondaryInfoLyt = layout2.getSecondaryInfoLyt();
            if (secondaryInfoLyt != null) {
                this.mTextView.setVisibility(secondaryInfoLyt.isInvisible() ? 8 : 0);
            }
        }
    }
}

