/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.kolun.cardtemplate.engine.view.imagegrid;

import android.annotation.SuppressLint;
import android.view.View;
import com.transsion.kolun.cardtemplate.R;
import com.transsion.kolun.cardtemplate.bean.content.imagegrid.CardContentTypeImageGrid;
import com.transsion.kolun.cardtemplate.bean.content.imagegrid.ImageGrid;
import com.transsion.kolun.cardtemplate.engine.view.imagegrid.ImageGridDescViews;
import com.transsion.kolun.cardtemplate.engine.view.imagegrid.ImageGridViewGroupFour;
import com.transsion.kolun.cardtemplate.engine.view.imagegrid.ImageGridViewGroupOne;
import com.transsion.kolun.cardtemplate.engine.view.imagegrid.ImageGridViewGroupThree;
import com.transsion.kolun.cardtemplate.engine.view.imagegrid.ImageGridViewGroupTwo;
import com.transsion.kolun.cardtemplate.layout.content.imagegrid.CardImageGridLyt;
import com.transsion.kolun.cardtemplate.layout.content.imagegrid.ImageGridLyt;
import java.util.List;

public class ImageGridViewGroup {
    ImageGridDescViews mDescriptionViews;
    ImageGridViewGroupOne mImageGridViewGroupOne;
    ImageGridViewGroupTwo mImageGridViewGroupTwo;
    ImageGridViewGroupThree mImageGridViewGroupThree;
    ImageGridViewGroupFour mImageGridViewGroupFour;
    public static final int IMAGE_GRID_MAX_NUMBER = 4;

    public ImageGridViewGroup(View view) {
        this.mDescriptionViews = new ImageGridDescViews(view);
        this.mImageGridViewGroupOne = new ImageGridViewGroupOne(view.findViewById(R.id.sdk_koluncard_image_grid_view_one));
        this.mImageGridViewGroupTwo = new ImageGridViewGroupTwo(view.findViewById(R.id.sdk_koluncard_image_grid_view_two));
        this.mImageGridViewGroupThree = new ImageGridViewGroupThree(view.findViewById(R.id.sdk_koluncard_image_grid_view_three));
        this.mImageGridViewGroupFour = new ImageGridViewGroupFour(view.findViewById(R.id.sdk_koluncard_image_grid_view_four));
    }

    private int getGridItemCount(List<ImageGrid> contentList, List<ImageGridLyt> layoutList) {
        if (contentList == null && layoutList == null) {
            return 0;
        }
        if (contentList != null && layoutList != null) {
            return Math.min(4, Math.min(contentList.size(), layoutList.size()));
        }
        if (contentList == null) {
            return Math.min(4, layoutList.size());
        }
        return Math.min(4, contentList.size());
    }

    @SuppressLint(value={"WrongConstant"})
    private void configureImageGridView(CardContentTypeImageGrid content, CardImageGridLyt layout2) {
        int itemCount = this.getGridItemCount(content == null ? null : content.getImageGrids(), layout2 == null ? null : layout2.getImageGridLyts());
        switch (itemCount) {
            case 1: {
                this.setViewsVisibility(false, true, true, true);
                this.mImageGridViewGroupOne.onBindViews(content, layout2);
                break;
            }
            case 2: {
                this.setViewsVisibility(true, false, true, true);
                this.mImageGridViewGroupTwo.onBindViews(content, layout2);
                break;
            }
            case 3: {
                this.setViewsVisibility(true, true, false, true);
                this.mImageGridViewGroupThree.onBindViews(content, layout2);
                break;
            }
            case 4: {
                this.setViewsVisibility(true, true, true, false);
                this.mImageGridViewGroupFour.onBindViews(content, layout2);
                break;
            }
            default: {
                this.setViewsVisibility(true, true, true, true);
            }
        }
    }

    @SuppressLint(value={"WrongConstant"})
    private void configureImageGridView(List<ImageGrid> contentList, List<ImageGridLyt> layoutList) {
        int itemCount = this.getGridItemCount(contentList, layoutList);
        switch (itemCount) {
            case 1: {
                this.setViewsVisibility(false, true, true, true);
                this.mImageGridViewGroupOne.onBindViews(contentList, layoutList);
                break;
            }
            case 2: {
                this.setViewsVisibility(true, false, true, true);
                this.mImageGridViewGroupTwo.onBindViews(contentList, layoutList);
                break;
            }
            case 3: {
                this.setViewsVisibility(true, true, false, true);
                this.mImageGridViewGroupThree.onBindViews(contentList, layoutList);
                break;
            }
            case 4: {
                this.setViewsVisibility(true, true, true, false);
                this.mImageGridViewGroupFour.onBindViews(contentList, layoutList);
                break;
            }
            default: {
                this.setViewsVisibility(true, true, true, true);
            }
        }
    }

    private void setViewsVisibility(boolean isViewOneInvisible, boolean isViewTwoInvisible, boolean isViewThreeInvisible, boolean isViewFourInvisible) {
        this.mImageGridViewGroupOne.setVisibility(isViewOneInvisible);
        this.mImageGridViewGroupTwo.setVisibility(isViewTwoInvisible);
        this.mImageGridViewGroupThree.setVisibility(isViewThreeInvisible);
        this.mImageGridViewGroupFour.setVisibility(isViewFourInvisible);
    }

    @SuppressLint(value={"WrongConstant"})
    public void onBindViews(CardContentTypeImageGrid content, CardImageGridLyt layout2) {
        if (layout2 != null && content != null) {
            this.mDescriptionViews.onBindViews(content, layout2);
            this.configureImageGridView(content, layout2);
        }
    }

    @SuppressLint(value={"WrongConstant"})
    public void onBindViews(List<ImageGrid> contentList, List<ImageGridLyt> layoutList) {
        if (contentList != null && layoutList != null) {
            this.configureImageGridView(contentList, layoutList);
        } else if (contentList != null) {
            this.configureImageGridView(contentList, null);
        } else {
            this.configureImageGridView(null, layoutList);
        }
    }

    @SuppressLint(value={"WrongConstant"})
    public void onBindViews(CardContentTypeImageGrid content) {
        if (content != null) {
            this.mDescriptionViews.onBindViews(content);
            this.configureImageGridView(content, null);
        }
    }

    @SuppressLint(value={"WrongConstant"})
    public void onBindViews(CardImageGridLyt layout2) {
        if (layout2 != null) {
            this.mDescriptionViews.onBindViews(layout2);
            this.configureImageGridView(null, layout2);
        }
    }
}

