/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.kolun.cardtemplate.engine.view.imagetext;

import android.annotation.SuppressLint;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import com.transsion.kolun.cardtemplate.R;
import com.transsion.kolun.cardtemplate.bean.content.basictext.BasicTextContent;
import com.transsion.kolun.cardtemplate.bean.content.image.CardContentTypeImage;
import com.transsion.kolun.cardtemplate.customwidget.RoundCornerLinearLayout;
import com.transsion.kolun.cardtemplate.engine.RenderThreadHelper;
import com.transsion.kolun.cardtemplate.engine.view.basictext.BasicTextViewGroup;
import com.transsion.kolun.cardtemplate.engine.view.imagetext.LabelImageViewGroup;
import com.transsion.kolun.cardtemplate.layout.content.basictext.BasicTextContentLyt;
import com.transsion.kolun.cardtemplate.layout.content.image.BasicImageContentLyt;
import com.transsion.kolun.cardtemplate.utils.CommonUtils;

public class ImageTextViewGroup
extends BasicTextViewGroup {
    RelativeLayout mBasicTextLayout;
    RoundCornerLinearLayout mBackgroundView;
    LabelImageViewGroup mLabelImageViewGroup;
    ImageView mCircleImageView;

    public ImageTextViewGroup(View view) {
        super(view.findViewById(R.id.sdk_koluncard_content_area) == null ? view : view.findViewById(R.id.sdk_koluncard_content_area));
        this.mBasicTextLayout = (RelativeLayout)view.findViewById(R.id.basic_text_layout);
        this.mBackgroundView = (RoundCornerLinearLayout)view.findViewById(R.id.sdk_koluncard_gradient_bg_layout);
        this.mLabelImageViewGroup = new LabelImageViewGroup(view);
        this.mCircleImageView = (ImageView)view.findViewById(R.id.sdk_koluncard_circle_image_view);
    }

    @SuppressLint(value={"WrongConstant"})
    public void onBindViews(CardContentTypeImage content, BasicImageContentLyt layout2) {
        super.onBindViews((BasicTextContent)content, (BasicTextContentLyt)layout2, false);
        this.onBindViews(layout2);
        this.onBindContentViews(content);
        this.setContentClickAction(content);
    }

    public void onBindViews(CardContentTypeImage content, BasicImageContentLyt layout2, int position) {
        super.onBindViews((BasicTextContent)content, (BasicTextContentLyt)layout2, false);
        this.onBindViews(layout2);
        this.onBindContentViews(content);
        this.setListContentClickAction(content, position);
    }

    public void onBindViews(CardContentTypeImage content) {
        this.onBindContentViews(content);
        this.setContentClickAction(content);
    }

    @SuppressLint(value={"WrongConstant"})
    private void onBindContentViews(CardContentTypeImage content) {
        super.onBindViews((BasicTextContent)content, false);
        if (content != null) {
            boolean nightMode;
            this.mLabelImageViewGroup.onBindViews(content.getLabelImage());
            if (content.getLabelImage() != null) {
                RenderThreadHelper.setRemoteImage(content.getLabelImage().getBitmap(), this.mCircleImageView);
            }
            boolean bl = nightMode = (this.mContentView.getContext().getResources().getConfiguration().uiMode & 0x30) == 32;
            if (!nightMode && CommonUtils.isBrandXos() && content.getBackgroundGradientColors() != null && content.getBackgroundGradientColors().length == 3) {
                this.setBackgroundViewColor(content.getBackgroundGradientColors());
                return;
            }
            this.setBackgroundViewColor(0);
        }
    }

    private void setListContentClickAction(CardContentTypeImage content, int position) {
        if (this.mContentView != null && content != null) {
            this.mContentView.setOnClickListener(v -> RenderThreadHelper.sendActionAndTracking(this.mContentView, content.getContentAction(), "list_card_hot_zone", position));
        }
    }

    private void setContentClickAction(CardContentTypeImage content) {
        if (this.mContentView != null && content != null) {
            this.mContentView.setOnClickListener(v -> RenderThreadHelper.sendActionAndTracking(this.mContentView, content.getContentAction(), "content_area_hot_area_cl"));
        }
    }

    @SuppressLint(value={"WrongConstant"})
    public void onBindViews(BasicImageContentLyt layout2) {
        if (layout2 != null) {
            if (layout2.getLabelImageLyt() != null && !layout2.getLabelImageLyt().isImageInvisible()) {
                this.onBindViewsWithLimitWidth();
            }
            super.onBindViews((BasicTextContentLyt)layout2);
            if (layout2.isCircleImage()) {
                this.mCircleImageView.setVisibility(0);
                this.mLabelImageViewGroup.setViewInvisible();
                RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)this.mBasicTextLayout.getLayoutParams();
                layoutParams.addRule(15);
            } else {
                this.setBackgroundViewColor(0);
                this.mCircleImageView.setVisibility(8);
                this.mLabelImageViewGroup.onBindViews(layout2.getLabelImageLyt(), false);
                RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)this.mBasicTextLayout.getLayoutParams();
                layoutParams.removeRule(15);
            }
        }
    }

    private void setBackgroundViewColor(int ... colors) {
        if (this.mBackgroundView == null) {
            return;
        }
        if (colors != null && colors.length == 1) {
            this.mBackgroundView.setBackgroundColor(colors[0]);
        } else {
            this.mBackgroundView.setGradientBackgroundColors(colors);
        }
    }

    private void onBindViewsWithLimitWidth() {
        RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)this.mBasicTextLayout.getLayoutParams();
        layoutParams.width = this.mBasicTextLayout.getContext().getResources().getDimensionPixelSize(R.dimen.dp_205);
        layoutParams.addRule(19);
        this.mBasicTextLayout.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }
}

