/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.kolun.cardtemplate.engine.view.imagetext;

import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import com.transsion.kolun.cardtemplate.R;
import com.transsion.kolun.cardtemplate.bean.content.image.LabelImage;
import com.transsion.kolun.cardtemplate.customwidget.CustomCardImageView;
import com.transsion.kolun.cardtemplate.customwidget.CustomLabelView;
import com.transsion.kolun.cardtemplate.customwidget.RoundCornerRelativeLayout;
import com.transsion.kolun.cardtemplate.engine.RenderThreadHelper;
import com.transsion.kolun.cardtemplate.engine.template.TemplateUtils;
import com.transsion.kolun.cardtemplate.layout.content.image.LabelImageLyt;

public class LabelImageViewGroup {
    RoundCornerRelativeLayout mLabelImageLayout;
    CustomCardImageView mImageView;
    CustomLabelView mOperationLabelView;
    CustomLabelView mFunctionLabelView;

    public LabelImageViewGroup(View view) {
        this.mLabelImageLayout = view.findViewById(R.id.label_image_rl) == null ? (RoundCornerRelativeLayout)view.findViewById(R.id.mix_label_image) : (RoundCornerRelativeLayout)view.findViewById(R.id.label_image_rl);
        this.mImageView = (CustomCardImageView)view.findViewById(R.id.sdk_koluncard_label_image_view);
        this.mOperationLabelView = (CustomLabelView)view.findViewById(R.id.sdk_koluncard_label_image_operation_label);
        this.mFunctionLabelView = (CustomLabelView)view.findViewById(R.id.sdk_koluncard_label_image_function_label);
    }

    public void setViewInvisible() {
        if (this.mLabelImageLayout != null) {
            this.mLabelImageLayout.setVisibility(8);
        }
    }

    public void onBindViews(LabelImage content, LabelImageLyt layout2, boolean isGridImage) {
        this.onBindViews(layout2, isGridImage);
        this.onBindViews(content);
    }

    public void onBindViews(LabelImage content) {
        if (content != null) {
            if (this.mImageView.getVisibility() == 0) {
                RenderThreadHelper.setRemoteImage(content.getBitmap(), (ImageView)this.mImageView);
            }
            if (content.getOperationalLabel() != null) {
                this.mOperationLabelView.setBackgroundColor(content.getOperationalLabel().getBackgroundColor());
                this.mOperationLabelView.setTextColor(content.getOperationalLabel().getLabelColor());
                this.mOperationLabelView.setText(content.getOperationalLabel().getLabelText());
            }
            if (content.getFunctionLabel() != null) {
                this.mFunctionLabelView.setText(content.getFunctionLabel().getLabelText());
            }
        }
    }

    public void onBindViews(LabelImageLyt layout2, boolean isGridImage) {
        if (layout2 != null && !layout2.isImageInvisible()) {
            this.mImageView.setVisibility(0);
            this.mOperationLabelView.setVisibility(layout2.isOperationalLabelInvisible() ? 8 : 0);
            this.mFunctionLabelView.setVisibility(layout2.isFunctionLabelInvisible() ? 8 : 0);
            if (!isGridImage) {
                TemplateUtils.scaleImage((View)this.mImageView, layout2.getLabelImageProportion());
            }
        } else {
            this.setViewInvisible();
        }
    }

    public void resetImageMargin() {
        LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams)this.mLabelImageLayout.getLayoutParams();
        layoutParams.setMargins(0, 0, 0, 0);
        this.mLabelImageLayout.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    public void setImageViewHeight(int itemNumber) {
        this.mLabelImageLayout.setImageViewLayoutHeight(itemNumber);
    }
}

