/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.kolun.cardtemplate.engine.view.list;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.transsion.kolun.cardtemplate.R;
import com.transsion.kolun.cardtemplate.TemplateKolunCardManager;
import com.transsion.kolun.cardtemplate.bean.content.selectabletext.SelectableTextContent;
import com.transsion.kolun.cardtemplate.engine.RenderThreadHelper;
import com.transsion.kolun.cardtemplate.engine.view.selectabletext.SelectableTextViewGroup;
import com.transsion.kolun.cardtemplate.layout.content.selectabletext.SelectableTextLyt;
import java.util.ArrayList;
import java.util.List;

public class SelectableTextListAdapter
extends RecyclerView.Adapter<ViewHolder>
implements SelectableTextViewGroup.ListItemClickListener {
    private static final int MIN_CLICK_DELAY_TIME = 1000;
    private static final long TODO_CARD_ID = 9000L;
    private final List<SelectableTextContent> mContentList = new ArrayList<SelectableTextContent>();
    private SelectableTextLyt mLayout = new SelectableTextLyt();
    private long mLastClickTime = 0L;

    @NonNull
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        Context context = parent.getContext();
        View itemView = LayoutInflater.from((Context)context).inflate(R.layout.sdk_koluncard_content_selectable_text, parent, false);
        return new ViewHolder(itemView);
    }

    public void onBindViewHolder(@NonNull ViewHolder holder, int position) {
        SelectableTextContent content = this.mContentList.get(position);
        holder.mSelectableTextViewGroup.onBindViews(content, this.mLayout, this, position);
    }

    public int getItemCount() {
        return Math.min(this.mContentList.size(), 3);
    }

    public int getItemViewType(int position) {
        return position;
    }

    @Override
    public boolean isRemovable() {
        long currentClickTime = System.currentTimeMillis();
        if (currentClickTime - this.mLastClickTime < 1000L) {
            return false;
        }
        this.mLastClickTime = currentClickTime;
        return true;
    }

    @Override
    public void removeItem(Context context, int position, long contentId) {
        this.notifyItemRemoved(position);
        this.mContentList.remove(position);
        if (position != this.mContentList.size()) {
            this.notifyItemRangeChanged(position, this.mContentList.size() - position);
        }
        RenderThreadHelper.getWorkHandler().post(() -> TemplateKolunCardManager.getInstance(context).getCardActionManager().sendLocalCardAction(9000L, contentId));
    }

    public void setCardContents(List<SelectableTextContent> contents, SelectableTextLyt layout2) {
        if (contents != null) {
            this.replaceAll(contents, layout2);
        }
    }

    private void replaceAll(List<SelectableTextContent> contents, SelectableTextLyt layout2) {
        this.mContentList.clear();
        this.mContentList.addAll(contents);
        this.mLayout = layout2;
        this.notifyDataSetChanged();
    }

    public void setCardContents(List<SelectableTextContent> contents) {
        if (contents != null) {
            this.replaceAll(contents, this.mLayout);
        }
    }

    public void setCardContents(SelectableTextLyt layout2) {
        this.mLayout = layout2;
        this.notifyDataSetChanged();
    }

    public static class ViewHolder
    extends RecyclerView.ViewHolder {
        SelectableTextViewGroup mSelectableTextViewGroup;

        public ViewHolder(@NonNull View itemView) {
            super(itemView);
            this.mSelectableTextViewGroup = new SelectableTextViewGroup(itemView);
        }
    }
}

