/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.kolun.cardtemplate.engine.view.mixtype;

import android.annotation.SuppressLint;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.Switch;
import com.transsion.kolun.cardtemplate.R;
import com.transsion.kolun.cardtemplate.bean.base.CardBitmap;
import com.transsion.kolun.cardtemplate.bean.content.basictext.BasicTextContent;
import com.transsion.kolun.cardtemplate.bean.content.image.LabelImage;
import com.transsion.kolun.cardtemplate.bean.content.mix.CardContentTypeMix;
import com.transsion.kolun.cardtemplate.bean.content.mix.OperationBtn;
import com.transsion.kolun.cardtemplate.customwidget.CustomCardImageView;
import com.transsion.kolun.cardtemplate.engine.RenderThreadHelper;
import com.transsion.kolun.cardtemplate.engine.view.basictext.BasicTextViewGroup;
import com.transsion.kolun.cardtemplate.engine.view.imagetext.LabelImageViewGroup;
import com.transsion.kolun.cardtemplate.layout.content.basictext.BasicTextContentLyt;
import com.transsion.kolun.cardtemplate.layout.content.mix.BasicMixContentLyt;

public class MixTypeViewGroup
extends BasicTextViewGroup {
    private static final int POSITION_BUTTON_ONE = 0;
    private static final int POSITION_BUTTON_TWO = 1;
    LabelImageViewGroup mLabelImageViewGroup;
    CustomCardImageView mIconView;
    View mBasicTextArea;
    ImageView mImageBtnOne;
    ImageView mImageBtnTwo;
    Switch mSwitch;

    public MixTypeViewGroup(View view) {
        super(view);
        this.mLabelImageViewGroup = new LabelImageViewGroup(view);
        this.mIconView = (CustomCardImageView)view.findViewById(R.id.sdk_koluncard_mix_type_icon);
        this.mBasicTextArea = view.findViewById(R.id.sdk_koluncard_basic_text_area);
        this.mImageBtnOne = (ImageView)view.findViewById(R.id.sdk_koluncard_image_button_one);
        this.mImageBtnTwo = (ImageView)view.findViewById(R.id.sdk_koluncard_image_button_two);
        this.mSwitch = (Switch)view.findViewById(R.id.sdk_koluncard_content_switch);
    }

    public void onBindViews(CardContentTypeMix content, BasicMixContentLyt layout2) {
        this.onBindViews(layout2);
        this.onBindContentViews(content);
        this.setContentClickAction(content);
    }

    public void onBindViews(CardContentTypeMix content, BasicMixContentLyt layout2, int position) {
        this.onBindViews(layout2);
        this.onBindContentViews(content);
        this.setListContentClickAction(content, position);
    }

    public void onBindViews(CardContentTypeMix content) {
        this.onBindContentViews(content);
        this.setContentClickAction(content);
    }

    @SuppressLint(value={"WrongConstant"})
    private void onBindContentViews(CardContentTypeMix content) {
        if (content != null) {
            CardBitmap buttonBitmap;
            super.onBindViews((BasicTextContent)content, false);
            LabelImage labelImage = content.getLabelImage();
            this.mLabelImageViewGroup.onBindViews(labelImage);
            if (labelImage != null && this.mIconView.getVisibility() == 0) {
                RenderThreadHelper.setRemoteImage(labelImage.getBitmap(), (ImageView)this.mIconView);
            }
            OperationBtn buttonOne = content.getOperationBtnOne();
            OperationBtn buttonTwo = content.getOperationBtnTwo();
            if (buttonOne != null && this.mImageBtnOne.getVisibility() == 0) {
                this.mImageBtnOne.setOnClickListener(v -> RenderThreadHelper.sendActionAndTracking((View)this.mImageBtnOne, buttonOne.getAction(), "content_area_button", 0));
                buttonBitmap = buttonOne.getButtonImage();
                if (buttonBitmap != null) {
                    RenderThreadHelper.setRemoteImage(buttonBitmap, this.mImageBtnOne);
                }
            }
            if (buttonTwo != null && this.mImageBtnTwo.getVisibility() == 0) {
                this.mImageBtnTwo.setOnClickListener(v -> RenderThreadHelper.sendActionAndTracking((View)this.mImageBtnTwo, buttonTwo.getAction(), "content_area_button", 1));
                buttonBitmap = buttonTwo.getButtonImage();
                if (buttonBitmap != null) {
                    RenderThreadHelper.setRemoteImage(buttonBitmap, this.mImageBtnTwo);
                }
            }
        }
    }

    private void setListContentClickAction(CardContentTypeMix content, int position) {
        if (this.mContentView != null && content != null) {
            this.mContentView.setOnClickListener(v -> RenderThreadHelper.sendActionAndTracking(this.mContentView, content.getContentAction(), "list_card_hot_zone", position));
        }
    }

    private void setContentClickAction(CardContentTypeMix content) {
        if (this.mContentView != null && content != null) {
            this.mContentView.setOnClickListener(v -> RenderThreadHelper.sendActionAndTracking(this.mContentView, content.getContentAction(), "content_area_hot_area_cl"));
        }
    }

    @SuppressLint(value={"WrongConstant"})
    public void onBindViews(BasicMixContentLyt layout2) {
        if (layout2 != null) {
            int buttonMarginTop;
            super.onBindViews((BasicTextContentLyt)layout2);
            boolean isButtonOneInvisible = layout2.isOperationalBtnOneInvisible();
            boolean isButtonTwoInvisible = layout2.isOperationalBtnTwoInvisible();
            int textMarginRight = isButtonOneInvisible && isButtonTwoInvisible ? 0 : this.mBasicTextArea.getContext().getResources().getDimensionPixelSize(R.dimen.dp_45);
            if (layout2.isIconInvisible()) {
                this.mIconView.setVisibility(8);
                this.mLabelImageViewGroup.onBindViews(layout2.getLabelImageLyt(), false);
                buttonMarginTop = this.mImageBtnTwo.getContext().getResources().getDimensionPixelSize(R.dimen.dp_12);
                this.setBasicTextLayout(this.mBasicTextArea, R.id.mix_label_image, textMarginRight);
            } else {
                this.mIconView.setVisibility(0);
                buttonMarginTop = this.mImageBtnTwo.getContext().getResources().getDimensionPixelSize(R.dimen.dp_7);
                this.mLabelImageViewGroup.setViewInvisible();
                this.setBasicTextLayout(this.mBasicTextArea, R.id.sdk_koluncard_mix_type_icon, textMarginRight);
            }
            this.setImageButtonLyt(isButtonOneInvisible, isButtonTwoInvisible, buttonMarginTop);
        }
    }

    @SuppressLint(value={"WrongConstant"})
    private void setImageButtonLyt(boolean isButtonOneInvisible, boolean isButtonTwoInvisible, int marginTop) {
        if (isButtonTwoInvisible) {
            this.mImageBtnOne.setVisibility(8);
            this.mImageBtnTwo.setVisibility(8);
        } else {
            this.mImageBtnOne.setVisibility(isButtonOneInvisible ? 8 : 0);
            this.mImageBtnTwo.setVisibility(0);
            this.setButtonMarginTop(marginTop);
        }
    }

    private void setBasicTextLayout(View view, int alignSubject, int rightMargin) {
        RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)view.getLayoutParams();
        layoutParams.removeRule(17);
        layoutParams.addRule(17, alignSubject);
        layoutParams.setMarginEnd(rightMargin);
        view.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    private void setButtonMarginTop(int marginTopInPixel) {
        RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)this.mImageBtnTwo.getLayoutParams();
        layoutParams.setMargins(0, marginTopInPixel, 0, 0);
        this.mImageBtnTwo.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }
}

