/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.kolun.cardtemplate.engine.view.selectabletext;

import android.annotation.SuppressLint;
import android.content.Context;
import android.view.View;
import android.widget.Button;
import com.transsion.kolun.cardtemplate.R;
import com.transsion.kolun.cardtemplate.bean.content.selectabletext.SelectableTextContent;
import com.transsion.kolun.cardtemplate.customwidget.BasicTextView;
import com.transsion.kolun.cardtemplate.engine.RenderThreadHelper;
import com.transsion.kolun.cardtemplate.layout.content.selectabletext.SelectableTextLyt;
import com.transsion.kolun.cardtemplate.utils.CommonUtils;

public class SelectableTextViewGroup {
    Button mRadioButton;
    BasicTextView mTextView;

    public SelectableTextViewGroup(View view) {
        this.mRadioButton = (Button)view.findViewById(R.id.sdk_koluncard_selectable_image_button);
        this.mTextView = (BasicTextView)view.findViewById(R.id.sdk_koluncard_selectable_text_view);
    }

    @SuppressLint(value={"WrongConstant"})
    public void onBindViews(SelectableTextContent content, SelectableTextLyt layout2, ListItemClickListener listener, int position) {
        this.mTextView.setBasicTextColor(0);
        if (layout2 != null) {
            this.mTextView.setMaxLines(layout2.getMaxLines() > 0 ? layout2.getMaxLines() : 1);
        }
        if (content != null) {
            this.mTextView.setText(content.getText());
            this.setRadioButtonBackground();
            this.mRadioButton.setOnClickListener(view -> {
                if (listener.isRemovable()) {
                    this.mRadioButton.setSelected(true);
                    RenderThreadHelper.getWorkHandler().postDelayed(() -> RenderThreadHelper.getMainHandler().post(() -> {
                        listener.removeItem(this.mRadioButton.getContext(), position, content.getContentId());
                        this.mRadioButton.setSelected(false);
                    }), 200L);
                }
            });
        }
    }

    private void setRadioButtonBackground() {
        this.mRadioButton.setSelected(false);
        if (CommonUtils.isBrandXos()) {
            if (CommonUtils.isLaterThanVersion12_0()) {
                this.mRadioButton.setBackgroundResource(R.drawable.sdk_koluncard_selector_radio_button_bg_xos_12_0);
            } else {
                this.mRadioButton.setBackgroundResource(R.drawable.sdk_koluncard_selector_radio_button_bg_xos_8_6);
            }
        } else {
            this.mRadioButton.setBackgroundResource(R.drawable.sdk_koluncard_selector_radio_button_bg_hios_8_6);
        }
    }

    public static interface ListItemClickListener {
        public boolean isRemovable();

        public void removeItem(Context var1, int var2, long var3);
    }
}

