/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.kolun.cardtemplate.engine.view.textgrid;

import android.view.View;
import com.transsion.kolun.cardtemplate.R;
import com.transsion.kolun.cardtemplate.bean.content.basictext.PrimaryInfo;
import com.transsion.kolun.cardtemplate.bean.content.basictext.SecondaryInfo;
import com.transsion.kolun.cardtemplate.bean.content.textgrid.TextGrid;
import com.transsion.kolun.cardtemplate.customwidget.BasicTextView;
import com.transsion.kolun.cardtemplate.customwidget.CustomLinearLayout;
import com.transsion.kolun.cardtemplate.layout.content.basictext.PrimaryInfoLyt;
import com.transsion.kolun.cardtemplate.layout.content.basictext.SecondaryInfoLyt;
import com.transsion.kolun.cardtemplate.layout.content.textgrid.TextGridLyt;

public class TextGridItemViews {
    CustomLinearLayout mLayoutView;
    BasicTextView mPrimaryInfoTextView;
    BasicTextView mSecondaryInfoTextView;

    public TextGridItemViews(View view) {
        this.mLayoutView = (CustomLinearLayout)view;
        this.mPrimaryInfoTextView = (BasicTextView)view.findViewById(R.id.sdk_koluncard_text_grid_primary_info);
        this.mSecondaryInfoTextView = (BasicTextView)view.findViewById(R.id.sdk_koluncard_text_grid_secondary_info);
    }

    public void onBindViews(TextGrid content, TextGridLyt layout2) {
        this.onBindViews(layout2);
        this.onBindViews(content);
    }

    public void onBindViews(TextGrid content) {
        if (content != null) {
            SecondaryInfo secondaryInfo;
            PrimaryInfo primaryInfo = content.getPrimaryInfo();
            if (primaryInfo != null) {
                this.mPrimaryInfoTextView.setText(primaryInfo.getContent());
                this.mPrimaryInfoTextView.setBasicTextColor(primaryInfo.getTextColor(), 0);
            }
            if ((secondaryInfo = content.getSecondaryInfo()) != null) {
                this.mSecondaryInfoTextView.setText(secondaryInfo.getContent());
                this.mSecondaryInfoTextView.setBasicTextColor(secondaryInfo.getTextColor(), 2);
            }
        }
    }

    public void onBindViews(TextGridLyt layout2) {
        if (layout2 != null) {
            SecondaryInfoLyt secondaryInfoLyt;
            PrimaryInfoLyt primaryInfoLyt = layout2.getPrimaryInfoLyt();
            if (primaryInfoLyt != null) {
                this.mPrimaryInfoTextView.setVisibility(primaryInfoLyt.isInvisible() ? 8 : 0);
            }
            if ((secondaryInfoLyt = layout2.getSecondaryInfoLyt()) != null) {
                this.mSecondaryInfoTextView.setVisibility(secondaryInfoLyt.isInvisible() ? 8 : 0);
            }
        } else {
            this.mPrimaryInfoTextView.setVisibility(8);
            this.mSecondaryInfoTextView.setVisibility(8);
        }
    }

    public void setMaxWidth(int gridNumber) {
        this.mLayoutView.setContainItemCount(gridNumber);
    }
}

