/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.kolun.cardtemplate.transport;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.VectorDrawable;
import android.os.RemoteException;
import android.util.Log;
import com.alibaba.fastjson.JSON;
import com.transsion.kolun.cardtemplate.IImageInterface;
import com.transsion.kolun.cardtemplate.bean.base.CardBitmap;
import com.transsion.kolun.cardtemplate.engine.resource.ResourceManager;
import com.transsion.kolun.cardtemplate.utils.UIUtils;

public class CardBitmapCache {
    private static final String TAG = "CardBitmapCache";

    public static Bitmap getBitmap(Context context, CardBitmap cardBitmap, IImageInterface imageInterface, String packageName) {
        if (cardBitmap.getType() == 1) {
            if (cardBitmap.getUri().isEmpty()) {
                return null;
            }
            Bitmap bitmap = CardBitmapCache.getBitmapWithUri(context, cardBitmap, packageName);
            if (bitmap != null) {
                return bitmap;
            }
        }
        if (imageInterface != null) {
            try {
                return imageInterface.getBitmap(CardBitmapCache.getBitmapBundleKey(cardBitmap), packageName);
            }
            catch (RemoteException e) {
                Log.e((String)TAG, (String)("getBitmap : " + (Object)((Object)e)));
            }
        } else {
            Log.e((String)TAG, (String)"getBitmap imageInterface : null");
        }
        Log.w((String)TAG, (String)"getBitmap : null");
        return null;
    }

    public static Bitmap getSubscriptionBitmap(long cardId, String uri, int type, IImageInterface imageInterface) {
        if (imageInterface != null) {
            try {
                return imageInterface.getSubscriptionBitmap(cardId, uri, type);
            }
            catch (RemoteException e) {
                Log.e((String)TAG, (String)("getSubscriptionBitmap : " + (Object)((Object)e)));
            }
        } else {
            Log.e((String)TAG, (String)"getSubscriptionBitmap imageInterface : null");
        }
        Log.w((String)TAG, (String)"getBitmap : null");
        return null;
    }

    private static Bitmap getBitmapWithUri(Context context, CardBitmap cardBitmap, String packageName) {
        Context resourceContext = ResourceManager.getContextForResources(context, packageName);
        String uri = cardBitmap.getUri();
        int id2 = 0;
        if (uri.startsWith("@drawable/")) {
            uri = uri.replaceFirst("@drawable/", "");
            id2 = ResourceManager.getDrawableIdByName(resourceContext, uri);
        } else if (uri.startsWith("@mipmap/")) {
            uri = uri.replaceFirst("@mipmap/", "");
            id2 = ResourceManager.getMipmapIdByName(resourceContext, uri);
        }
        if (id2 != 0) {
            try {
                Drawable drawable2 = resourceContext.getResources().getDrawable(id2, resourceContext.getTheme());
                if (drawable2 instanceof BitmapDrawable) {
                    return ((BitmapDrawable)drawable2).getBitmap();
                }
                if (drawable2 instanceof VectorDrawable) {
                    return UIUtils.decodeVectorDrawable(drawable2);
                }
                return BitmapFactory.decodeResource((Resources)resourceContext.getResources(), (int)id2);
            }
            catch (Resources.NotFoundException e) {
                Log.d((String)TAG, (String)("resources not found: " + e.getMessage()));
                return null;
            }
        }
        return null;
    }

    @SuppressLint(value={"WrongConstant"})
    public static String getBitmapBundleKey(CardBitmap cardBitmap) {
        if (cardBitmap.getType() == 0) {
            return "noType";
        }
        return JSON.toJSONString((Object)cardBitmap);
    }
}

