/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.kolun.cardtemplate.utils;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.util.Log;
import java.lang.reflect.Method;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CommonUtils {
    private static final String TAG = "CommonUtils";
    public static final String BRAND_XOS = "xos";
    public static final String BRAND_HIOS = "hios";
    private static Method mGetMethondInvoke = null;
    public static final String OS_BRAND_TYPE = CommonUtils.getSystemProperty("ro.tranos.type", "hios");
    public static final String OS_VERSION_HIOS_ITEL;
    public static final String OS_VERSION_8_6_HIOS_IIEL;
    public static final String OS_VERSION_XOS;
    public static final String OS_VERSION_8_6_XOS;
    public static final String OS_VERSION_8_6_XOS_TWO;
    public static final String OS_VERSION_12_0_XOS;
    public static final String OS_VERSION_12_0_HIOS;

    public static String getBrandType() {
        return CommonUtils.getSystemProperty("ro.tranos.type", BRAND_HIOS);
    }

    public static boolean isBrandXos() {
        return BRAND_XOS.equals(CommonUtils.getBrandType());
    }

    public static boolean isLaterThanVersion12_0() {
        if (CommonUtils.isBrandXos()) {
            return CommonUtils.compareVersion(CommonUtils.getOsVersion(), OS_VERSION_12_0_XOS) >= 0;
        }
        return CommonUtils.compareVersion(CommonUtils.getOsVersion(), OS_VERSION_12_0_HIOS) >= 0;
    }

    public static String getOsVersion() {
        if (CommonUtils.isBrandXos()) {
            return OS_VERSION_XOS;
        }
        return OS_VERSION_HIOS_ITEL;
    }

    public static int compareVersion(String version1, String version2) {
        String[] a1 = version1.split("\\.");
        String[] a2 = version2.split("\\.");
        for (int n = 0; n < Math.max(a1.length, a2.length); ++n) {
            int j;
            int i = n < a1.length ? Integer.parseInt(a1[n]) : 0;
            int n2 = j = n < a2.length ? Integer.parseInt(a2[n]) : 0;
            if (i < j) {
                return -1;
            }
            if (i <= j) continue;
            return 1;
        }
        return 0;
    }

    public static String getVersionInfo(String osVersion) {
        Log.d((String)TAG, (String)("getVersionInfo osVersion " + osVersion));
        String versionReg = "\\d+(\\.\\d+){2}";
        Pattern pattern = Pattern.compile(versionReg);
        Matcher matcher = pattern.matcher(osVersion);
        if (matcher.find()) {
            String version = matcher.group();
            Log.d((String)TAG, (String)("getVersionInfo version " + version));
            return version;
        }
        return "8.6.0";
    }

    public static String getSystemProperty(String key, String def) {
        try {
            if (mGetMethondInvoke == null) {
                mGetMethondInvoke = CommonUtils.getClassName().getMethod("get", String.class, String.class);
            }
            return (String)mGetMethondInvoke.invoke(null, key, def);
        }
        catch (Exception e) {
            return def;
        }
    }

    private static Class<?> getClassName() {
        Class<?> className = null;
        try {
            className = Class.forName("android.os.SystemProperties");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return className;
    }

    public static boolean isNetworkAvailable(Context context) {
        Network network;
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        if (connectivityManager != null && (network = connectivityManager.getActiveNetwork()) != null) {
            NetworkCapabilities networkCapabilities = connectivityManager.getNetworkCapabilities(network);
            return networkCapabilities != null;
        }
        return false;
    }

    static {
        OS_VERSION_8_6_HIOS_IIEL = "8.6.0";
        OS_VERSION_8_6_XOS = "10.6.0";
        OS_VERSION_8_6_XOS_TWO = "8.6.0";
        OS_VERSION_12_0_HIOS = "12.0.0";
        OS_VERSION_12_0_XOS = "12.0.0";
        OS_VERSION_HIOS_ITEL = CommonUtils.getVersionInfo(CommonUtils.getSystemProperty("ro.tranos.version", OS_VERSION_8_6_HIOS_IIEL));
        OS_VERSION_XOS = CommonUtils.getVersionInfo(CommonUtils.getSystemProperty("ro.tranos.version", OS_VERSION_8_6_XOS));
    }
}

