/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.kolun.cardtemplate.utils;

import android.annotation.SuppressLint;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.RemoteException;
import android.util.Log;

public class ServiceHelper {
    private static final String TAG = "ServiceHelper";
    private static final String ASSISTANT_PACKAGE_NAME = "com.transsion.kolun.assistant";
    private static final String ASSISTANT_LOCAL_CARD_SERVICE_ACTION = "transsion.kolun.assistant.LOCAL_CARD_SERVICE";
    public static final String MESSAGE_KEY_RECORD_ID = "record_id";
    public static final int MSG_CONTENT_CLICK = 4096;
    public static final int MSG_DISCONNECT_SERVICE = 4097;
    private Messenger mActionService = null;
    private boolean mServiceIsBound;
    @SuppressLint(value={"StaticFieldLeak"})
    private static ServiceHelper sInstance;
    private final Context mContext;
    private Callback mCallback;
    private IncomingHandler mIncomingHandler;
    private final Messenger mMessenger;
    private final ServiceConnection mServiceConnection = new ServiceConnection(){

        public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
            Log.d((String)ServiceHelper.TAG, (String)"onServiceConnected");
            ServiceHelper.this.mServiceIsBound = true;
            ServiceHelper.this.mActionService = new Messenger(iBinder);
            if (ServiceHelper.this.mCallback != null) {
                ServiceHelper.this.mCallback.onServiceConnected();
            }
            try {
                Message message = Message.obtain();
                message.replyTo = ServiceHelper.this.mMessenger;
                ServiceHelper.this.mActionService.send(message);
            }
            catch (RemoteException e) {
                Log.d((String)ServiceHelper.TAG, (String)("Receive Service Reply Fail: " + e.getMessage()));
            }
        }

        public void onServiceDisconnected(ComponentName componentName) {
            Log.d((String)ServiceHelper.TAG, (String)"onServiceDisconnected");
            ServiceHelper.this.mServiceIsBound = false;
            ServiceHelper.this.mActionService = null;
        }
    };

    public ServiceHelper(Context context) {
        this.mContext = context;
        this.initIncomingHandler();
        this.mMessenger = new Messenger((Handler)this.mIncomingHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ServiceHelper getInstance(Context context) {
        if (sInstance != null) return sInstance;
        Class<ServiceHelper> clazz = ServiceHelper.class;
        synchronized (ServiceHelper.class) {
            if (sInstance != null) return sInstance;
            sInstance = new ServiceHelper(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return sInstance;
        }
    }

    public boolean isServiceBound() {
        return this.mServiceIsBound;
    }

    public boolean bindService(Callback callback) {
        this.mCallback = callback;
        Intent intent = new Intent();
        intent.setPackage(ASSISTANT_PACKAGE_NAME);
        intent.setAction(ASSISTANT_LOCAL_CARD_SERVICE_ACTION);
        return this.mContext.bindService(intent, this.mServiceConnection, 1);
    }

    public void sendCardAction(int messageType, Bundle bundle) {
        Message message = Message.obtain(null, (int)messageType, (int)0, (int)0);
        message.setData(bundle);
        if (this.mActionService == null) {
            Log.d((String)TAG, (String)"Send Message Failed: service null");
            return;
        }
        try {
            this.mActionService.send(message);
        }
        catch (RemoteException e) {
            Log.d((String)TAG, (String)("Send Message Failed: " + e.getMessage()));
        }
    }

    private void initIncomingHandler() {
        HandlerThread handlerThread = new HandlerThread(TAG, 10);
        handlerThread.start();
        this.mIncomingHandler = new IncomingHandler(handlerThread.getLooper());
    }

    static interface Callback {
        public void onServiceConnected();
    }

    private class IncomingHandler
    extends Handler {
        public IncomingHandler(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message msg) {
            if (msg.what == 4097) {
                ServiceHelper.this.mServiceIsBound = false;
                ServiceHelper.this.mActionService = null;
                ServiceHelper.this.mContext.unbindService(ServiceHelper.this.mServiceConnection);
                Log.d((String)ServiceHelper.TAG, (String)"Service disconnected by server side");
            } else {
                super.handleMessage(msg);
            }
        }
    }
}

