/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.kolun.cardtemplate.utils;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.DrawFilter;
import android.graphics.PaintFlagsDrawFilter;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.IBinder;
import android.text.SpannableString;
import android.text.style.ForegroundColorSpan;
import android.util.Log;
import androidx.annotation.ColorInt;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.transsion.kolun.cardtemplate.IImageInterface;
import com.transsion.kolun.cardtemplate.KolunBridge;
import com.transsion.kolun.cardtemplate.R;
import com.transsion.kolun.cardtemplate.bean.base.CardBitmap;
import com.transsion.kolun.cardtemplate.transport.CardBitmapCache;
import com.transsion.kolun.cardtemplate.utils.CommonUtils;

public class UIUtils {
    private static final String TAG = "UIUtils";
    public static int[] sClientTextColorResList = null;
    public static int[] sClientButtonTextColorResList = null;
    public static final int DEFAULT_TEXT_COLOR_LENGTH = 4;
    private static final int DEFAULT_BUTTON_TEXT_COLOR_LENGTH = 3;
    public static final int DEFAULT_MAIN_TEXT_COLOR_INDEX = 0;
    public static final int DEFAULT_PRIMARY_TEXT_COLOR_INDEX = 0;
    public static final int DEFAULT_SECONDARY_TEXT_COLOR_INDEX = 2;
    public static final int DEFAULT_TITLE_TEXT_COLOR_INDEX = 0;
    public static final int DEFAULT_REMINDER_TEXT_COLOR_INDEX = 0;
    public static final int DEFAULT_BRAND_TEXT_COLOR_INDEX = 3;
    public static final Integer[] XOS_TEXT_COLOR_RES_LIST = new Integer[]{R.color.sdk_koluncard_xos_default_text_color_1, R.color.sdk_koluncard_xos_default_text_color_2, R.color.sdk_koluncard_xos_default_text_color_3, R.color.sdk_koluncard_xos_default_text_color_4};
    public static final Integer[] HIOS_TEXT_COLOR_RES_LIST = new Integer[]{R.color.sdk_koluncard_hios_default_text_color_1, R.color.sdk_koluncard_hios_default_text_color_2, R.color.sdk_koluncard_hios_default_text_color_3, R.color.sdk_koluncard_hios_default_text_color_4};

    public static SpannableString getColoredString(@NonNull String target, @NonNull String text, @ColorInt int foregroundColor, @NonNull int highlightColor) {
        SpannableString spannableString = new SpannableString((CharSequence)text);
        if (text.contains(target)) {
            int start = text.indexOf(target);
            int end = start + target.length();
            spannableString.setSpan((Object)new ForegroundColorSpan(highlightColor), start, end, 18);
            if (start > 0) {
                spannableString.setSpan((Object)new ForegroundColorSpan(foregroundColor), 0, start, 17);
            }
            if (text.length() > end) {
                spannableString.setSpan((Object)new ForegroundColorSpan(foregroundColor), end, text.length(), 34);
            }
        }
        return spannableString;
    }

    public static Bitmap getBitmap(CardBitmap cardBitmap, Context context, String packageName) {
        return CardBitmapCache.getBitmap(context, cardBitmap, UIUtils.getIImageInterface(context), packageName);
    }

    public static Bitmap getSubscriptionBitmap(Context context, long cardId, String uri, int type) {
        return CardBitmapCache.getSubscriptionBitmap(cardId, uri, type, UIUtils.getIImageInterface(context));
    }

    @Nullable
    private static IImageInterface getIImageInterface(Context context) {
        Bundle interfaceBundle = KolunBridge.getInstance().getInterface(context.getPackageName(), "template_image_interface");
        if (interfaceBundle != null) {
            IBinder iBinder = interfaceBundle.getBinder("template_image_interface");
            IImageInterface imageInterface = IImageInterface.Stub.asInterface(iBinder);
            if (imageInterface == null) {
                Log.d((String)TAG, (String)"getIImageInterface iCardInterface == null");
            }
            return imageInterface;
        }
        return null;
    }

    public static void setClientTextColorResList(String[] clientTextColorResList) {
        try {
            if (clientTextColorResList != null && clientTextColorResList.length == 4) {
                int[] tempColors = new int[4];
                for (int i = 0; i < clientTextColorResList.length; ++i) {
                    tempColors[i] = Color.parseColor((String)clientTextColorResList[i]);
                }
                sClientTextColorResList = tempColors;
            }
        }
        catch (IllegalArgumentException e) {
            Log.d((String)TAG, (String)("setClientTextColorResList parse color failed: " + e));
        }
    }

    public static int[] getClientTextColorResList() {
        return sClientTextColorResList;
    }

    public static void setClientButtonTextColorResList(String[] buttonTextColorResList) {
        try {
            if (buttonTextColorResList != null && buttonTextColorResList.length == 3) {
                int[] tempColors = new int[3];
                for (int i = 0; i < buttonTextColorResList.length; ++i) {
                    tempColors[i] = Color.parseColor((String)buttonTextColorResList[i]);
                }
                sClientButtonTextColorResList = tempColors;
            }
        }
        catch (IllegalArgumentException e) {
            Log.d((String)TAG, (String)("setClientButtonTextColorResList parse color failed: " + e));
        }
    }

    public static int[] getClientButtonTextColorResList() {
        return sClientButtonTextColorResList;
    }

    @ColorInt
    public static int getTextColorByIndex(Context context, int colorIndex) {
        return UIUtils.getTextColorByIndex(context, colorIndex, colorIndex);
    }

    @ColorInt
    public static int getTextColorByIndex(Context context, int colorIndex, int defaultColorIndex) {
        int[] textColors = UIUtils.getClientTextColorResList();
        int n = defaultColorIndex = defaultColorIndex >= 0 && defaultColorIndex < 4 ? defaultColorIndex : 0;
        if (textColors != null && textColors.length == 4) {
            if (colorIndex >= 0 && colorIndex < textColors.length) {
                return textColors[colorIndex];
            }
            return textColors[defaultColorIndex];
        }
        if (CommonUtils.isBrandXos()) {
            return UIUtils.getXosTextColorByIndex(context, colorIndex, defaultColorIndex);
        }
        return UIUtils.getHiosTextColorByIndex(context, colorIndex, defaultColorIndex);
    }

    @ColorInt
    private static int getXosTextColorByIndex(Context context, int colorIndex, int defaultColorIndex) {
        if (colorIndex >= 0 && colorIndex < XOS_TEXT_COLOR_RES_LIST.length) {
            return context.getColor(XOS_TEXT_COLOR_RES_LIST[colorIndex].intValue());
        }
        return context.getColor(XOS_TEXT_COLOR_RES_LIST[defaultColorIndex].intValue());
    }

    @ColorInt
    private static int getHiosTextColorByIndex(Context context, int colorIndex, int defaultColorIndex) {
        if (colorIndex >= 0 && colorIndex < HIOS_TEXT_COLOR_RES_LIST.length) {
            return context.getColor(HIOS_TEXT_COLOR_RES_LIST[colorIndex].intValue());
        }
        return context.getColor(HIOS_TEXT_COLOR_RES_LIST[defaultColorIndex].intValue());
    }

    private static int[][] getButtonTextColorStates() {
        return new int[][]{{16842919}, {16842910}, {-16842910}};
    }

    public static ColorStateList getHiosButtonTextColorStateList(Context context) {
        int[] colors = new int[]{context.getResources().getColor(R.color.sdk_koluncard_hios_button_text_color_pressed, null), context.getResources().getColor(R.color.sdk_koluncard_hios_button_text_color_normal, null), context.getResources().getColor(R.color.sdk_koluncard_hios_button_text_color_disable, null)};
        return new ColorStateList(UIUtils.getButtonTextColorStates(), colors);
    }

    public static ColorStateList getXos86ButtonTextColorStateList(Context context) {
        int[] colors = new int[]{context.getResources().getColor(R.color.sdk_koluncard_xos_8_6_button_text_color_pressed, null), context.getResources().getColor(R.color.sdk_koluncard_xos_8_6_button_text_color_normal, null), context.getResources().getColor(R.color.sdk_koluncard_xos_8_6_button_text_color_disable, null)};
        return new ColorStateList(UIUtils.getButtonTextColorStates(), colors);
    }

    public static ColorStateList getXos12ButtonTextColorStateList(Context context) {
        int[] colors = new int[]{context.getResources().getColor(R.color.sdk_koluncard_xos_12_0_button_text_color_pressed, null), context.getResources().getColor(R.color.sdk_koluncard_xos_12_0_button_text_color_normal, null), context.getResources().getColor(R.color.sdk_koluncard_xos_12_0_button_text_color_disable, null)};
        return new ColorStateList(UIUtils.getButtonTextColorStates(), colors);
    }

    public static ColorStateList getButtonTextColorStateList(Context context) {
        int[] clientButtonColors = UIUtils.getClientButtonTextColorResList();
        if (clientButtonColors != null && clientButtonColors.length == 3) {
            return new ColorStateList(UIUtils.getButtonTextColorStates(), clientButtonColors);
        }
        if (CommonUtils.isBrandXos()) {
            if (CommonUtils.isLaterThanVersion12_0()) {
                return UIUtils.getXos12ButtonTextColorStateList(context);
            }
            return UIUtils.getXos86ButtonTextColorStateList(context);
        }
        return UIUtils.getHiosButtonTextColorStateList(context);
    }

    public static Bitmap decodeVectorDrawable(Drawable drawable2) {
        Bitmap bitmap = Bitmap.createBitmap((int)drawable2.getIntrinsicWidth(), (int)drawable2.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        canvas.setDrawFilter((DrawFilter)new PaintFlagsDrawFilter(0, 3));
        drawable2.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
        drawable2.draw(canvas);
        return bitmap;
    }
}

