/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.kolun.koluncard;

import android.app.Service;
import android.content.Intent;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.LocaleList;
import android.os.RemoteException;
import android.util.Log;
import com.transsion.kolun.koluncard.IKolunCardInterface;
import com.transsion.kolun.koluncard.IListener;
import com.transsion.kolun.koluncard.KolunCard;
import com.transsion.kolun.koluncard.KolunCardDescription;
import com.transsion.kolun.koluncard.KolunCardProtocol;
import com.transsion.kolun.koluncard.LauncherConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class BaseCardService
extends Service {
    private static final String TAG = "BaseCardService";
    private Interface mInterface = new Interface();

    public IBinder onBind(Intent intent) {
        Log.d((String)TAG, (String)("onBind " + intent));
        return this.mInterface;
    }

    protected abstract void checkPermission(String var1, int var2, String var3);

    protected abstract void updateCardInner(String var1, int var2, int var3);

    protected abstract List<KolunCard> getAvailableCardListInner(String var1, int var2);

    protected abstract void listenInner(String var1, int var2, IListener var3);

    protected abstract void unlistenInner(String var1, int var2, IListener var3);

    protected abstract KolunCard getCardInner(String var1, int var2, int var3);

    protected abstract int[] querySupportedCardIdsInner(String var1, int var2);

    protected abstract void registerClientInner(String var1, int var2, int var3);

    protected abstract List<KolunCardDescription> querySupportedCardDescriptionInner(String var1, int[] var2, LocaleList var3);

    protected abstract List<String> querySupportedCardRequirePermissionListInner(String var1, int[] var2);

    protected abstract boolean isCardFeatureSettingsEnabledInner(String var1);

    protected abstract void setCardFeatureSettingsStateInner(String var1, boolean var2);

    protected abstract LauncherConfig getCardConfigInner(String var1, int var2);

    protected abstract KolunCardProtocol getCardProtocolInner(String var1);

    protected abstract void setCardFeatureSettingsStateExtInner(String var1, boolean var2, int ... var3);

    public static class IBinderList<T extends IInterface> {
        private final Map<IBinder, T> mInterfaceMap = new HashMap<IBinder, T>();
        private final Map<IBinder, MyDeathRecipient> mDeathRecipientMap = new HashMap<IBinder, MyDeathRecipient>();
        private final Callback mCallback;

        public IBinderList(Callback callback) {
            this.mCallback = callback;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<T> getList() {
            Map<IBinder, T> map = this.mInterfaceMap;
            synchronized (map) {
                return new ArrayList<T>(this.mInterfaceMap.values());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(T t) {
            if (t == null) {
                return;
            }
            Map<IBinder, T> map = this.mInterfaceMap;
            synchronized (map) {
                IBinder binder = t.asBinder();
                if (this.mInterfaceMap.containsKey(binder)) {
                    return;
                }
                MyDeathRecipient deathRecipient = new MyDeathRecipient(binder);
                try {
                    binder.linkToDeath((IBinder.DeathRecipient)deathRecipient, 0);
                }
                catch (RemoteException e) {
                    Log.w((String)BaseCardService.TAG, (String)(" LinkToDeath remote exception " + (Object)((Object)e)));
                }
                this.mInterfaceMap.put(binder, t);
                this.mDeathRecipientMap.put(binder, deathRecipient);
            }
            if (this.mCallback != null) {
                this.mCallback.onListChanged();
            }
        }

        public void remove(T t) {
            if (t != null) {
                this.remove(t.asBinder());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            Map<IBinder, T> map = this.mInterfaceMap;
            synchronized (map) {
                this.mInterfaceMap.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove(IBinder binder) {
            if (binder == null) {
                return;
            }
            Map<IBinder, T> map = this.mInterfaceMap;
            synchronized (map) {
                if (!this.mInterfaceMap.containsKey(binder)) {
                    return;
                }
                this.mDeathRecipientMap.remove(binder);
                IInterface t = (IInterface)this.mInterfaceMap.remove(binder);
                Object var3_3 = null;
            }
            if (this.mCallback != null) {
                this.mCallback.onListChanged();
            }
        }

        public static interface Callback {
            public void onListChanged();
        }

        private class MyDeathRecipient
        implements IBinder.DeathRecipient {
            private final IBinder binder;

            MyDeathRecipient(IBinder binder) {
                this.binder = binder;
            }

            public void binderDied() {
                Log.d((String)BaseCardService.TAG, (String)("binderDied " + this.binder));
                IBinderList.this.remove(this.binder);
            }
        }
    }

    class Interface
    extends IKolunCardInterface.Stub {
        Interface() {
        }

        @Override
        public List<KolunCard> getAvailableCardList(String callingPackage) {
            BaseCardService.this.checkPermission(callingPackage, Binder.getCallingUid(), "getAvailableCardList");
            return BaseCardService.this.getAvailableCardListInner(callingPackage, Binder.getCallingUid());
        }

        @Override
        public int[] querySupportedCardIds(String callingPackage) {
            BaseCardService.this.checkPermission(callingPackage, Binder.getCallingUid(), "querySupportedCardIds");
            return BaseCardService.this.querySupportedCardIdsInner(callingPackage, Binder.getCallingUid());
        }

        @Override
        public KolunCard getCard(String callingPackage, int cardId) {
            BaseCardService.this.checkPermission(callingPackage, Binder.getCallingUid(), "getCard");
            return BaseCardService.this.getCardInner(callingPackage, Binder.getCallingUid(), cardId);
        }

        @Override
        public void updateCard(String callingPackage, int cardId) {
            BaseCardService.this.checkPermission(callingPackage, Binder.getCallingUid(), "updateCard");
            BaseCardService.this.updateCardInner(callingPackage, Binder.getCallingUid(), cardId);
        }

        @Override
        public void listen(String callingPackage, IListener listener) {
            BaseCardService.this.checkPermission(callingPackage, Binder.getCallingUid(), "listen");
            BaseCardService.this.listenInner(callingPackage, Binder.getCallingUid(), listener);
        }

        @Override
        public void registerClient(String callingPackage, int versionCode) {
            BaseCardService.this.checkPermission(callingPackage, Binder.getCallingUid(), "registerClient");
            BaseCardService.this.registerClientInner(callingPackage, Binder.getCallingUid(), versionCode);
        }

        @Override
        public void unlisten(String callingPackage, IListener listener) {
            BaseCardService.this.checkPermission(callingPackage, Binder.getCallingUid(), "unlisten");
            BaseCardService.this.unlistenInner(callingPackage, Binder.getCallingUid(), listener);
        }

        @Override
        public List<KolunCardDescription> querySupportedCardDescription(String callingPackage, int[] ids, LocaleList list) {
            BaseCardService.this.checkPermission(callingPackage, Binder.getCallingUid(), "querySupportedCardDescription");
            return BaseCardService.this.querySupportedCardDescriptionInner(callingPackage, ids, list);
        }

        @Override
        public List<String> querySupportedCardRequirePermissionList(String callingPackage, int[] ids) {
            BaseCardService.this.checkPermission(callingPackage, Binder.getCallingUid(), "querySupportedCardRequirePermissionList");
            return BaseCardService.this.querySupportedCardRequirePermissionListInner(callingPackage, ids);
        }

        @Override
        public void setCardFeatureSettingsState(String callingPackage, boolean enabled) {
            BaseCardService.this.checkPermission(callingPackage, Binder.getCallingUid(), "setCardFeatureSettingsState");
            BaseCardService.this.setCardFeatureSettingsStateInner(callingPackage, enabled);
        }

        @Override
        public boolean isCardFeatureSettingsEnabled(String callingPackage) {
            BaseCardService.this.checkPermission(callingPackage, Binder.getCallingUid(), "isCardFeatureSettingsEnabled");
            return BaseCardService.this.isCardFeatureSettingsEnabledInner(callingPackage);
        }

        @Override
        public LauncherConfig getCardConfig(String callingPackage, int id2) {
            BaseCardService.this.checkPermission(callingPackage, Binder.getCallingUid(), "getCardConfig");
            return BaseCardService.this.getCardConfigInner(callingPackage, id2);
        }

        @Override
        public KolunCardProtocol getCardProtocol(String callingPackage) {
            BaseCardService.this.checkPermission(callingPackage, Binder.getCallingUid(), "getCardProtocol");
            return BaseCardService.this.getCardProtocolInner(callingPackage);
        }

        @Override
        public void setCardFeatureSettingsStateExt(String callingPackage, boolean enabled, int[] uncontrolledIds) {
            BaseCardService.this.checkPermission(callingPackage, Binder.getCallingUid(), "setCardFeatureSettingsStateExt");
            BaseCardService.this.setCardFeatureSettingsStateExtInner(callingPackage, enabled, uncontrolledIds);
        }
    }
}

