/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.kolun.koluncard;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.LocaleList;
import android.os.Parcel;
import android.os.RemoteException;
import com.transsion.kolun.koluncard.IListener;
import com.transsion.kolun.koluncard.KolunCard;
import com.transsion.kolun.koluncard.KolunCardDescription;
import com.transsion.kolun.koluncard.KolunCardProtocol;
import com.transsion.kolun.koluncard.LauncherConfig;
import java.util.ArrayList;
import java.util.List;

public interface IKolunCardInterface
extends IInterface {
    public List<KolunCard> getAvailableCardList(String var1) throws RemoteException;

    public int[] querySupportedCardIds(String var1) throws RemoteException;

    public KolunCard getCard(String var1, int var2) throws RemoteException;

    public void updateCard(String var1, int var2) throws RemoteException;

    public void listen(String var1, IListener var2) throws RemoteException;

    public void registerClient(String var1, int var2) throws RemoteException;

    public void unlisten(String var1, IListener var2) throws RemoteException;

    public List<KolunCardDescription> querySupportedCardDescription(String var1, int[] var2, LocaleList var3) throws RemoteException;

    public List<String> querySupportedCardRequirePermissionList(String var1, int[] var2) throws RemoteException;

    public void setCardFeatureSettingsState(String var1, boolean var2) throws RemoteException;

    public boolean isCardFeatureSettingsEnabled(String var1) throws RemoteException;

    public LauncherConfig getCardConfig(String var1, int var2) throws RemoteException;

    public KolunCardProtocol getCardProtocol(String var1) throws RemoteException;

    public void setCardFeatureSettingsStateExt(String var1, boolean var2, int[] var3) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IKolunCardInterface {
        private static final String DESCRIPTOR = "com.transsion.kolun.koluncard.IKolunCardInterface";
        static final int TRANSACTION_getAvailableCardList = 1;
        static final int TRANSACTION_querySupportedCardIds = 2;
        static final int TRANSACTION_getCard = 3;
        static final int TRANSACTION_updateCard = 4;
        static final int TRANSACTION_listen = 5;
        static final int TRANSACTION_registerClient = 6;
        static final int TRANSACTION_unlisten = 7;
        static final int TRANSACTION_querySupportedCardDescription = 8;
        static final int TRANSACTION_querySupportedCardRequirePermissionList = 9;
        static final int TRANSACTION_setCardFeatureSettingsState = 10;
        static final int TRANSACTION_isCardFeatureSettingsEnabled = 11;
        static final int TRANSACTION_getCardConfig = 12;
        static final int TRANSACTION_getCardProtocol = 13;
        static final int TRANSACTION_setCardFeatureSettingsStateExt = 14;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IKolunCardInterface asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IKolunCardInterface) {
                return (IKolunCardInterface)iin;
            }
            return new Proxy(obj);
        }

        public IBinder asBinder() {
            return this;
        }

        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
                case 1: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    List _result = this.getAvailableCardList(_arg0);
                    reply.writeNoException();
                    reply.writeTypedList(_result);
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    int[] _result = this.querySupportedCardIds(_arg0);
                    reply.writeNoException();
                    reply.writeIntArray(_result);
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    KolunCard _result = this.getCard(_arg0, _arg1);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    this.updateCard(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 5: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    IListener _arg1 = IListener.Stub.asInterface(data.readStrongBinder());
                    this.listen(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 6: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    this.registerClient(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 7: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    IListener _arg1 = IListener.Stub.asInterface(data.readStrongBinder());
                    this.unlisten(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 8: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    int[] _arg1 = data.createIntArray();
                    LocaleList _arg2 = 0 != data.readInt() ? (LocaleList)LocaleList.CREATOR.createFromParcel(data) : null;
                    List _result = this.querySupportedCardDescription(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeTypedList(_result);
                    return true;
                }
                case 9: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    int[] _arg1 = data.createIntArray();
                    List _result = this.querySupportedCardRequirePermissionList(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeStringList(_result);
                    return true;
                }
                case 10: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    boolean _arg1 = 0 != data.readInt();
                    this.setCardFeatureSettingsState(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 11: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    boolean _result = this.isCardFeatureSettingsEnabled(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 12: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    LauncherConfig _result = this.getCardConfig(_arg0, _arg1);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 13: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    KolunCardProtocol _result = this.getCardProtocol(_arg0);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 14: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    boolean _arg1 = 0 != data.readInt();
                    int[] _arg2 = data.createIntArray();
                    this.setCardFeatureSettingsStateExt(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(IKolunCardInterface impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static IKolunCardInterface getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements IKolunCardInterface {
            private IBinder mRemote;
            public static IKolunCardInterface sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<KolunCard> getAvailableCardList(String callingPackage) throws RemoteException {
                ArrayList _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        List<KolunCard> list = Stub.getDefaultImpl().getAvailableCardList(callingPackage);
                        return list;
                    }
                    _reply.readException();
                    _result = _reply.createTypedArrayList(KolunCard.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int[] querySupportedCardIds(String callingPackage) throws RemoteException {
                int[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int[] nArray = Stub.getDefaultImpl().querySupportedCardIds(callingPackage);
                        return nArray;
                    }
                    _reply.readException();
                    _result = _reply.createIntArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public KolunCard getCard(String callingPackage, int cardId) throws RemoteException {
                KolunCard _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    _data.writeInt(cardId);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        KolunCard kolunCard = Stub.getDefaultImpl().getCard(callingPackage, cardId);
                        return kolunCard;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? (KolunCard)KolunCard.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updateCard(String callingPackage, int cardId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    _data.writeInt(cardId);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().updateCard(callingPackage, cardId);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void listen(String callingPackage, IListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    _data.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().listen(callingPackage, listener);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerClient(String callingPackage, int versionCode) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    _data.writeInt(versionCode);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().registerClient(callingPackage, versionCode);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unlisten(String callingPackage, IListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    _data.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().unlisten(callingPackage, listener);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<KolunCardDescription> querySupportedCardDescription(String callingPackage, int[] ids, LocaleList list) throws RemoteException {
                ArrayList _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    _data.writeIntArray(ids);
                    if (list != null) {
                        _data.writeInt(1);
                        list.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        List<KolunCardDescription> list2 = Stub.getDefaultImpl().querySupportedCardDescription(callingPackage, ids, list);
                        return list2;
                    }
                    _reply.readException();
                    _result = _reply.createTypedArrayList(KolunCardDescription.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<String> querySupportedCardRequirePermissionList(String callingPackage, int[] ids) throws RemoteException {
                ArrayList _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    _data.writeIntArray(ids);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        List<String> list = Stub.getDefaultImpl().querySupportedCardRequirePermissionList(callingPackage, ids);
                        return list;
                    }
                    _reply.readException();
                    _result = _reply.createStringArrayList();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setCardFeatureSettingsState(String callingPackage, boolean enabled) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    _data.writeInt(enabled ? 1 : 0);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setCardFeatureSettingsState(callingPackage, enabled);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isCardFeatureSettingsEnabled(String callingPackage) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().isCardFeatureSettingsEnabled(callingPackage);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public LauncherConfig getCardConfig(String callingPackage, int id2) throws RemoteException {
                LauncherConfig _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    _data.writeInt(id2);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        LauncherConfig launcherConfig = Stub.getDefaultImpl().getCardConfig(callingPackage, id2);
                        return launcherConfig;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? (LauncherConfig)LauncherConfig.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public KolunCardProtocol getCardProtocol(String callingPackage) throws RemoteException {
                KolunCardProtocol _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        KolunCardProtocol kolunCardProtocol = Stub.getDefaultImpl().getCardProtocol(callingPackage);
                        return kolunCardProtocol;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? (KolunCardProtocol)KolunCardProtocol.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setCardFeatureSettingsStateExt(String callingPackage, boolean enabled, int[] uncontrolledIds) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    _data.writeInt(enabled ? 1 : 0);
                    _data.writeIntArray(uncontrolledIds);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setCardFeatureSettingsStateExt(callingPackage, enabled, uncontrolledIds);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IKolunCardInterface {
        @Override
        public List<KolunCard> getAvailableCardList(String callingPackage) throws RemoteException {
            return null;
        }

        @Override
        public int[] querySupportedCardIds(String callingPackage) throws RemoteException {
            return null;
        }

        @Override
        public KolunCard getCard(String callingPackage, int cardId) throws RemoteException {
            return null;
        }

        @Override
        public void updateCard(String callingPackage, int cardId) throws RemoteException {
        }

        @Override
        public void listen(String callingPackage, IListener listener) throws RemoteException {
        }

        @Override
        public void registerClient(String callingPackage, int versionCode) throws RemoteException {
        }

        @Override
        public void unlisten(String callingPackage, IListener listener) throws RemoteException {
        }

        @Override
        public List<KolunCardDescription> querySupportedCardDescription(String callingPackage, int[] ids, LocaleList list) throws RemoteException {
            return null;
        }

        @Override
        public List<String> querySupportedCardRequirePermissionList(String callingPackage, int[] ids) throws RemoteException {
            return null;
        }

        @Override
        public void setCardFeatureSettingsState(String callingPackage, boolean enabled) throws RemoteException {
        }

        @Override
        public boolean isCardFeatureSettingsEnabled(String callingPackage) throws RemoteException {
            return false;
        }

        @Override
        public LauncherConfig getCardConfig(String callingPackage, int id2) throws RemoteException {
            return null;
        }

        @Override
        public KolunCardProtocol getCardProtocol(String callingPackage) throws RemoteException {
            return null;
        }

        @Override
        public void setCardFeatureSettingsStateExt(String callingPackage, boolean enabled, int[] uncontrolledIds) throws RemoteException {
        }

        public IBinder asBinder() {
            return null;
        }
    }
}

