/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.kolun.koluncard;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.IntentSender;
import android.content.pm.ApplicationInfo;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.Process;
import android.text.TextUtils;
import android.util.Log;
import android.view.ContextThemeWrapper;
import android.view.InflateException;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.PopupMenu;
import android.widget.RemoteViews;
import com.transsion.kolun.cardtemplate.R;
import com.transsion.kolun.koluncard.CardId;
import com.transsion.kolun.koluncard.KolunCardManager;
import com.transsion.kolun.koluncard.PopMenuHelper;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class KolunCard
implements Parcelable {
    public static final String ACTION_UPDATE_CARD = "com.transsion.kolun.card.UPDATE_CARD";
    @CardId
    public static final int NONE_CARD = 0;
    @CardId
    public static final int NEWS_CARD = 1;
    @CardId
    public static final int SCHEDULE_CARD = 2;
    @CardId
    public static final int HEALTH_CARD = 3;
    @CardId
    public static final int ALARM_CARD = 4;
    @CardId
    public static final int WEATHER_CARD = 5;
    @CardId
    public static final int USAGE_STATS_CARD = 6;
    @CardId
    public static final int MUSIC_CARD = 7;
    @CardId
    public static final int MORNING_CARD = 8;
    @CardId
    public static final int MISS_MESSAGE_CARD = 9;
    @CardId
    public static final int CALLS_AND_DATA_USAGE_CARD = 10;
    @CardId
    public static final int SHORTCUT_CARD = 11;
    @CardId
    public static final int TIME_REMINDER_CARD = 12;
    @CardId
    public static final int VIDEO_CARD = 13;
    @CardId
    public static final int LATE_NIGHT_CARD = 14;
    @CardId
    public static final int TRAVEL_WEATHER_CARD = 15;
    @CardId
    public static final int MOVER_CARD = 16;
    @CardId
    public static final int EXCHANGE_CARD = 17;
    @CardId
    public static final int SKILL_CARD = 18;
    public static final int UNDEFINE_CARD_1 = 4097;
    public static final int UNDEFINE_CARD_2 = 4098;
    public static final int UNDEFINE_CARD_3 = 4099;
    public static final int UNDEFINE_CARD_4 = 4100;
    public static final int UNDEFINE_CARD_5 = 4101;
    public static final int UNDEFINE_CARD_6 = 4102;
    public static final int UNDEFINE_CARD_7 = 4103;
    public static final int UNDEFINE_CARD_8 = 4104;
    public static final int UNDEFINE_CARD_9 = 4105;
    public static final int FIRST_CARD_SET_ID = 8192;
    public static final int MAX_CARD_NUM_IN_SET = 100;
    @CardId
    public static final int FLIGHT_CARD = 8192;
    @CardId
    public static final int BIRTHDAY_CARD = 8292;
    @CardId
    public static final int LOAN_CARD = 8392;
    @CardId
    public static final int MEMORY_GALLERY_CARD = 8492;
    @CardId
    public static final int TRAVEL_ALARM_CARD = 8592;
    @CardId
    public static final int LOGISTICS_CARD = 8692;
    @CardId
    public static final int WALLET_CARD = 8792;
    private static final String HOT_PRIORITY = "hot_priority";
    private static final int UNDEFINE_PRIORITY = -1;
    public static final String PARAM_UID = "calling_uid";
    public static final String PARAM_PACKAGE = "calling_package";
    private static final String TAG = "KolunCard";
    public final int cardId;
    public final int order;
    public final String name;
    public final Bundle bundle;
    private ArrayList<Views> mViewsList = new ArrayList();
    private int mPopupMenuRes = -1;
    private int mMenuType = 1;
    private WeakReference<View> mViewCache = null;
    public static final String KEY_ROOT_ID = "key_root_id";
    public static final String KEY_GRADIENT_CONTAINER_ID = "key_gradient_container_id";
    private static Class<?> sClickResponseClass;
    private static Field sFieldFillIntent;
    private static Field sFieldResponse;
    private static Field sFieldActions;
    private static Field sFieldAApplication;
    private static Method sMethodCreateApplicationContext;
    public static final Parcelable.Creator<KolunCard> CREATOR;

    public static List<Integer> getAllCardId() {
        Class<KolunCard> clazz = KolunCard.class;
        Field[] fields = clazz.getFields();
        ArrayList<Integer> cardIdList = new ArrayList<Integer>();
        for (Field f : fields) {
            boolean hasCardIdAnnotation = f.isAnnotationPresent(CardId.class);
            if (!hasCardIdAnnotation) continue;
            try {
                int value = f.getInt(clazz);
                cardIdList.add(value);
            }
            catch (IllegalAccessException e) {
                Log.w((String)TAG, (String)"getAllCardId error");
            }
        }
        return cardIdList;
    }

    public KolunCard(int cardId, int order, String name, Bundle bundle) {
        this.cardId = cardId;
        this.name = name;
        this.order = order;
        this.bundle = bundle;
    }

    public KolunCard(Parcel in) {
        this.cardId = in.readInt();
        this.order = in.readInt();
        this.name = in.readString();
        this.bundle = in.readBundle(this.getClass().getClassLoader());
        in.readList(this.mViewsList, this.getClass().getClassLoader());
    }

    public int getMainCardId() {
        if (this.cardId < 8192) {
            return this.cardId;
        }
        int tmp = this.cardId - 8192;
        int cardSetIndex = tmp / 100;
        return 8192 + cardSetIndex * 100;
    }

    public int getHotPriority() {
        if (this.bundle != null) {
            return this.bundle.getInt(HOT_PRIORITY, -1);
        }
        return -1;
    }

    public boolean isHot() {
        return this.getHotPriority() != -1;
    }

    public void cancelHot() {
        if (this.bundle != null) {
            this.bundle.putInt(HOT_PRIORITY, -1);
        }
    }

    public void setHotPriority(int priority) {
        if (this.bundle != null) {
            this.bundle.putInt(HOT_PRIORITY, priority);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addViews(Views views) {
        KolunCard kolunCard = this;
        synchronized (kolunCard) {
            this.mViewsList.add(views);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearViews() {
        KolunCard kolunCard = this;
        synchronized (kolunCard) {
            this.mViewsList.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Views removeViews(int type, int width, int height) {
        KolunCard kolunCard = this;
        synchronized (kolunCard) {
            Views existViews = this.findViews(type, width, height);
            if (existViews != null) {
                this.mViewsList.remove(existViews);
                return existViews;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Views findViews(int type, int width, int height) {
        KolunCard kolunCard = this;
        synchronized (kolunCard) {
            for (Views views : this.mViewsList) {
                if (views.type != type && views.type != -1 || width != views.width || height != views.height) continue;
                return views;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Views replaceViews(Views views, boolean add) {
        if (views == null) {
            return views;
        }
        KolunCard kolunCard = this;
        synchronized (kolunCard) {
            Views existViews = this.findViews(views.type, views.width, views.height);
            if (existViews != null) {
                this.mViewsList.remove(existViews);
                this.mViewsList.add(views);
            } else if (add) {
                this.mViewsList.add(views);
            }
        }
        return null;
    }

    public Views replaceViews(Views views) {
        return this.replaceViews(views, false);
    }

    public void setPopupMenuRes(int resId) {
        this.mPopupMenuRes = resId;
    }

    public void setMenuType(int type) {
        this.mMenuType = type;
    }

    public Views getSuitableViews(int type) {
        return this.getSuitableViews(type, -1, -1);
    }

    public Views getSuitableViews(int expectedWidth, int expectedHeight) {
        return this.getSuitableViews(-1, expectedWidth, expectedHeight);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Views getSuitableViews(int type, int expectedWidth, int expectedHeight) {
        Views optionalCard = null;
        float ratioDiff = 1.0f;
        KolunCard kolunCard = this;
        synchronized (kolunCard) {
            for (Views views : this.mViewsList) {
                float ratio;
                if (type != -1 && type != views.type) continue;
                if (expectedHeight == views.height && expectedWidth == views.width || expectedWidth == -1 && expectedHeight == views.height || expectedHeight == -1 && expectedWidth == views.width || expectedWidth == -1 && expectedHeight == -1) {
                    return views;
                }
                float exceptRatio = expectedWidth == 0 ? 0.0f : (float)((double)expectedHeight * 1.0 / (double)expectedWidth);
                if ((int)exceptRatio != (int)(ratio = views.getRatio()) || !((ratioDiff = Math.abs(exceptRatio - ratio)) < 1.0f)) continue;
                optionalCard = views;
            }
        }
        return optionalCard;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<Views> getViewsList() {
        ArrayList<Views> list = new ArrayList<Views>();
        KolunCard kolunCard = this;
        synchronized (kolunCard) {
            this.mViewsList.forEach(card -> list.add((Views)card));
        }
        return list;
    }

    public View apply(Context context, ViewGroup viewGroup, int width, int height) {
        return this.apply(context, viewGroup, -1, width, height, true);
    }

    public View apply(Context context, ViewGroup viewGroup, int width, int height, boolean isShowPopupMenu) {
        return this.apply(context, viewGroup, -1, width, height, isShowPopupMenu);
    }

    public View apply(Context context, ViewGroup viewGroup) {
        return this.apply(context, viewGroup, -1);
    }

    public View apply(Context context, ViewGroup viewGroup, int type) {
        return this.apply(context, viewGroup, type, true);
    }

    public View apply(Context context, ViewGroup viewGroup, int type, boolean isShowPopupMenu) {
        return this.apply(context, viewGroup, type, -1, -1, isShowPopupMenu);
    }

    public View apply(Context context, ViewGroup viewGroup, boolean isShowPopupMenu) {
        return this.apply(context, viewGroup, -1, -1, isShowPopupMenu);
    }

    public View apply(Context context, ViewGroup viewGroup, int type, int width, int height, boolean isShowPopupMenu) {
        if (context == null || viewGroup == null) {
            return null;
        }
        Views views = this.getSuitableViews(type, width, height);
        if (views == null) {
            return null;
        }
        if (views.remoteViews == null) {
            Log.w((String)TAG, (String)("cardId: " + this.cardId + " remoteview is null"));
            return null;
        }
        View tmpView = null;
        try {
            this.cookRemoteViews(context, views.remoteViews);
            tmpView = views.remoteViews.apply(context, viewGroup);
        }
        catch (Resources.NotFoundException | InflateException e) {
            Log.d((String)TAG, (String)("warning in apply maybe assistant is disabled or not exist" + e));
        }
        if (tmpView == null) {
            return null;
        }
        if (!KolunCardManager.isServiceAvailable(context)) {
            Log.d((String)TAG, (String)"assistant package not found");
            if (this.mViewCache != null) {
                return (View)this.mViewCache.get();
            }
            return null;
        }
        View view = tmpView;
        ViewGroup.LayoutParams params = view.getLayoutParams();
        float density = context.getResources().getDisplayMetrics().density;
        if (width != -1) {
            params.width = (int)((double)((float)width * density) + 0.5);
        }
        if (height != -1) {
            params.height = (int)((double)((float)height * density) + 0.5);
        }
        view.setLayoutParams(params);
        if (views.cardPopupMenuList.isEmpty()) {
            return view;
        }
        this.addPopMenu(context, views, view, isShowPopupMenu);
        this.mViewCache = new WeakReference<View>(view);
        return view;
    }

    private void addPopMenu(Context context, Views views, View view, boolean isShowPopupMenu) {
        HashMap<View, ArrayList> menuMap = new HashMap<View, ArrayList>();
        views.cardPopupMenuList.forEach(cardPopupMenu -> {
            ArrayList<CardPopupMenu> menus;
            View targetView = view.findViewById(cardPopupMenu.targetViewId);
            if (targetView == null) {
                Log.w((String)TAG, (String)("can't find view id=" + cardPopupMenu.targetViewId));
                return;
            }
            if (!isShowPopupMenu) {
                targetView.setVisibility(4);
            }
            if ((menus = (ArrayList<CardPopupMenu>)menuMap.get(targetView)) == null) {
                menus = new ArrayList<CardPopupMenu>();
                menuMap.put(targetView, menus);
            }
            menus.add((CardPopupMenu)cardPopupMenu);
        });
        if (menuMap.isEmpty()) {
            return;
        }
        if (!isShowPopupMenu) {
            return;
        }
        if (this.mMenuType == 0) {
            int osPopupMenuStyleId = context.getResources().getIdentifier("OsPopupMenuStyle", "style", context.getPackageName());
            menuMap.forEach((targetView, cardPopupMenuList) -> targetView.setOnClickListener(v -> {
                PopupMenu tmpMenu = null;
                if (osPopupMenuStyleId > 0) {
                    ContextThemeWrapper wrapperContext = new ContextThemeWrapper(context, osPopupMenuStyleId);
                    tmpMenu = new PopupMenu((Context)wrapperContext, targetView);
                } else {
                    tmpMenu = new PopupMenu(context, targetView);
                }
                PopupMenu menu = tmpMenu;
                for (CardPopupMenu cardPopupMenu : cardPopupMenuList) {
                    MenuItem item = menu.getMenu().add((CharSequence)cardPopupMenu.label);
                    item.setOnMenuItemClickListener(i -> {
                        this.startIntentSenderUnchecked(v.getContext(), cardPopupMenu.pendingIntent);
                        return true;
                    });
                }
                menu.show();
            }));
        } else {
            int listPopupMenuStyleId = context.getResources().getIdentifier("OsListPopupWindowStyle", "style", context.getPackageName());
            Log.d((String)TAG, (String)("inflate listPopupMenuStyleId: " + listPopupMenuStyleId));
            if (listPopupMenuStyleId <= 0) {
                listPopupMenuStyleId = R.style.OsListPopupWindowStyle;
                Log.d((String)TAG, (String)("sdk listPopupMenuStyleId: " + listPopupMenuStyleId));
            }
            int finalListPopupMenuStyleId = listPopupMenuStyleId;
            menuMap.forEach((targetView, cardPopupMenuList) -> targetView.setOnClickListener(v -> {
                AdapterView.OnItemClickListener listener = (parent, view1, position, id2) -> {
                    this.startIntentSenderUnchecked(view1.getContext(), ((CardPopupMenu)cardPopupMenuList.get((int)position)).pendingIntent);
                    PopMenuHelper.closeAllPopMenu();
                };
                PopMenuHelper.CardPopupMenu popMenu = PopMenuHelper.create(context, targetView, cardPopupMenuList, listener, finalListPopupMenuStyleId);
                popMenu.show();
            }));
        }
    }

    private void startIntentSenderUnchecked(Context context, PendingIntent pendingIntent) {
        try {
            Intent intent = new Intent();
            intent.putExtra(PARAM_UID, Process.myUid());
            intent.putExtra(PARAM_PACKAGE, context.getPackageName());
            context.startIntentSender(pendingIntent.getIntentSender(), intent, 0, 0, 0, null);
        }
        catch (IntentSender.SendIntentException e) {
            Log.e((String)TAG, (String)"Cannot send pending intent: ", (Throwable)e);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Cannot send pending intent due to unknown exception: ", (Throwable)e);
        }
    }

    public List<CardPopupMenu> getPopupMenuList() {
        Views views = this.mViewsList.get(0);
        if (views == null) {
            return null;
        }
        return views.cardPopupMenuList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Drawable getIcon(Context context) {
        if (sFieldActions == null) {
            return null;
        }
        if (this.mViewsList.isEmpty()) {
            return null;
        }
        Views views = this.mViewsList.get(0);
        if (views == null) {
            return null;
        }
        RemoteViews remoteViews = views.remoteViews;
        Context resourceContext = this.getResourceContext(context, remoteViews);
        if (resourceContext == null) {
            return null;
        }
        int viewId = resourceContext.getResources().getIdentifier("card_icon", "id", resourceContext.getPackageName());
        if (viewId < 0) {
            Log.e((String)TAG, (String)"Can't find icon view id");
            return null;
        }
        Parcel parcel = Parcel.obtain();
        try {
            ArrayList actionList = (ArrayList)sFieldActions.get(remoteViews);
            if (actionList == null || actionList.isEmpty()) {
                Drawable drawable2 = null;
                return drawable2;
            }
            for (Parcelable parcelable : actionList) {
                parcel.setDataPosition(0);
                parcelable.writeToParcel(parcel, 0);
                parcel.setDataPosition(0);
                try {
                    int id2 = parcel.readInt();
                    if (id2 != viewId) continue;
                    int byteSize = parcel.readInt();
                    parcel.setDataPosition(4);
                    byte[] bytes = new byte[byteSize];
                    parcel.readByteArray(bytes);
                    parcel.readByte();
                    String method = new String(bytes, "utf-8");
                    if (!"setImageResource".equals(method)) continue;
                    parcel.readInt();
                    int resId = parcel.readInt();
                    Drawable drawable3 = resourceContext.getResources().getDrawable(resId);
                    return drawable3;
                }
                catch (Exception e) {
                    Log.e((String)TAG, (String)("This action is not the target " + e));
                }
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("Can't get icon " + e));
        }
        finally {
            parcel.recycle();
        }
        return null;
    }

    public int getConfigId(int def) {
        return this.bundle.getInt("config_id", def);
    }

    public int getConfigId() {
        return this.bundle.getInt("config_id", this.cardId);
    }

    public int getConfigDefPriority() {
        return this.bundle.getInt("def_priority", this.order);
    }

    public int getConfigMajorPriority() {
        return this.bundle.getInt("major_priority", this.getHotPriority());
    }

    public String getConfigSlot() {
        return this.bundle.getString("config_slot", "T_0M_0M");
    }

    public void setConfigId(int configId) {
        this.bundle.putInt("config_id", configId);
    }

    public void setConfigDefPriority(int defPriority) {
        this.bundle.putInt("def_priority", defPriority);
    }

    public void setConfigMajorPriority(int majorPriority) {
        this.bundle.putInt("major_priority", majorPriority);
    }

    public void setConfigSlot(String slot) {
        this.bundle.putString("config_slot", slot);
    }

    int getRootId() {
        return this.bundle.getInt(KEY_ROOT_ID, -1);
    }

    int getGradientId() {
        return this.bundle.getInt(KEY_GRADIENT_CONTAINER_ID, -1);
    }

    private Context getResourceContext(Context context, RemoteViews remoteViews) {
        if (context != null) {
            try {
                ApplicationInfo applicationInfo = (ApplicationInfo)sFieldAApplication.get(remoteViews);
                return this.getContextForResources(context, applicationInfo);
            }
            catch (IllegalAccessException e) {
                Log.e((String)TAG, (String)("Failed to create resource context " + e));
            }
        }
        return null;
    }

    private Context getContextForResources(Context context, ApplicationInfo applicationInfo) {
        if (applicationInfo != null) {
            try {
                return (Context)sMethodCreateApplicationContext.invoke((Object)context, applicationInfo, 4);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("Failed to create resource context " + e));
            }
        } else {
            Log.w((String)TAG, (String)"Failed to create resource context applicationInfo is null");
        }
        return null;
    }

    private void cookRemoteViews(Context context, RemoteViews remoteViews) {
        block7: {
            if (context == null || remoteViews == null) {
                return;
            }
            if (sFieldResponse == null || sFieldFillIntent == null || sFieldResponse == null || sFieldActions == null) {
                return;
            }
            try {
                List actionList = (List)sFieldActions.get(remoteViews);
                if (actionList == null) break block7;
                for (Object o : actionList) {
                    Object response;
                    if (!sClickResponseClass.isInstance(o) || (response = sFieldResponse.get(o)) == null) continue;
                    Intent fillIntent = (Intent)sFieldFillIntent.get(response);
                    if (fillIntent == null) {
                        fillIntent = new Intent();
                    }
                    if (!fillIntent.hasExtra(PARAM_PACKAGE)) {
                        fillIntent.putExtra(PARAM_PACKAGE, context.getPackageName());
                        fillIntent.putExtra(PARAM_UID, Process.myUid());
                        sFieldFillIntent.set(o, fillIntent);
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                Log.w((String)TAG, (String)("Failed to cook remoteView " + e));
            }
        }
    }

    public int describeContents() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToParcel(Parcel parcel, int i) {
        KolunCard kolunCard = this;
        synchronized (kolunCard) {
            parcel.writeInt(this.cardId);
            parcel.writeInt(this.order);
            parcel.writeString(this.name);
            parcel.writeBundle(this.bundle);
            parcel.writeList(this.mViewsList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("KolunCard { ").append(this.cardId).append(" ").append(this.name).append(" ");
        KolunCard kolunCard = this;
        synchronized (kolunCard) {
            if (!this.mViewsList.isEmpty()) {
                sb.append("Views:");
                this.mViewsList.forEach(views -> {
                    sb.append(views);
                    sb.append(" ");
                });
            }
        }
        sb.append(" }");
        return sb.toString();
    }

    static {
        try {
            sFieldActions = RemoteViews.class.getDeclaredField("mActions");
            sFieldAApplication = RemoteViews.class.getDeclaredField("mApplication");
            sMethodCreateApplicationContext = Context.class.getDeclaredMethod("createApplicationContext", ApplicationInfo.class, Integer.TYPE);
            sFieldActions.setAccessible(true);
            sFieldAApplication.setAccessible(true);
            sMethodCreateApplicationContext.setAccessible(true);
        }
        catch (NoSuchFieldException | NoSuchMethodException e) {
            Log.w((String)TAG, (String)("Failed to reflect remoteView " + e));
        }
        CREATOR = new Parcelable.Creator<KolunCard>(){

            public KolunCard createFromParcel(Parcel in) {
                return new KolunCard(in);
            }

            public KolunCard[] newArray(int size) {
                return new KolunCard[size];
            }
        };
    }

    public static class Views
    implements Parcelable {
        public final int type;
        public final int width;
        public final int height;
        public final Bundle bundle;
        public final RemoteViews remoteViews;
        protected final ArrayList<CardPopupMenu> cardPopupMenuList = new ArrayList();
        public static final Parcelable.Creator<Views> CREATOR = new Parcelable.Creator<Views>(){

            public Views createFromParcel(Parcel in) {
                return new Views(in);
            }

            public Views[] newArray(int size) {
                return new Views[size];
            }
        };

        public Views(int type, int width, int height, Bundle bundle, RemoteViews remoteViews) {
            this.type = type;
            this.width = width;
            this.height = height;
            this.bundle = bundle;
            this.remoteViews = remoteViews;
        }

        public void addPopupMenu(int viewId, String label, PendingIntent clickIntent) {
            CardPopupMenu menu = new CardPopupMenu(viewId, label, clickIntent);
            CardPopupMenu existCardPopupMenu = null;
            for (CardPopupMenu popupMenu : this.cardPopupMenuList) {
                if (popupMenu.targetViewId != viewId) continue;
                existCardPopupMenu = popupMenu;
                break;
            }
            if (existCardPopupMenu != null && TextUtils.equals((CharSequence)existCardPopupMenu.label, (CharSequence)label)) {
                this.cardPopupMenuList.remove(existCardPopupMenu);
            }
            this.cardPopupMenuList.add(menu);
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public float getRatio() {
            if (this.width == 0 || this.width == -1 || this.height == -1) {
                return 0.0f;
            }
            return (float)((double)this.height * 1.0 / (double)this.width);
        }

        protected Views(Parcel in) {
            this.type = in.readInt();
            this.width = in.readInt();
            this.height = in.readInt();
            this.bundle = in.readBundle(this.getClass().getClassLoader());
            this.remoteViews = (RemoteViews)in.readParcelable(RemoteViews.class.getClassLoader());
            in.readList(this.cardPopupMenuList, this.getClass().getClassLoader());
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("{ ").append(this.type).append(" [").append(this.width).append(", ").append(this.height).append(" ").append(this.bundle).append(" ").append(this.remoteViews).append(" ");
            if (!this.cardPopupMenuList.isEmpty()) {
                sb.append("PopupMenu: ");
                this.cardPopupMenuList.forEach(cardPopupMenu -> {
                    sb.append(cardPopupMenu.toString());
                    sb.append(" ");
                });
            }
            sb.append("}");
            return sb.toString();
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.type);
            dest.writeInt(this.width);
            dest.writeInt(this.height);
            dest.writeBundle(this.bundle);
            dest.writeParcelable((Parcelable)this.remoteViews, flags);
            dest.writeList(this.cardPopupMenuList);
        }
    }

    public static class CardPopupMenu
    implements Parcelable {
        public final int targetViewId;
        public final String label;
        public final PendingIntent pendingIntent;
        public static final Parcelable.Creator<CardPopupMenu> CREATOR = new Parcelable.Creator<CardPopupMenu>(){

            public CardPopupMenu createFromParcel(Parcel in) {
                return new CardPopupMenu(in);
            }

            public CardPopupMenu[] newArray(int size) {
                return new CardPopupMenu[size];
            }
        };

        protected CardPopupMenu(int targetViewId, String label, PendingIntent pendingIntent) {
            this.targetViewId = targetViewId;
            this.label = label;
            this.pendingIntent = pendingIntent;
        }

        protected CardPopupMenu(Parcel in) {
            this.targetViewId = in.readInt();
            this.label = in.readString();
            this.pendingIntent = PendingIntent.readPendingIntentOrNullFromParcel((Parcel)in);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            return sb.append("{ ").append(String.format("0x%x", this.targetViewId)).append(" ").append(this.label).append(" }").toString();
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.targetViewId);
            dest.writeString(this.label);
            PendingIntent.writePendingIntentOrNullToParcel((PendingIntent)this.pendingIntent, (Parcel)dest);
        }
    }

    public static interface MenuType {
        public static final int POP_MENU = 0;
        public static final int POP_WINDOW_DEFAULT = 1;
    }

    public static interface ShapeType {
        public static final int UNDEFINE = -1;
        public static final int LANDSCAPE = 0;
        public static final int LANDSCAPE_LIMIT_HEIGHT = 1;
        public static final int WRAP_CONTENT = 2;
        public static final int MATCH_PARENT = 3;
    }
}

