/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.kolun.koluncard;

import android.content.Intent;
import android.os.Bundle;
import android.os.LocaleList;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import com.transsion.kolun.koluncard.ICardSettings;
import java.util.Locale;

public class KolunCardDescription
implements Parcelable {
    public static final int CATEGORY_OTHERS = 1501;
    public static final int CATEGORY_LIFE = 1502;
    public static final int CATEGORY_TRANS = 1503;
    public static final String KEY_INVISIBLE = "invisible";
    public final int cardId;
    public final String name;
    public final String description;
    public final Locale locale;
    public final String category;
    public final int categoryId;
    public Intent activityIntent;
    private final LocaleList mLocaleList;
    private final Bundle mBundle;
    private final ICardSettings mCardSettings;
    private static final String TAG = "KolunCardDescription";
    public static final String KEY_TITLE_ICON = "key_title_icon";
    public static final String KEY_PREVIEW_ICON = "key_preview_img";
    public static final Parcelable.Creator<KolunCardDescription> CREATOR = new Parcelable.Creator<KolunCardDescription>(){

        public KolunCardDescription createFromParcel(Parcel in) {
            return new KolunCardDescription(in);
        }

        public KolunCardDescription[] newArray(int size) {
            return new KolunCardDescription[size];
        }
    };

    public KolunCardDescription(int cardId, String name, String description, LocaleList localeList, String category, int categoryId, Intent activityIntent, ICardSettings cardSettings, Bundle bundle) {
        this.cardId = cardId;
        this.name = name;
        this.description = description;
        this.locale = localeList.get(0);
        this.mLocaleList = localeList;
        this.category = category;
        this.categoryId = categoryId;
        this.activityIntent = activityIntent;
        this.mCardSettings = cardSettings;
        this.mBundle = bundle;
    }

    public KolunCardDescription(Parcel in) {
        this.cardId = in.readInt();
        this.name = in.readString();
        this.description = in.readString();
        this.mLocaleList = (LocaleList)in.readParcelable(LocaleList.class.getClassLoader());
        this.category = in.readString();
        this.categoryId = in.readInt();
        this.activityIntent = (Intent)in.readParcelable(Intent.class.getClassLoader());
        this.locale = this.mLocaleList.get(0);
        this.mCardSettings = ICardSettings.Stub.asInterface(in.readStrongBinder());
        this.mBundle = in.readBundle(this.getClass().getClassLoader());
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.cardId);
        dest.writeString(this.name);
        dest.writeString(this.description);
        dest.writeParcelable((Parcelable)this.mLocaleList, flags);
        dest.writeString(this.category);
        dest.writeInt(this.categoryId);
        dest.writeParcelable((Parcelable)this.activityIntent, flags);
        dest.writeStrongBinder(this.mCardSettings.asBinder());
        dest.writeBundle(this.mBundle);
    }

    public String toString() {
        return "KolunCardDescription{" + this.cardId + " " + this.name + ": " + this.description + " in " + this.locale + "}";
    }

    public boolean isInvisible() {
        if (this.mBundle != null) {
            return this.mBundle.getBoolean(KEY_INVISIBLE, false);
        }
        return false;
    }

    public boolean isEnabled() {
        try {
            return this.mCardSettings.isEnabled(this.cardId);
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public boolean toggle(boolean enable) {
        try {
            return this.mCardSettings.toggle(this.cardId, enable);
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public String getTitleIconAddress() {
        if (this.mBundle != null) {
            return this.mBundle.getString(KEY_TITLE_ICON, null);
        }
        return null;
    }

    public String getServicePreviewAddress() {
        if (this.mBundle != null) {
            return this.mBundle.getString(KEY_PREVIEW_ICON, null);
        }
        return null;
    }
}

