/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.kolun.koluncard;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.os.IBinder;
import android.os.LocaleList;
import android.os.PowerManager;
import android.os.RemoteException;
import android.util.Log;
import androidx.annotation.NonNull;
import com.transsion.kolun.koluncard.IInterfaceProxy;
import com.transsion.kolun.koluncard.IKolunCardInterface;
import com.transsion.kolun.koluncard.IListener;
import com.transsion.kolun.koluncard.KolunCard;
import com.transsion.kolun.koluncard.KolunCardDescription;
import com.transsion.kolun.koluncard.KolunCardProtocol;
import com.transsion.kolun.koluncard.LauncherConfig;
import com.transsion.kolun.koluncard.PackageBroadcastReceiver;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class KolunCardManager {
    private static final String TAG = "KolunCardManager";
    private static boolean DEBUG = Log.isLoggable((String)"koluncard", (int)4);
    public static final int FLAG_RESUME = 1;
    public static final int FLAG_UPDATE = 2;
    public static final int FLAG_TIME_TICK = 4;
    public static final int FLAG_TIME_CHANGED = 8;
    public static final int FLAG_UPDATE_BROADCAST = 22;
    public static final String ACTION_REQUIRE_PERMISSION = "com.transsion.kolun.assistant.permissionActivity";
    private static final ComponentName SERVICE_COM = new ComponentName("com.transsion.kolun.assistant", "com.transsion.kolun.assistant.widget.CardWidgetService");
    private static final Intent SERVICE_INTENT = new Intent().setComponent(SERVICE_COM);
    private final Context mContext;
    private final Callback mCallback;
    private final Cache mCache;
    private final int mConnectFlags;
    private BroadcastReceiver mUpdateBroadcastReceiver;
    private IInterfaceProxy<IKolunCardInterface> mRemoteInterface = new IInterfaceProxy<IKolunCardInterface>(IKolunCardInterface.class);
    private boolean mHasPendingUpdateRequest = false;
    private final ServiceConnection mServiceConnection = new ServiceConnection(){

        public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
            block5: {
                Log.i((String)KolunCardManager.TAG, (String)"onServiceConnected ");
                KolunCardManager.this.mRemoteInterface.bindInterface(IKolunCardInterface.Stub.asInterface(iBinder));
                try {
                    ((IKolunCardInterface)KolunCardManager.this.mRemoteInterface.getInterface()).registerClient(KolunCardManager.this.mContext.getPackageName(), 23);
                    ((IKolunCardInterface)KolunCardManager.this.mRemoteInterface.getInterface()).listen(KolunCardManager.this.mContext.getPackageName(), LocalListener.getInstance());
                }
                catch (RemoteException e) {
                    Log.i((String)KolunCardManager.TAG, (String)("Failed to registerClient " + (Object)((Object)e)));
                }
                catch (NullPointerException e) {
                    if (KolunCardManager.this.mRemoteInterface.isConnected()) break block5;
                    Log.i((String)KolunCardManager.TAG, (String)("Failed to get interface " + e));
                    KolunCardManager.this.mContext.unbindService(KolunCardManager.this.mServiceConnection);
                    return;
                }
            }
            if (KolunCardManager.this.mHasPendingUpdateRequest) {
                KolunCardManager.this.mHasPendingUpdateRequest = false;
                KolunCardManager.this.updateCard(-1);
            }
            if (KolunCardManager.this.mCallback != null) {
                KolunCardManager.this.mCallback.onServiceConnected();
            }
        }

        public void onBindingDied(ComponentName name) {
            Log.i((String)KolunCardManager.TAG, (String)"onBindingDied ");
            KolunCardManager.this.mContext.unbindService(KolunCardManager.this.mServiceConnection);
        }

        public void onServiceDisconnected(ComponentName componentName) {
            Log.i((String)KolunCardManager.TAG, (String)"onServiceDisconnected ");
            if (KolunCardManager.this.mCallback != null) {
                KolunCardManager.this.mCallback.onServiceDisconnected();
            }
        }
    };

    public KolunCardManager(Context context, Callback callback, int flags) {
        this.mContext = context.getApplicationContext();
        this.mCallback = callback;
        this.mConnectFlags = flags;
        this.mCache = new Cache();
        this.registInstallApp();
    }

    public KolunCardManager(Context context, Callback callback) {
        this.mContext = context.getApplicationContext();
        this.mCallback = callback;
        this.mConnectFlags = 23;
        this.mCache = new Cache();
        this.registInstallApp();
    }

    private void registInstallApp() {
        PackageBroadcastReceiver.connect(this.mContext).registerCallBack(new PackageBroadcastReceiver.PackageChange(){

            @Override
            public void removed() {
                if (((KolunCardManager)KolunCardManager.this).mCache.mAvailableCardList != null) {
                    ((KolunCardManager)KolunCardManager.this).mCache.mAvailableCardList.clear();
                }
            }

            @Override
            public void replaced() {
                KolunCardManager.this.onResume();
            }
        });
    }

    public boolean connect() {
        return this.connect("client");
    }

    public void disconnect() {
        this.disconnect("client");
    }

    public void onResume() {
        if ((this.mConnectFlags & 1) == 1) {
            this.connect("onResume");
        }
        if (this.mUpdateBroadcastReceiver == null && (this.mConnectFlags & 0x1E) != 0) {
            this.mUpdateBroadcastReceiver = new BroadcastReceiver(){

                public void onReceive(Context context, Intent intent) {
                    String action;
                    PowerManager powerManager = (PowerManager)context.getSystemService("power");
                    boolean isInteractive = powerManager.isInteractive();
                    if (DEBUG) {
                        Log.d((String)KolunCardManager.TAG, (String)("onReceive " + intent + " isInteractive: " + isInteractive));
                    }
                    if (!isInteractive) {
                        return;
                    }
                    String string2 = action = intent == null ? null : intent.getAction();
                    if ("android.intent.action.TIME_TICK".equals(action) && (KolunCardManager.this.mConnectFlags & 4) != 0 || "android.intent.action.TIME_SET".equals(action) && (KolunCardManager.this.mConnectFlags & 8) != 0 || "com.transsion.kolun.card.UPDATE_CARD".equals(action) && (KolunCardManager.this.mConnectFlags & 0x16) != 0) {
                        if (!KolunCardManager.this.mRemoteInterface.isConnected()) {
                            KolunCardManager.this.connect("broadcast " + action);
                            KolunCardManager.this.mHasPendingUpdateRequest = true;
                        } else {
                            KolunCardManager.this.updateCard(-1);
                        }
                    }
                }
            };
            IntentFilter filter = new IntentFilter();
            if ((this.mConnectFlags & 4) != 0) {
                filter.addAction("android.intent.action.TIME_TICK");
            }
            if ((this.mConnectFlags & 8) != 0) {
                filter.addAction("android.intent.action.TIME_SET");
            }
            if ((this.mConnectFlags & 0x16) != 0) {
                filter.addAction("com.transsion.kolun.card.UPDATE_CARD");
            }
            if (filter.countActions() > 0) {
                if (DEBUG) {
                    Log.d((String)TAG, (String)"registerReceiver");
                }
                this.mContext.registerReceiver(this.mUpdateBroadcastReceiver, filter);
            } else {
                this.mUpdateBroadcastReceiver = null;
            }
        }
    }

    public void onPause() {
        if (this.mUpdateBroadcastReceiver != null) {
            if (DEBUG) {
                Log.d((String)TAG, (String)"unregisterReceiver ");
            }
            this.mContext.unregisterReceiver(this.mUpdateBroadcastReceiver);
            this.mUpdateBroadcastReceiver = null;
        }
    }

    public List<KolunCard> getAvailableCardList() {
        if (this.mRemoteInterface.isConnected()) {
            try {
                this.mCache.mAvailableCardList = this.mRemoteInterface.getInterface().getAvailableCardList(this.mContext.getPackageName());
                return this.mCache.mAvailableCardList;
            }
            catch (RemoteException | SecurityException e) {
                Log.w((String)TAG, (String)("Failed to invoke getAvailableCardList " + e));
            }
        } else {
            Log.e((String)TAG, (String)"Failed to invoke getAvailableCardList, service is disconnected");
        }
        return !KolunCardManager.isServiceAvailable(this.mContext) ? null : this.mCache.mAvailableCardList;
    }

    public int[] querySupportedCardIds() {
        if (this.mRemoteInterface.isConnected()) {
            try {
                this.mCache.mSupportedCardIds = this.mRemoteInterface.getInterface().querySupportedCardIds(this.mContext.getPackageName());
                return this.mCache.mSupportedCardIds;
            }
            catch (RemoteException | SecurityException e) {
                Log.w((String)TAG, (String)("Failed to invoke querySupportedCardIds " + e));
            }
        } else {
            Log.e((String)TAG, (String)"Failed to invoke querySupportedCardIds, service is disconnected");
        }
        return this.mCache.mSupportedCardIds;
    }

    public KolunCard getCard(int cardId) {
        if (this.mRemoteInterface.isConnected()) {
            try {
                return this.mRemoteInterface.getInterface().getCard(this.mContext.getPackageName(), cardId);
            }
            catch (RemoteException | SecurityException e) {
                Log.w((String)TAG, (String)("Failed to invoke getCard " + e));
            }
        } else {
            Log.e((String)TAG, (String)"Failed to invoke getCard, service is disconnected");
        }
        return null;
    }

    public void updateCard(int cardId) {
        if (this.mRemoteInterface.isConnected()) {
            try {
                this.mRemoteInterface.getInterface().updateCard(this.mContext.getPackageName(), cardId);
            }
            catch (RemoteException | SecurityException e) {
                Log.w((String)TAG, (String)("Failed to invoke updateCard " + e));
            }
        } else {
            if ((this.mConnectFlags & 2) != 0) {
                this.connect("update");
                this.mHasPendingUpdateRequest = true;
            }
            Log.e((String)TAG, (String)"Failed to invoke updateCard, service is disconnected");
        }
    }

    public void listen(IListener listener) {
        LocalListener.getInstance().register(listener);
    }

    public void unlisten(IListener listener) {
        LocalListener.getInstance().unlisten(listener);
    }

    public List<KolunCardDescription> querySupportedCardDescription(int[] ids, LocaleList localeList) {
        if (this.mRemoteInterface.isConnected()) {
            try {
                return this.mRemoteInterface.getInterface().querySupportedCardDescription(this.mContext.getPackageName(), ids, localeList);
            }
            catch (RemoteException | SecurityException e) {
                Log.w((String)TAG, (String)("Failed to invoke querySupportedCardDescription " + e));
            }
        } else {
            Log.e((String)TAG, (String)"Failed to invoke querySupportedCardDescription, service is disconnected");
        }
        return new ArrayList<KolunCardDescription>();
    }

    public List<KolunCardDescription> querySupportedCardDescription(int[] ids, Locale locale) {
        if (this.mRemoteInterface.isConnected()) {
            try {
                return this.mRemoteInterface.getInterface().querySupportedCardDescription(this.mContext.getPackageName(), ids, new LocaleList(new Locale[]{locale}));
            }
            catch (RemoteException | SecurityException e) {
                Log.w((String)TAG, (String)("Failed to invoke querySupportedCardDescription " + e));
            }
        } else {
            Log.e((String)TAG, (String)"Failed to invoke querySupportedCardDescription, service is disconnected");
        }
        return new ArrayList<KolunCardDescription>();
    }

    public List<KolunCardDescription> querySupportedCardDescription(int[] ids) {
        if (this.mRemoteInterface.isConnected()) {
            try {
                return this.mRemoteInterface.getInterface().querySupportedCardDescription(this.mContext.getPackageName(), ids, LocaleList.getEmptyLocaleList());
            }
            catch (RemoteException | SecurityException e) {
                Log.w((String)TAG, (String)("Failed to invoke querySupportedCardDescription " + e));
            }
        } else {
            Log.e((String)TAG, (String)"Failed to invoke querySupportedCardDescription, service is disconnected");
        }
        return new ArrayList<KolunCardDescription>();
    }

    public List<KolunCardDescription> querySupportedCardDescription(Locale locale) {
        if (this.mRemoteInterface.isConnected()) {
            try {
                return this.mRemoteInterface.getInterface().querySupportedCardDescription(this.mContext.getPackageName(), null, new LocaleList(new Locale[]{locale}));
            }
            catch (RemoteException | SecurityException e) {
                Log.w((String)TAG, (String)("Failed to invoke querySupportedCardDescription " + e));
            }
        } else {
            Log.e((String)TAG, (String)"Failed to invoke querySupportedCardDescription, service is disconnected");
        }
        return new ArrayList<KolunCardDescription>();
    }

    public List<KolunCardDescription> querySupportedCardDescription() {
        if (this.mRemoteInterface.isConnected()) {
            try {
                return this.mRemoteInterface.getInterface().querySupportedCardDescription(this.mContext.getPackageName(), null, LocaleList.getEmptyLocaleList());
            }
            catch (RemoteException | SecurityException e) {
                Log.w((String)TAG, (String)("Failed to invoke querySupportedCardDescription " + e));
            }
        } else {
            Log.e((String)TAG, (String)"Failed to invoke querySupportedCardDescription, service is disconnected");
        }
        return new ArrayList<KolunCardDescription>();
    }

    public List<String> querySupportedCardRequirePermissionList(int ... ids) {
        if (this.mRemoteInterface.isConnected()) {
            try {
                return this.mRemoteInterface.getInterface().querySupportedCardRequirePermissionList(this.mContext.getPackageName(), ids);
            }
            catch (RemoteException | SecurityException e) {
                Log.w((String)TAG, (String)("Failed to invoke querySupportedCardRequirePermissionList " + e));
            }
        } else {
            Log.e((String)TAG, (String)"Failed to invoke querySupportedCardDescription, service is disconnected");
        }
        return new ArrayList<String>();
    }

    public List<String> querySupportedCardRequirePermissionList() {
        if (this.mRemoteInterface.isConnected()) {
            try {
                this.mCache.mSupportedCardRequirePermissionList = this.mRemoteInterface.getInterface().querySupportedCardRequirePermissionList(this.mContext.getPackageName(), null);
            }
            catch (RemoteException | SecurityException e) {
                Log.w((String)TAG, (String)("Failed to invoke querySupportedCardRequirePermissionList " + e));
            }
        } else {
            Log.e((String)TAG, (String)"Failed to invoke querySupportedCardDescription, service is disconnected");
        }
        return this.mCache.mSupportedCardRequirePermissionList != null ? this.mCache.mSupportedCardRequirePermissionList : new ArrayList();
    }

    public boolean isCardFeatureEnabled() {
        if (this.mRemoteInterface.isConnected()) {
            try {
                this.mCache.mIsCardFeatureEnabled = this.mRemoteInterface.getInterface().isCardFeatureSettingsEnabled(this.mContext.getPackageName());
                return this.mCache.mIsCardFeatureEnabled;
            }
            catch (RemoteException | SecurityException e) {
                Log.w((String)TAG, (String)("Failed to invoke isCardFeatureEnabled " + e));
            }
        } else {
            Log.e((String)TAG, (String)"Failed to invoke isCardFeatureEnabled, service is disconnected");
        }
        return this.mCache.mIsCardFeatureEnabled;
    }

    public LauncherConfig getCardConfig(KolunCard card) {
        if (card == null) {
            return null;
        }
        if (this.mRemoteInterface.isConnected()) {
            try {
                LauncherConfig config = this.mRemoteInterface.getInterface().getCardConfig(this.mContext.getPackageName(), card.cardId);
                if (config == null) {
                    config = this.getCardConfigFromLocal(card);
                }
                return config;
            }
            catch (RemoteException | SecurityException e) {
                Log.w((String)TAG, (String)("Failed to invoke getCardConfig " + e));
            }
        }
        return this.getCardConfigFromLocal(card);
    }

    private LauncherConfig getCardConfigFromLocal(KolunCard card) {
        if (card == null) {
            return null;
        }
        return new LauncherConfig(card.getConfigId(), card.getConfigSlot(), card.getConfigDefPriority(), card.getConfigMajorPriority());
    }

    public void toggleCardFeature(boolean enable) {
        if (this.mRemoteInterface.isConnected()) {
            try {
                this.mRemoteInterface.getInterface().setCardFeatureSettingsState(this.mContext.getPackageName(), enable);
            }
            catch (RemoteException | SecurityException e) {
                Log.w((String)TAG, (String)("Failed to invoke setCardFeatureSettingsState " + e));
            }
        } else {
            Log.e((String)TAG, (String)"Failed to invoke setCardFeatureSettingsState, service is disconnected");
        }
    }

    public void toggleCardFeature(boolean enable, int[] uncontrolledIds) {
        if (this.mRemoteInterface.isConnected()) {
            try {
                this.mRemoteInterface.getInterface().setCardFeatureSettingsStateExt(this.mContext.getPackageName(), enable, uncontrolledIds);
            }
            catch (RemoteException e) {
                Log.e((String)TAG, (String)"Failed to invoke setCardFeatureSettingsStateExt, service is disconnected");
            }
        }
    }

    public KolunCardProtocol getCardProtocol() {
        if (this.mRemoteInterface.isConnected()) {
            try {
                return this.mRemoteInterface.getInterface().getCardProtocol(this.mContext.getPackageName());
            }
            catch (RemoteException | SecurityException e) {
                Log.w((String)TAG, (String)("Failed to invoke getCardProtocol " + e));
            }
        } else {
            Log.e((String)TAG, (String)"Failed to invoke getCardProtocol, service is disconnected");
        }
        return null;
    }

    public static boolean isServiceAvailable(@NonNull Context context) {
        PackageManager pm = context.getPackageManager();
        List list = pm.queryIntentServices(SERVICE_INTENT, 131072);
        return list != null && list.size() > 0;
    }

    private boolean connect(String reason) {
        if (DEBUG) {
            Log.d((String)TAG, (String)("ask connect, reason is " + reason));
        }
        if (!this.mRemoteInterface.isConnected()) {
            Log.d((String)TAG, (String)("connect, reason is " + reason));
            try {
                return this.mContext.bindService(SERVICE_INTENT, this.mServiceConnection, 0x40000001);
            }
            catch (SecurityException e) {
                Log.w((String)TAG, (String)("failed to connect remote services, " + e));
                return false;
            }
        }
        return true;
    }

    private void disconnect(String reason) {
        if (DEBUG) {
            Log.d((String)TAG, (String)("ask disconnect, reason is " + reason));
        }
        if (this.mRemoteInterface.isConnected()) {
            Log.d((String)TAG, (String)("disconnect, reason is " + reason));
            try {
                this.mRemoteInterface.getInterface().unlisten(this.mContext.getPackageName(), LocalListener.getInstance());
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
            if (this.mRemoteInterface.isConnected()) {
                this.mContext.unbindService(this.mServiceConnection);
                this.mRemoteInterface.remove();
            }
        }
        if (this.mCache != null && this.mCache.mAvailableCardList != null) {
            this.mCache.mAvailableCardList.clear();
        }
    }

    public class Cache {
        boolean mIsCardFeatureEnabled = false;
        List<String> mSupportedCardRequirePermissionList = null;
        int[] mSupportedCardIds = null;
        List<KolunCard> mAvailableCardList = null;
    }

    public static interface Callback {
        public void onServiceConnected();

        public void onServiceDisconnected();
    }

    private static class SafeListener
    extends IListener.Stub {
        private final WeakReference<IListener> mWeakListener;

        private SafeListener(IListener listener) {
            this.mWeakListener = new WeakReference<IListener>(listener);
        }

        public final IListener getListener() {
            return (IListener)this.mWeakListener.get();
        }

        @Override
        public void onCardUpdated(KolunCard card) throws RemoteException {
            IListener listener = (IListener)this.mWeakListener.get();
            if (listener != null) {
                listener.onCardUpdated(card);
            }
        }

        @Override
        public void onCardStatusChanged(KolunCard card, boolean available) throws RemoteException {
            IListener listener = (IListener)this.mWeakListener.get();
            if (listener != null) {
                listener.onCardStatusChanged(card, available);
            }
        }
    }

    static class LocalListener
    extends IListener.Stub {
        private static final LocalListener sInstance = new LocalListener();
        private List<SafeListener> mRegisteredListenList = new ArrayList<SafeListener>();

        LocalListener() {
        }

        public static LocalListener getInstance() {
            return sInstance;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void register(IListener listener) {
            List<SafeListener> list = this.mRegisteredListenList;
            synchronized (list) {
                for (SafeListener safeListener : this.mRegisteredListenList) {
                    if (safeListener.getListener() != listener) continue;
                    Log.w((String)KolunCardManager.TAG, (String)"duplicate to register listener");
                    return;
                }
                SafeListener safeListener = new SafeListener(listener);
                this.mRegisteredListenList.add(safeListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unlisten(IListener listener) {
            List<SafeListener> list = this.mRegisteredListenList;
            synchronized (list) {
                SafeListener target = null;
                for (SafeListener safeListener : this.mRegisteredListenList) {
                    if (safeListener.getListener() != listener) continue;
                    target = safeListener;
                    break;
                }
                if (target != null) {
                    this.mRegisteredListenList.remove(target);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCardUpdated(KolunCard card) {
            if (DEBUG) {
                Log.i((String)KolunCardManager.TAG, (String)("onCardUpdated " + card));
            }
            List<SafeListener> list = this.mRegisteredListenList;
            synchronized (list) {
                this.mRegisteredListenList.forEach(listen -> {
                    try {
                        listen.onCardUpdated(card);
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCardStatusChanged(KolunCard card, boolean available) {
            if (DEBUG) {
                Log.i((String)KolunCardManager.TAG, (String)("onCardStatusChanged " + card));
            }
            List<SafeListener> list = this.mRegisteredListenList;
            synchronized (list) {
                this.mRegisteredListenList.forEach(listen -> {
                    try {
                        listen.onCardStatusChanged(card, available);
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                });
            }
        }
    }
}

