/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.kolun.koluncard;

import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.util.Log;
import com.transsion.kolun.koluncard.ICardProtocol;

public class KolunCardProtocol
implements Parcelable {
    private static final String TAG = "KolunCardProtocol";
    public static final String KEY_PROTOCOL_URL = "key_protocol_url";
    public static final String KEY_PROTOCOL_VIEW = "key_protocol_view_which";
    private final ICardProtocol mCardProtocol;
    public static final Parcelable.Creator<KolunCardProtocol> CREATOR = new Parcelable.Creator<KolunCardProtocol>(){

        public KolunCardProtocol createFromParcel(Parcel in) {
            return new KolunCardProtocol(in);
        }

        public KolunCardProtocol[] newArray(int size) {
            return new KolunCardProtocol[size];
        }
    };

    public KolunCardProtocol(ICardProtocol cardProtocol) {
        this.mCardProtocol = cardProtocol;
    }

    protected KolunCardProtocol(Parcel in) {
        this.mCardProtocol = ICardProtocol.Stub.asInterface(in.readStrongBinder());
    }

    public boolean isProtocolAccept() {
        try {
            boolean isAccept = this.mCardProtocol.isProtocolAccept();
            Log.d((String)TAG, (String)("isProtocolAccept: " + isAccept));
            return isAccept;
        }
        catch (RemoteException e) {
            Log.e((String)TAG, (String)("Failed to invoke isProtocolAccept, service is disconnected e:" + (Object)((Object)e)));
            return false;
        }
    }

    public int getProtocolType() {
        try {
            int type = this.mCardProtocol.getProtocolType();
            Log.d((String)TAG, (String)("getProtocolType: " + type));
            return type;
        }
        catch (RemoteException e) {
            Log.e((String)TAG, (String)("Failed to invoke getProtocolType e: " + (Object)((Object)e)));
            return -1;
        }
    }

    public void toggleProtocol(boolean enable) {
        try {
            this.mCardProtocol.toggleProtocol(enable);
        }
        catch (RemoteException | SecurityException e) {
            Log.e((String)TAG, (String)("Failed to invoke toggleProtocol e: " + e));
        }
    }

    public boolean toggleCardProtocol(int cardId, boolean enable) {
        try {
            return this.mCardProtocol.toggleCardProtocol(cardId, enable);
        }
        catch (RemoteException e) {
            Log.e((String)TAG, (String)("Failed to invoke toggleCardProtocol e: " + (Object)((Object)e)));
            return false;
        }
    }

    public boolean isProtocolEnable(int cardId) {
        try {
            return this.mCardProtocol.isProtocolEnable(cardId);
        }
        catch (RemoteException e) {
            Log.e((String)TAG, (String)("Failed to invoke isProtocolEnable e: " + (Object)((Object)e)));
            return false;
        }
    }

    public String getPrivacyPolicyUrl() {
        try {
            return this.mCardProtocol.getPrivacyPolicyUrl();
        }
        catch (RemoteException e) {
            Log.e((String)TAG, (String)("Failed to invoke getPrivacyPolicyUrl e: " + (Object)((Object)e)));
            return null;
        }
    }

    public String getUserProtocolUrl() {
        try {
            return this.mCardProtocol.getUserProtocolUrl();
        }
        catch (RemoteException e) {
            Log.e((String)TAG, (String)("Failed to invoke getUserProtocolUrl e: " + (Object)((Object)e)));
            return null;
        }
    }

    public boolean isProtocolConstraintCard(int cardId) {
        try {
            return this.mCardProtocol.isProtocolConstraintCard(cardId);
        }
        catch (RemoteException e) {
            Log.e((String)TAG, (String)("Failed to invoke getUserProtocolUrl e: " + (Object)((Object)e)));
            return false;
        }
    }

    public int getProtocolVersion() {
        try {
            return this.mCardProtocol.getProtocolVersion();
        }
        catch (RemoteException e) {
            Log.e((String)TAG, (String)("Failed to invoke getProtocolVersion e: " + (Object)((Object)e)));
            return -1;
        }
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeStrongBinder(this.mCardProtocol.asBinder());
    }

    public static interface ProtocolView {
        public static final int PRIVACY_POLICY = 1;
        public static final int USER_PROTOCOL = 2;
    }

    public static interface ProtocolType {
        public static final int NORMAL = 1;
        public static final int UPDATE = 2;
        public static final int INVALID = -1;
    }
}

