/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.kolun.koluncard;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import androidx.annotation.RequiresApi;

public class PackageBroadcastReceiver
extends BroadcastReceiver {
    private static final String TAG = "PackageBroadcastReceiver";
    private static volatile PackageBroadcastReceiver receiver;
    private static volatile boolean isInit;
    private final Handler handler = new Handler(Looper.getMainLooper());
    private PackageChange packageChangeCallback;
    private final Runnable mRemovedRunnable = () -> {
        if (this.packageChangeCallback != null) {
            this.packageChangeCallback.removed();
        }
        Log.i((String)TAG, (String)"ACTION_PACKAGE_REMOVED");
    };
    private final Runnable mReplacedRunnable = () -> {
        if (this.packageChangeCallback != null) {
            this.packageChangeCallback.replaced();
        }
        Log.i((String)TAG, (String)"ACTION_PACKAGE_REPLACED");
    };

    public static IntentFilter getIntentFilter() {
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.PACKAGE_REMOVED");
        filter.addAction("android.intent.action.PACKAGE_REPLACED");
        filter.addDataScheme("package");
        return filter;
    }

    public void registerCallBack(PackageChange packageChangeCallback) {
        this.packageChangeCallback = packageChangeCallback;
    }

    public static PackageBroadcastReceiver connect(Context context) {
        if (context == null) {
            return PackageBroadcastReceiver.getInstance();
        }
        if (!isInit) {
            context.registerReceiver((BroadcastReceiver)PackageBroadcastReceiver.getInstance(), PackageBroadcastReceiver.getIntentFilter());
            isInit = true;
        }
        return PackageBroadcastReceiver.getInstance();
    }

    public void unregister(Context context) {
        if (context != null) {
            context.getApplicationContext().unregisterReceiver((BroadcastReceiver)PackageBroadcastReceiver.getInstance());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static PackageBroadcastReceiver getInstance() {
        if (receiver != null) return receiver;
        Class<PackageBroadcastReceiver> clazz = PackageBroadcastReceiver.class;
        synchronized (PackageBroadcastReceiver.class) {
            if (receiver != null) return receiver;
            receiver = new PackageBroadcastReceiver();
            // ** MonitorExit[var0] (shouldn't be in output)
            return receiver;
        }
    }

    @RequiresApi(api=29)
    public void onReceive(Context context, Intent intent) {
        String action = intent.getAction();
        if (null == action) {
            return;
        }
        boolean has = false;
        switch (action) {
            case "android.intent.action.PACKAGE_REMOVED": {
                if (this.handler.hasCallbacks(this.mReplacedRunnable)) {
                    this.handler.removeCallbacks(this.mReplacedRunnable);
                    has = true;
                }
                this.handler.post(this.mRemovedRunnable);
                if (!has) break;
                this.handler.post(this.mReplacedRunnable);
                break;
            }
            case "android.intent.action.PACKAGE_REPLACED": {
                if (this.handler.hasCallbacks(this.mReplacedRunnable)) break;
                this.handler.postDelayed(this.mReplacedRunnable, 500L);
                break;
            }
        }
    }

    static {
        isInit = false;
    }

    public static interface PackageChange {
        public void removed();

        public void replaced();
    }
}

