/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.kolun.koluncard;

import android.content.Context;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.ListAdapter;
import android.widget.TextView;
import androidx.annotation.AttrRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.content.res.AppCompatResources;
import androidx.appcompat.widget.ListPopupWindow;
import com.transsion.kolun.cardtemplate.R;
import com.transsion.kolun.koluncard.KolunCard;
import java.lang.ref.WeakReference;
import java.util.ArrayList;

public class PopMenuHelper {
    private static WeakReference<CardPopupMenu> sTempLauPopMenu;

    public static CardPopupMenu create(Context context, View view, ArrayList<KolunCard.CardPopupMenu> list) {
        return PopMenuHelper.create(context, view, list, null, R.attr.listPopupWindowStyle);
    }

    public static CardPopupMenu create(Context context, View view, ArrayList<KolunCard.CardPopupMenu> list, AdapterView.OnItemClickListener listener, int style2) {
        return PopMenuHelper.create(context, view, list, true, listener, style2);
    }

    public static CardPopupMenu create(Context context, View view, ArrayList<KolunCard.CardPopupMenu> list, boolean absorb, AdapterView.OnItemClickListener listener, int style2) {
        CardPopupMenu popupMenu = new CardPopupMenu(context, style2);
        popupMenu.setAnchorView(view);
        Adapter adapter = new Adapter(context, list);
        popupMenu.setAdapter((ListAdapter)adapter);
        boolean isLandScape = context.getResources().getConfiguration().orientation == 2;
        int divisor = isLandScape ? 3 : 2;
        popupMenu.setWidth(view.getContext().getResources().getDisplayMetrics().widthPixels / divisor);
        popupMenu.setHeight(-2);
        popupMenu.setBackgroundDrawable(AppCompatResources.getDrawable((Context)context, (int)R.drawable.os_popup_background));
        popupMenu.setModal(true);
        popupMenu.setOnItemClickListener(listener);
        popupMenu.setInputMethodMode(2);
        if (absorb) {
            popupMenu.adsorb(context);
        }
        return popupMenu;
    }

    public static boolean closeAllPopMenu() {
        CardPopupMenu lauPopMenu;
        if (sTempLauPopMenu != null && (lauPopMenu = (CardPopupMenu)((Object)sTempLauPopMenu.get())) != null && lauPopMenu.isShowing()) {
            try {
                lauPopMenu.dismiss();
            }
            catch (Exception e) {
                Log.e((String)"", (String)("PopMenuHelper Exception:" + e));
                return false;
            }
            return true;
        }
        sTempLauPopMenu = null;
        return false;
    }

    private static class Adapter
    extends BaseAdapter {
        private LayoutInflater mInflater;
        private ArrayList<KolunCard.CardPopupMenu> mItemList;
        private int mListSize;

        public Adapter(Context context, ArrayList<KolunCard.CardPopupMenu> list) {
            this.mInflater = LayoutInflater.from((Context)context);
            this.mItemList = list;
            this.mListSize = list.size();
        }

        public int getCount() {
            return this.mItemList.size();
        }

        public String getItem(int position) {
            return this.mItemList.get((int)position).label;
        }

        public long getItemId(int position) {
            return position;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            ViewHolder viewHolder;
            if (convertView == null) {
                convertView = this.mInflater.inflate(R.layout.card_menu_item_layout, null);
                viewHolder = new ViewHolder();
                viewHolder.textview = (TextView)convertView.findViewById(R.id.menu_item);
                convertView.setTag((Object)viewHolder);
            } else {
                viewHolder = (ViewHolder)convertView.getTag();
            }
            if (this.mListSize == 1) {
                viewHolder.textview.setBackgroundResource(R.drawable.shape_popup_menu_radius);
            } else if (position == 0) {
                viewHolder.textview.setBackgroundResource(R.drawable.shape_popup_menu_radius_top);
            } else if (position == this.mListSize - 1) {
                viewHolder.textview.setBackgroundResource(R.drawable.shape_popup_menu_radius_bottom);
            }
            viewHolder.textview.setText((CharSequence)this.mItemList.get((int)position).label);
            return convertView;
        }

        private static class ViewHolder {
            TextView textview;

            private ViewHolder() {
            }
        }
    }

    public static class CardPopupMenu
    extends ListPopupWindow {
        public CardPopupMenu(@NonNull Context context) {
            this(context, null, R.attr.listPopupWindowStyle);
        }

        public CardPopupMenu(@NonNull Context context, int style2) {
            this(context, null, 0, style2);
        }

        public CardPopupMenu(@NonNull Context context, @Nullable AttributeSet attrs) {
            this(context, attrs, R.attr.listPopupWindowStyle);
        }

        public CardPopupMenu(@NonNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr) {
            this(context, attrs, defStyleAttr, 0);
        }

        public CardPopupMenu(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
            super(context, attrs, defStyleAttr, defStyleRes);
        }

        public CardPopupMenu adsorb(Context context) {
            View anchorView = this.getAnchorView();
            if (anchorView != null) {
                int[] outLocation = new int[2];
                anchorView.getLocationOnScreen(outLocation);
                int screenWidth = anchorView.getContext().getResources().getDisplayMetrics().widthPixels;
                int padding = context.getResources().getDimensionPixelOffset(R.dimen.popup_item_padding);
                int widthPadding = context.getResources().getDimensionPixelOffset(R.dimen.popup_item_padding_lr);
                if (outLocation[0] <= screenWidth / 2) {
                    this.setHorizontalOffset(-(outLocation[0] - padding + widthPadding));
                } else {
                    this.setHorizontalOffset(-(screenWidth - padding - this.getWidth() - widthPadding));
                }
            }
            return this;
        }

        public void show() {
            super.show();
            sTempLauPopMenu = new WeakReference<CardPopupMenu>(this);
        }
    }
}

