/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.kolun.notifycation;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.widget.RemoteViews;
import androidx.annotation.Nullable;
import androidx.core.app.NotificationCompat;
import com.transsion.kolun.notifycation.KolunNotificationChannel;
import com.transsion.kolun.notifycation.R;

public class KolunNotificationCreater {
    private static final String TAG = "BaseKolunNotification";
    private final NotificationCallback mCallback;

    public KolunNotificationCreater(NotificationCallback callback) {
        this.mCallback = callback;
    }

    public void createNotification(Context context, int notificationId, String content) {
        this.createNotification(context, notificationId, content);
    }

    public void createNotification(Context context, int notificationId, String content, PendingIntent contentPI) {
        this.createNotification(context, notificationId, content, contentPI, null);
    }

    public void createNotification(Context context, int notificationId, String title, String content, PendingIntent contentPI) {
        this.createNotification(context, notificationId, title, content, contentPI, null);
    }

    public void createNotification(Context context, int notificationId, String title, String content, PendingIntent contentPI, boolean autoCancel) {
        this.createNotification(context, notificationId, title, content, contentPI, "high", autoCancel, null);
    }

    public void createNotification(Context context, int notificationId, String content, @Nullable NotificationCompat.Action action) {
        this.createNotification(context, notificationId, content, null, action);
    }

    public void createNotification(Context context, int notificationId, String content, PendingIntent contentPI, NotificationCompat.Action action) {
        this.createNotification(context, notificationId, content, contentPI, "high", true, action);
    }

    public void createNotification(Context context, int notificationId, String title, String content, PendingIntent contentPI, NotificationCompat.Action action) {
        this.createNotification(context, notificationId, title, content, contentPI, "high", true, action);
    }

    public void createNotification(Context context, int notificationId, String content, PendingIntent contentPI, String ChannelId, boolean autoCancel, NotificationCompat.Action action) {
        NotificationCompat.BigTextStyle style = new NotificationCompat.BigTextStyle().bigText((CharSequence)content);
        this.createNotification(context, notificationId, content, contentPI, ChannelId, autoCancel, (NotificationCompat.Style)style, action);
    }

    public void createNotification(Context context, int notificationId, String title, String content, PendingIntent contentPI, String ChannelId, boolean autoCancel, NotificationCompat.Action action) {
        NotificationCompat.BigTextStyle style = new NotificationCompat.BigTextStyle().bigText((CharSequence)content);
        this.createNotification(context, notificationId, title, content, contentPI, ChannelId, autoCancel, (NotificationCompat.Style)style, action);
    }

    public void createNotification(Context context, int notificationId, String content, PendingIntent contentPI, String channelId, boolean autoCancel, NotificationCompat.Style style, NotificationCompat.Action action) {
        this.createNotification(context, notificationId, null, content, contentPI, channelId, autoCancel, style, action);
    }

    public void createNotification(Context context, int notificationId, String title, String content, PendingIntent contentPI, String channelId, boolean autoCancel, NotificationCompat.Style style, NotificationCompat.Action action) {
        this.createNotification(context, notificationId, title, content, contentPI, channelId, autoCancel, style, "", null, null, null, action);
    }

    public void createNotification(Context context, int notificationId, String title, String content, PendingIntent contentPI, String channelId, boolean autoCancel, NotificationCompat.Style style, String groupKey, Bundle extra, RemoteViews customContentView, RemoteViews customBigContentView, NotificationCompat.Action action) {
        NotificationCompat.Builder nb = this.createBuilder(context, channelId);
        nb.setContentText((CharSequence)content);
        nb.setContentIntent(contentPI);
        nb.setAutoCancel(autoCancel);
        nb.setShowWhen(true);
        if (style != null) {
            nb.setStyle(style);
        }
        if (!TextUtils.isEmpty((CharSequence)title)) {
            nb.setContentTitle((CharSequence)title);
        }
        if (extra != null && !extra.isEmpty()) {
            nb.setExtras(extra);
        }
        if (!TextUtils.isEmpty((CharSequence)groupKey)) {
            nb.setGroup(groupKey);
        }
        if (customContentView != null) {
            nb.setCustomContentView(customContentView);
        }
        if (customBigContentView != null) {
            nb.setCustomBigContentView(customBigContentView);
        }
        if (null != action) {
            nb.addAction(action);
        }
        this.notifyNotification(context, notificationId, nb.build());
    }

    public void notifyNotification(Context context, int notificationId, Notification notification) {
        NotificationManager nm = this.getManager(context);
        if (nm != null) {
            Log.d((String)TAG, (String)("notificationId : " + notificationId));
            nm.notify(notificationId, notification);
            if (null != this.mCallback) {
                this.mCallback.onNotify(notificationId);
            }
        }
    }

    private NotificationManager getManager(Context context) {
        return KolunNotificationChannel.getInstance().createAllNotificationChannels(context);
    }

    private NotificationCompat.Builder createBuilder(Context context, String channelId) {
        NotificationCompat.Builder nb = new NotificationCompat.Builder(context, channelId);
        nb.setSmallIcon(R.mipmap.notification_icon);
        return nb;
    }

    public void cancelNotification(Context context, int notificationId) {
        NotificationManager nm = this.getManager(context);
        if (nm != null) {
            nm.cancel(notificationId);
        }
    }

    static interface NotificationCallback {
        public void onNotify(int var1);
    }
}

