/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.kolun.notifycation;

import android.app.ActivityOptions;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.util.Log;
import android.view.Window;
import android.view.WindowManager;
import androidx.appcompat.app.AppCompatActivity;
import com.transsion.kolun.notifycation.KolunNotification;
import com.transsion.kolun.notifycation.R;

public class NotificationAssistantActivity
extends AppCompatActivity {
    private static final String TAG = "NotificationAssistantActivity";
    private static final String GOOGLE_MAP_PACKAGE_NAME = "com.google.android.apps.maps";

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_notification_assistant);
        Log.d((String)TAG, (String)"onCreate");
        Window window = this.getWindow();
        window.setGravity(0x800033);
        window.addFlags(16);
        WindowManager.LayoutParams layoutParams = window.getAttributes();
        layoutParams.x = 0;
        layoutParams.y = 0;
        layoutParams.width = 1;
        layoutParams.height = 1;
        window.setAttributes(layoutParams);
    }

    public void onResume() {
        super.onResume();
        new Handler(Looper.myLooper()).postDelayed(() -> this.doNotificationAction(this.getIntent()), 500L);
    }

    private void doNotificationAction(Intent intent) {
        if (intent != null && intent.getAction() != null) {
            switch (intent.getAction()) {
                case "com.transsion.kolun.assistant.ui.notification.ACTION_LOCK_SCREEN_FLIGHT": {
                    this.doScreenLockFlightNavigation(intent);
                }
            }
        }
        this.finish();
    }

    private void doScreenLockFlightNavigation(Intent intent) {
        int notificationId = intent.getIntExtra("notificationId", -1);
        String navAdd = intent.getStringExtra("extra");
        Log.d((String)TAG, (String)("navAdd : " + navAdd));
        this.startNavAdd(navAdd);
        KolunNotification.getInstance().cancelNotification((Context)this, notificationId);
    }

    private void startNavAdd(String navAdd) {
        if (TextUtils.isEmpty((CharSequence)navAdd)) {
            return;
        }
        Uri gmmIntentUri = Uri.parse((String)("geo:0,0?q=" + navAdd));
        Intent mapIntent = new Intent("android.intent.action.VIEW", gmmIntentUri);
        mapIntent.setFlags(0x10000000);
        mapIntent.setPackage(GOOGLE_MAP_PACKAGE_NAME);
        this.getApplication().startActivity(mapIntent, NotificationAssistantActivity.getActivityOptionsAnimation((Context)this.getApplication()).toBundle());
    }

    protected void onDestroy() {
        super.onDestroy();
        Log.d((String)TAG, (String)"onDestroy");
    }

    public static ActivityOptions getActivityOptionsAnimation(Context context) {
        return ActivityOptions.makeCustomAnimation((Context)context.getApplicationContext(), (int)R.anim.activity_open_enter, (int)R.anim.activity_open_exit);
    }
}

